/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticalSwitch.java,v 1.4 2009/05/05 15:49:20 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDContiguousRepresentation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteRepresentation;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDTextRepresentation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalPackage;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.model.statistical.StatisticalPackage
 * @generated
 */
public class StatisticalSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static StatisticalPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatisticalSwitch() {
		if (modelPackage == null) {
			modelPackage = StatisticalPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case StatisticalPackage.SD_DESCRIPTOR: {
				SDDescriptor sdDescriptor = (SDDescriptor)theEObject;
				T result = caseSDDescriptor(sdDescriptor);
				if (result == null) result = caseAbstractTRCDescription(sdDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR: {
				SDMemberDescriptor sdMemberDescriptor = (SDMemberDescriptor)theEObject;
				T result = caseSDMemberDescriptor(sdMemberDescriptor);
				if (result == null) result = caseSDDescriptor(sdMemberDescriptor);
				if (result == null) result = caseAbstractTRCDescription(sdMemberDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_GAUGE_REPRESENTATION: {
				SDGaugeRepresentation sdGaugeRepresentation = (SDGaugeRepresentation)theEObject;
				T result = caseSDGaugeRepresentation(sdGaugeRepresentation);
				if (result == null) result = caseSDRangeRepresentation(sdGaugeRepresentation);
				if (result == null) result = caseSDDiscreteRepresentation(sdGaugeRepresentation);
				if (result == null) result = caseSDRepresentation(sdGaugeRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_SAMPLE_DESCRIPTOR: {
				SDSampleDescriptor sdSampleDescriptor = (SDSampleDescriptor)theEObject;
				T result = caseSDSampleDescriptor(sdSampleDescriptor);
				if (result == null) result = caseSDMemberDescriptor(sdSampleDescriptor);
				if (result == null) result = caseSDDescriptor(sdSampleDescriptor);
				if (result == null) result = caseAbstractTRCDescription(sdSampleDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_VIEW: {
				SDView sdView = (SDView)theEObject;
				T result = caseSDView(sdView);
				if (result == null) result = caseAbstractTRCView(sdView);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_SAMPLE_WINDOW: {
				SDSampleWindow sdSampleWindow = (SDSampleWindow)theEObject;
				T result = caseSDSampleWindow(sdSampleWindow);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION: {
				SDSnapshotObservation sdSnapshotObservation = (SDSnapshotObservation)theEObject;
				T result = caseSDSnapshotObservation(sdSnapshotObservation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_DISCRETE_OBSERVATION: {
				SDDiscreteObservation sdDiscreteObservation = (SDDiscreteObservation)theEObject;
				T result = caseSDDiscreteObservation(sdDiscreteObservation);
				if (result == null) result = caseSDSnapshotObservation(sdDiscreteObservation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_CONTIGUOUS_OBSERVATION: {
				SDContiguousObservation sdContiguousObservation = (SDContiguousObservation)theEObject;
				T result = caseSDContiguousObservation(sdContiguousObservation);
				if (result == null) result = caseSDSnapshotObservation(sdContiguousObservation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_TEXT_OBSERVATION: {
				SDTextObservation sdTextObservation = (SDTextObservation)theEObject;
				T result = caseSDTextObservation(sdTextObservation);
				if (result == null) result = caseSDSnapshotObservation(sdTextObservation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_RANGE_REPRESENTATION: {
				SDRangeRepresentation sdRangeRepresentation = (SDRangeRepresentation)theEObject;
				T result = caseSDRangeRepresentation(sdRangeRepresentation);
				if (result == null) result = caseSDDiscreteRepresentation(sdRangeRepresentation);
				if (result == null) result = caseSDRepresentation(sdRangeRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_COUNTER_DESCRIPTOR: {
				SDCounterDescriptor sdCounterDescriptor = (SDCounterDescriptor)theEObject;
				T result = caseSDCounterDescriptor(sdCounterDescriptor);
				if (result == null) result = caseSDMemberDescriptor(sdCounterDescriptor);
				if (result == null) result = caseSDDescriptor(sdCounterDescriptor);
				if (result == null) result = caseAbstractTRCDescription(sdCounterDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_REPRESENTATION: {
				SDRepresentation sdRepresentation = (SDRepresentation)theEObject;
				T result = caseSDRepresentation(sdRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_TEXT_REPRESENTATION: {
				SDTextRepresentation sdTextRepresentation = (SDTextRepresentation)theEObject;
				T result = caseSDTextRepresentation(sdTextRepresentation);
				if (result == null) result = caseSDRepresentation(sdTextRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_DISCRETE_REPRESENTATION: {
				SDDiscreteRepresentation sdDiscreteRepresentation = (SDDiscreteRepresentation)theEObject;
				T result = caseSDDiscreteRepresentation(sdDiscreteRepresentation);
				if (result == null) result = caseSDRepresentation(sdDiscreteRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StatisticalPackage.SD_CONTIGUOUS_REPRESENTATION: {
				SDContiguousRepresentation sdContiguousRepresentation = (SDContiguousRepresentation)theEObject;
				T result = caseSDContiguousRepresentation(sdContiguousRepresentation);
				if (result == null) result = caseSDRepresentation(sdContiguousRepresentation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDDescriptor(SDDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Member Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Member Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDMemberDescriptor(SDMemberDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Gauge Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Gauge Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDGaugeRepresentation(SDGaugeRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Sample Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Sample Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDSampleDescriptor(SDSampleDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDView(SDView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Sample Window</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Sample Window</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDSampleWindow(SDSampleWindow object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Snapshot Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Snapshot Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDSnapshotObservation(SDSnapshotObservation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Discrete Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Discrete Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDDiscreteObservation(SDDiscreteObservation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Contiguous Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Contiguous Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDContiguousObservation(SDContiguousObservation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Text Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Text Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDTextObservation(SDTextObservation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Range Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Range Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDRangeRepresentation(SDRangeRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Counter Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Counter Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDCounterDescriptor(SDCounterDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDRepresentation(SDRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Text Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Text Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDTextRepresentation(SDTextRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Discrete Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Discrete Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDDiscreteRepresentation(SDDiscreteRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SD Contiguous Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SD Contiguous Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSDContiguousRepresentation(SDContiguousRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCDescription(AbstractTRCDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCView(AbstractTRCView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //StatisticalSwitch
