/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesCategoryFilter.java,v 1.3 2006/02/08 19:57:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
package org.eclipse.hyades.models.common.configuration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hyades Category Filter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.HyadesCategoryFilter#getFilteredCategoryName <em>Filtered Category Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.HyadesCategoryFilter#getCategoryFilterPairs <em>Category Filter Pairs</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getHyadesCategoryFilter()
 * @model 
 * @generated
 */
public interface HyadesCategoryFilter extends EObject{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Filtered Category Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Filtered Category Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filtered Category Name</em>' attribute.
	 * @see #setFilteredCategoryName(String)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getHyadesCategoryFilter_FilteredCategoryName()
	 * @model 
	 * @generated
	 */
	String getFilteredCategoryName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.HyadesCategoryFilter#getFilteredCategoryName <em>Filtered Category Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Filtered Category Name</em>' attribute.
	 * @see #getFilteredCategoryName()
	 * @generated
	 */
	void setFilteredCategoryName(String value);

	/**
	 * Returns the value of the '<em><b>Category Filter Pairs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.HyadesCategoryFilterPair}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Category Filter Pairs</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Category Filter Pairs</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getHyadesCategoryFilter_CategoryFilterPairs()
	 * @model type="org.eclipse.hyades.models.common.configuration.HyadesCategoryFilterPair" containment="true"
	 * @generated
	 */
	EList getCategoryFilterPairs();

} // HyadesCategoryFilter
