/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CFGCategoryImpl.java,v 1.11 2009/05/05 15:46:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.Messages;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGCategorySelectionMode;
import org.eclipse.hyades.models.common.configuration.CFGCategorySelectionMultiplicity;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Category</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getDisplayName <em>Display Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionMode <em>Selection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionAmount <em>Selection Amount</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGCategoryImpl#getSelectionMultiplicity <em>Selection Multiplicity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class CFGCategoryImpl extends CMNNamedElementImpl implements CFGCategory{
	/**
	 * The default value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplayName()
	 * @generated
	 * @ordered
	 */
	protected static final String DISPLAY_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplayName()
	 * @generated
	 * @ordered
	 */
	protected String displayName = DISPLAY_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSelectionMode() <em>Selection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionMode()
	 * @generated
	 * @ordered
	 */
	protected static final CFGCategorySelectionMode SELECTION_MODE_EDEFAULT = CFGCategorySelectionMode.ENTER_VALUE_LITERAL;

	/**
	 * The cached value of the '{@link #getSelectionMode() <em>Selection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionMode()
	 * @generated
	 * @ordered
	 */
	protected CFGCategorySelectionMode selectionMode = SELECTION_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSelectionAmount() <em>Selection Amount</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionAmount()
	 * @generated
	 * @ordered
	 */
	protected static final int SELECTION_AMOUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSelectionAmount() <em>Selection Amount</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionAmount()
	 * @generated
	 * @ordered
	 */
	protected int selectionAmount = SELECTION_AMOUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getSelectionMultiplicity() <em>Selection Multiplicity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionMultiplicity()
	 * @generated
	 * @ordered
	 */
	protected static final CFGCategorySelectionMultiplicity SELECTION_MULTIPLICITY_EDEFAULT = CFGCategorySelectionMultiplicity.ZERO_LITERAL;

	/**
	 * The cached value of the '{@link #getSelectionMultiplicity() <em>Selection Multiplicity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectionMultiplicity()
	 * @generated
	 * @ordered
	 */
	protected CFGCategorySelectionMultiplicity selectionMultiplicity = SELECTION_MULTIPLICITY_EDEFAULT;

	private String internalDisplayName = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGCategoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.Literals.CFG_CATEGORY;
	}

	public String getDisplayName()
    {
		if(internalDisplayName != null)
			setDisplayName(Messages.getString(internalDisplayName));
        return getDisplayNameGen();
    }

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDisplayNameGen() {
		return displayName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisplayName(String newDisplayName) {
		String oldDisplayName = displayName;
		displayName = newDisplayName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME, oldDisplayName, displayName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGCategorySelectionMode getSelectionMode() {
		return selectionMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelectionMode(CFGCategorySelectionMode newSelectionMode) {
		CFGCategorySelectionMode oldSelectionMode = selectionMode;
		selectionMode = newSelectionMode == null ? SELECTION_MODE_EDEFAULT : newSelectionMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE, oldSelectionMode, selectionMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getSelectionAmount() {
		return selectionAmount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelectionAmount(int newSelectionAmount) {
		int oldSelectionAmount = selectionAmount;
		selectionAmount = newSelectionAmount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT, oldSelectionAmount, selectionAmount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGCategorySelectionMultiplicity getSelectionMultiplicity() {
		return selectionMultiplicity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelectionMultiplicity(CFGCategorySelectionMultiplicity newSelectionMultiplicity) {
		CFGCategorySelectionMultiplicity oldSelectionMultiplicity = selectionMultiplicity;
		selectionMultiplicity = newSelectionMultiplicity == null ? SELECTION_MULTIPLICITY_EDEFAULT : newSelectionMultiplicity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY, oldSelectionMultiplicity, selectionMultiplicity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
				return getDisplayName();
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
				return getSelectionMode();
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
				return getSelectionAmount();
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
				return getSelectionMultiplicity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
				setDisplayName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
				setSelectionMode((CFGCategorySelectionMode)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
				setSelectionAmount((Integer)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
				setSelectionMultiplicity((CFGCategorySelectionMultiplicity)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
				setDisplayName(DISPLAY_NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
				setSelectionMode(SELECTION_MODE_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
				setSelectionAmount(SELECTION_AMOUNT_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
				setSelectionMultiplicity(SELECTION_MULTIPLICITY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CATEGORY__DISPLAY_NAME:
				return DISPLAY_NAME_EDEFAULT == null ? displayName != null : !DISPLAY_NAME_EDEFAULT.equals(displayName);
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MODE:
				return selectionMode != SELECTION_MODE_EDEFAULT;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_AMOUNT:
				return selectionAmount != SELECTION_AMOUNT_EDEFAULT;
			case Common_ConfigurationPackage.CFG_CATEGORY__SELECTION_MULTIPLICITY:
				return selectionMultiplicity != SELECTION_MULTIPLICITY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (displayName: ");
		result.append(displayName);
		result.append(", selectionMode: ");
		result.append(selectionMode);
		result.append(", selectionAmount: ");
		result.append(selectionAmount);
		result.append(", selectionMultiplicity: ");
		result.append(selectionMultiplicity);
		result.append(')');
		return result.toString();
	}

	public void setInternalDisplayName(String displayName)
	{
		this.internalDisplayName = displayName;
	}
	
} //CFGCategoryImpl
