/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CFGClassImpl.java,v 1.10 2009/05/05 15:46:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.impl.PropertyGroupImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getInstances <em>Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getInstantiations <em>Instantiations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class CFGClassImpl extends CMNNamedElementImpl implements CFGClass {
	/**
	 * The cached value of the '{@link #getOperations() <em>Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperations()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGOperation> operations;

	/**
	 * The cached value of the '{@link #getInstances() <em>Instances</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGInstance> instances;

	/**
	 * The cached value of the '{@link #getInstantiations() <em>Instantiations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstantiations()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGInstance> instantiations;
	
	/**
	 * Value of environment variables as defined in 
	 * {@link org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent}.
	 * @see {@link org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent.getEnvironmentVariables()}
	 * @generated NOT
	 * @author bjiang
	 * @since  3.0
	 */
	protected IPropertyGroup environmentVariables;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.Literals.CFG_CLASS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGOperation> getOperations() {
		if (operations == null) {
			operations = new EObjectContainmentWithInverseEList<CFGOperation>(CFGOperation.class, this, Common_ConfigurationPackage.CFG_CLASS__OPERATIONS, Common_ConfigurationPackage.CFG_OPERATION__OWNING_CLASS);
		}
		return operations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGInstance> getInstances() {
		if (instances == null) {
			instances = new EObjectContainmentWithInverseEList<CFGInstance>(CFGInstance.class, this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER);
		}
		return instances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGInstance> getInstantiations() {
		if (instantiations == null) {
			instantiations = new EObjectWithInverseResolvingEList<CFGInstance>(CFGInstance.class, this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE);
		}
		return instantiations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOperations()).basicAdd(otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInstances()).basicAdd(otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInstantiations()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return ((InternalEList<?>)getOperations()).basicRemove(otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return ((InternalEList<?>)getInstances()).basicRemove(otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return ((InternalEList<?>)getInstantiations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return getOperations();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return getInstances();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return getInstantiations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection<? extends CFGOperation>)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection<? extends CFGInstance>)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				getInstantiations().clear();
				getInstantiations().addAll((Collection<? extends CFGInstance>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				getOperations().clear();
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				getInstances().clear();
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				getInstantiations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return instances != null && !instances.isEmpty();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return instantiations != null && !instantiations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public abstract String getLocation();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public abstract ITest getOwner();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public abstract String getResource();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public abstract void setLocation(String location);
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public abstract void setResource(String resource);
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getMethods()
	 */
	public List getMethods() {
		return (List)getOperations();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getEnvironmentVariables()
	 */
	public IPropertyGroup getEnvironmentVariables() {
	    
	    if(environmentVariables == null)
	        environmentVariables = new PropertyGroupImpl();

	    // Remove dependency on associated artifacts. The association shouldn't be there.
	    // bjiang 4/27/2004
/*		for(int i = 0; i < getArtifacts().size(); i++)
		{
			CFGArtifactImpl artifact = (CFGArtifactImpl)getArtifacts().get(i);
			for(int j = 0; j < this.getInstances().size(); j++)
			{
				CFGInstanceImpl instance = (CFGInstanceImpl)this.getInstances().get(j);
				if(artifact.getInstances().contains(instance))
				{
					Vector properties = new Vector();
					for(int k = 0; k < artifact.getPropertyGroups().size(); k++)
					{
						properties.addAll(((CFGPropertyGroupImpl)artifact.getPropertyGroups().get(k)).getProperties());
					}
					propertyGroup.setProperties(properties);
				}
			}
		}
*/	    
		return environmentVariables;
	}

} //CFGClassImpl
