/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CFGInstanceImpl.java,v 1.11 2009/05/05 15:46:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.impl.FacadeUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Instance</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getLifeline <em>Lifeline</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getTestCase <em>Test Case</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getMaxCount <em>Max Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getInitialValue <em>Initial Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getClassOwner <em>Class Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getClassType <em>Class Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGInstanceImpl extends CMNNamedElementImpl implements CFGInstance
{
	/**
	 * The cached value of the '{@link #getLifeline() <em>Lifeline</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLifeline()
	 * @generated
	 * @ordered
	 */
	protected BVRLifeline lifeline;

	/**
	 * The default value of the '{@link #getMaxCount() <em>Max Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxCount()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxCount() <em>Max Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxCount()
	 * @generated
	 * @ordered
	 */
	protected int maxCount = MAX_COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getInitialValue() <em>Initial Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitialValue()
	 * @generated
	 * @ordered
	 */
	protected static final String INITIAL_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getInitialValue() <em>Initial Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitialValue()
	 * @generated
	 * @ordered
	 */
	protected String initialValue = INITIAL_VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getClassType() <em>Class Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassType()
	 * @generated
	 * @ordered
	 */
	protected CFGClass classType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGInstanceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.Literals.CFG_INSTANCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxCount() {
		return maxCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxCount(int newMaxCount) {
		int oldMaxCount = maxCount;
		maxCount = newMaxCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT, oldMaxCount, maxCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getInitialValue() {
		return initialValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitialValue(String newInitialValue) {
		String oldInitialValue = initialValue;
		initialValue = newInitialValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE, oldInitialValue, initialValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRLifeline getLifeline() {
		if (lifeline != null && lifeline.eIsProxy()) {
			InternalEObject oldLifeline = (InternalEObject)lifeline;
			lifeline = (BVRLifeline)eResolveProxy(oldLifeline);
			if (lifeline != oldLifeline) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, oldLifeline, lifeline));
			}
		}
		return lifeline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRLifeline basicGetLifeline() {
		return lifeline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLifeline(BVRLifeline newLifeline, NotificationChain msgs) {
		BVRLifeline oldLifeline = lifeline;
		lifeline = newLifeline;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, oldLifeline, newLifeline);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLifeline(BVRLifeline newLifeline) {
		if (newLifeline != lifeline) {
			NotificationChain msgs = null;
			if (lifeline != null)
				msgs = ((InternalEObject)lifeline).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
			if (newLifeline != null)
				msgs = ((InternalEObject)newLifeline).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
			msgs = basicSetLifeline(newLifeline, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, newLifeline, newLifeline));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestCase getTestCase() {
		if (eContainerFeatureID() != Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE) return null;
		return (TPFTestCase)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTestCase(TPFTestCase newTestCase, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTestCase, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestCase(TPFTestCase newTestCase) {
		if (newTestCase != eInternalContainer() || (eContainerFeatureID() != Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE && newTestCase != null)) {
			if (EcoreUtil.isAncestor(this, newTestCase))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestCase != null)
				msgs = ((InternalEObject)newTestCase).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES, TPFTestCase.class, msgs);
			msgs = basicSetTestCase(newTestCase, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, newTestCase, newTestCase));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGClass getClassOwner() {
		if (eContainerFeatureID() != Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER) return null;
		return (CFGClass)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetClassOwner(CFGClass newClassOwner, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newClassOwner, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassOwner(CFGClass newClassOwner) {
		if (newClassOwner != eInternalContainer() || (eContainerFeatureID() != Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER && newClassOwner != null)) {
			if (EcoreUtil.isAncestor(this, newClassOwner))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newClassOwner != null)
				msgs = ((InternalEObject)newClassOwner).eInverseAdd(this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, CFGClass.class, msgs);
			msgs = basicSetClassOwner(newClassOwner, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, newClassOwner, newClassOwner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGClass getClassType() {
		if (classType != null && classType.eIsProxy()) {
			InternalEObject oldClassType = (InternalEObject)classType;
			classType = (CFGClass)eResolveProxy(oldClassType);
			if (classType != oldClassType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, oldClassType, classType));
			}
		}
		return classType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGClass basicGetClassType() {
		return classType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetClassType(CFGClass newClassType, NotificationChain msgs) {
		CFGClass oldClassType = classType;
		classType = newClassType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, oldClassType, newClassType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassType(CFGClass newClassType) {
		if (newClassType != classType) {
			NotificationChain msgs = null;
			if (classType != null)
				msgs = ((InternalEObject)classType).eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
			if (newClassType != null)
				msgs = ((InternalEObject)newClassType).eInverseAdd(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
			msgs = basicSetClassType(newClassType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, newClassType, newClassType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				if (lifeline != null)
					msgs = ((InternalEObject)lifeline).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
				return basicSetLifeline((BVRLifeline)otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTestCase((TPFTestCase)otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetClassOwner((CFGClass)otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				if (classType != null)
					msgs = ((InternalEObject)classType).eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
				return basicSetClassType((CFGClass)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				return basicSetLifeline(null, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				return basicSetTestCase(null, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				return basicSetClassOwner(null, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				return basicSetClassType(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES, TPFTestCase.class, msgs);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				return eInternalContainer().eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, CFGClass.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				if (resolve) return getLifeline();
				return basicGetLifeline();
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				return getTestCase();
			case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
				return getMaxCount();
			case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
				return getInitialValue();
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				return getClassOwner();
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				if (resolve) return getClassType();
				return basicGetClassType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				setLifeline((BVRLifeline)newValue);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				setTestCase((TPFTestCase)newValue);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
				setMaxCount((Integer)newValue);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
				setInitialValue((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				setClassOwner((CFGClass)newValue);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				setClassType((CFGClass)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				setLifeline((BVRLifeline)null);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				setTestCase((TPFTestCase)null);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
				setMaxCount(MAX_COUNT_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
				setInitialValue(INITIAL_VALUE_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				setClassOwner((CFGClass)null);
				return;
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				setClassType((CFGClass)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
				return lifeline != null;
			case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
				return getTestCase() != null;
			case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
				return maxCount != MAX_COUNT_EDEFAULT;
			case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
				return INITIAL_VALUE_EDEFAULT == null ? initialValue != null : !INITIAL_VALUE_EDEFAULT.equals(initialValue);
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
				return getClassOwner() != null;
			case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
				return classType != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (maxCount: ");
		result.append(maxCount);
		result.append(", initialValue: ");
		result.append(initialValue);
		result.append(')');
		return result.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IVariable#getType()
	 */
	public String getType() {
		CFGClassImpl type = (CFGClassImpl)getClassType();
		return type.getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IVariable#setType(java.lang.String)
	 */
	public void setType(String type) {
		CFGClassImpl cls = (CFGClassImpl)FacadeUtil.INSTANCE.getType(type, (ITest)getTestCase());
		setClassType(cls);
	}

} //CFGInstanceImpl
