/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPLCellImpl.java,v 1.16 2009/05/05 15:51:28 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.util.DPLPasswordCollection;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.models.common.util.EncryptionManager;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Cell</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl#getValue <em>Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl#getVariable <em>Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLCellImpl extends EObjectImpl 
                         implements DPLCell 
{
	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final String VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected String value = VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getVariable() <em>Variable</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariable()
	 * @generated
	 * @ordered
	 */
	protected DPLVariable variable;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLCellImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_DatapoolPackage.Literals.DPL_CELL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(String newValue) {
		String oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_CELL__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLVariable getVariable() {
		if (variable != null && variable.eIsProxy()) {
			InternalEObject oldVariable = (InternalEObject)variable;
			variable = (DPLVariable)eResolveProxy(oldVariable);
			if (variable != oldVariable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_DatapoolPackage.DPL_CELL__VARIABLE, oldVariable, variable));
			}
		}
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLVariable basicGetVariable() {
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVariable(DPLVariable newVariable) {
		DPLVariable oldVariable = variable;
		variable = newVariable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_CELL__VARIABLE, oldVariable, variable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				return getValue();
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				if (resolve) return getVariable();
				return basicGetVariable();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				setValue((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				setVariable((DPLVariable)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				setVariable((DPLVariable)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				return VALUE_EDEFAULT == null ? value != null : !VALUE_EDEFAULT.equals(value);
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				return variable != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (value: ");
		result.append(value);
		result.append(')');
		return result.toString();
	}

	//beginning of non-generated classes

	//org.eclipse.hyades.edit.datapool.IDatapoolCell methods

	/**
	 * Defines the {@link IDatapoolVariable variable} that is used to reference
	 * this cell within a {@link IDatapoolRecord record}.
	 * 
	 * @param	variable	The {@link IDatapoolVariable variable} will be used to reference
	 *			this cell within a {@link IDatapoolRecord record}.
	 */
	public void setVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable)
	{
		this.setVariable((DPLVariable)variable);		
	}
		
	/**
	 * The unprocessed string representation of the cell is returned.
	 * 
	 * @return	The unprocessed string representation of the cell.
	 * 
	 * @see #setRawValue()
	 */
	public String getPersistedRepresentation(){
		if(this.getValue() != null)
			return this.getValue();	
		else
			return wrapAsLiteral(new String());
	}
	
	/**
	 * Access to the {@link IDatapoolVariable variable} that is used to reference
	 * this cell within a {@link IDatapoolRecord record}.
	 * 
	 * @return	The {@link IDatapoolVariable variable} that is used to reference
	 *			this cell within a {@link IDatapoolRecord record}.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable getCellVariable()
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)getVariable();
	}

	/**
	 * Access to the {@link IDatapoolRecord record} that is the parent of this
	 * cell.
	 * 
	 * @return	The {@link IDatapoolRecord record} that is the parent of this
	 *			cell.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getCellRecord()
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)this.eContainer();
	}

	/**
	 * <p>Pre-compiled pattern for matching the open/close tag names and enclosed 
	 * character data of an XML fragment.  For example:</p>
	 * 
	 * <p><code>&lt;[white space]OPEN_TAG_NAME[white space]&gt;CHARACTER_DATA&lt;/[white space]CLOSE_TAG_NAME[white space]&gt;</code></p>
	 * 
	 * <p>The open tag name is in the first group, the character data is in the second group, and
	 * the close tag name is in the third group.</p>
	 * 
	 * <p>Note, the input string is assumed to be trimmed.</p>
	 */
	private static final Pattern XML_FRAGMENT_PATTERN = Pattern.compile("<\\s*(\\w+)\\s*>(.*)</\\s*(\\w+)\\s*>"); //$NON-NLS-1$	
	private static final String START_LITERAL = "<Literal>"; //$NON-NLS-1$
	private static final String END_LITERAL = "</Literal>"; //$NON-NLS-1$

	/**
	 * The value associated with the cell is returned.
	 * 
	 * @return The value associated with the cell is returned.
	 */
	public Object getCellValue(){	

		String cellValue = getValue();
		
		if(cellValue == null){
			return null;
		}

		String trimmedCellValue = cellValue.trim();

		//Performance optimization to determine if an XML fragment cell value (e.g. <[tag]>[value]</[tag]>):
		if(trimmedCellValue.startsWith("<")) {
					
			//Performance optimization for unwrapping literal cell values (e.g. <Literal>[value]</Literal>):
			if((trimmedCellValue.startsWith(START_LITERAL)) && (trimmedCellValue.endsWith(END_LITERAL))){
				return (decryptValue(trimmedCellValue.substring((START_LITERAL.length()), (trimmedCellValue.length() - END_LITERAL.length()))));
			}
											
			try {		
				
				//Parse the cell value:
				Matcher matcher = XML_FRAGMENT_PATTERN.matcher(trimmedCellValue);

			    //Determine if an XML fragment cell value:
				if(matcher.matches()){

					//Resolve the datapool evaluator for the XML tag:
			    	IDatapoolEvaluatorExt evaluator = DatapoolUtil.findDatapoolEvaluator(matcher.group(1));
			    	
			    	//Determine if the datapool evaluator exists for the XML tag: 
			    	if(evaluator != null){
			    		return (decryptValue(evaluator.evaluate(matcher.group(2))));
			    	}
				}				
		    }
			catch (Throwable t) {
		    	//Ignore since an invalid/unsupported tag.
		    }	
		}

		return (decryptValue(cellValue));
	}  
	
	/**
	 * A shortcut for the <code>String</code> value associated with the cell is returned.
	 * If the value in the cell is not a <code>String</code> value then it is
	 * converted to a <code>String</code> before being returned.
	 * 
	 * @return	The <code>String</code> value associated with the cell.
	 */
	public String getStringValue()
	{
		Object cellValue = this.getCellValue();
		if(cellValue != null)
			return cellValue.toString();
		else
			return new String();
	}
	
	/**
	 * A shortcut for the <code>long</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>long</code> value then an attempt
	 * is made to convert the value to a <code>long</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>long</code> value associated with the cell.
	 */
	public long getLongValue()
	{
		return Long.parseLong((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>int</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>int</code> value then an attempt
	 * is made to convert the value to a <code>int</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>int</code> value associated with the cell.
	 */
	public int getIntValue()
	{
		return Integer.parseInt((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>short</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>short</code> value then an attempt
	 * is made to convert the value to a <code>short</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>short</code> value associated with the cell.
	 */
	public short getShortValue()
	{
		return Short.parseShort((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>byte</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>byte</code> value then an attempt
	 * is made to convert the value to a <code>byte</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>byte</code> value associated with the cell.
	 */
	public byte getByteValue()
	{
		return Byte.parseByte((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>double</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>double</code> value then an attempt
	 * is made to convert the value to a <code>double</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>double</code> value associated with the cell.
	 */
	public double getDoubleValue()
	{
		return Double.parseDouble((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>float</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>float</code> value then an attempt
	 * is made to convert the value to a <code>float</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>float</code> value associated with the cell.
	 */
	public float getFloatValue()
	{
		return Float.parseFloat((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>boolean</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>boolean</code> value then an attempt
	 * is made to convert the value to a <code>boolean</code>.  If the value can not
	 * be converted an appropriate exception will be thrown.
	 * 
	 * @return	The <code>boolean</code> value associated with the cell.
	 */
	public boolean getBooleanValue()
	{
		return Boolean.valueOf((String)this.getCellValue()).booleanValue();
	}
	
	/**
	 * A shortcut for the <code>char</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>char</code> value then an attempt
	 * is made to convert the value to a <code>char</code>.  If more then one 
	 * character is represented in the value only the first character will be
	 * returned.
	 * 
	 * @return	The <code>char</code> value associated with the cell.
	 */
	public char getCharValue()
	{
		return ((String)this.getCellValue()).charAt(0);
	}

	/**
	 * Replace the unprocessed persisted string representation.
	 * 
	 * @param	value		The value to be associated with this cell.
	 * 
	 * @see #getRawValue()
	 */
	public void setPersistedRepresentation(String value) 
	{
		this.setValue(value);			
	}
	
	/**
	 * Replace the value associated with the cell.
	 * 
	 * @param value The value to be associated with this cell.
	 * @see #getCellValue()
	 */	
	public void setCellValue(Object cellObject){
		
		if(cellObject == null){
			setValue("");
		}
		else{
			
			String cellValue = cellObject.toString();
			String trimmedCellValue = cellValue.trim();

			//Performance optimization to determine if an XML fragment cell value (e.g. <[tag]>[value]</[tag]>):
			if(trimmedCellValue.startsWith("<")) {
		        
				try {	

					//Parse the cell value:
					Matcher matcher = XML_FRAGMENT_PATTERN.matcher(trimmedCellValue);

				    //Determine if an XML fragment cell value and a datapool evaluator exists for the tag:
					if((matcher.matches()) && (DatapoolUtil.findDatapoolEvaluator(matcher.group(1)) != null)){

			    		setValue(cellValue);
			    			
			    		return;
			    	}
			    }
			    catch (Throwable t) {
			    	//Ignore since an invalid/unsupported tag.
			    }
			}
			
			if((trimmedCellValue.startsWith(START_LITERAL)) && (trimmedCellValue.endsWith(END_LITERAL))){			
				setValue(cellValue);
			}
			else{
				setValue(wrapAsLiteral(cellValue));
			}
		}
	}

	/**
	 * Clones the value associated with the cell.
	 *
	 * @return  A exact duplicate of the value.
	 */
	public Object getClonedCellValue()
	{
		return this.getCellValue();
	}

	/*
	 * Wraps the text in tags that indicate the text is a literal.  All cell 
	 * values in this release are literals.  Returns the wrapped string.
	 */	
	private String wrapAsLiteral(String text)
	{
		if(text != null)
			return START_LITERAL + text + END_LITERAL;
		else
			return START_LITERAL + END_LITERAL;
	}	
	
	/**
	 * Decrypts the parameter value using the datapool's password.
	 * <p/>
	 * This method returns the parameter value if the variable is not 
	 * encrypted, or the parameter value is <code>null</code> or not a 
	 * {@link String}.
	 * 
	 * @param value The value to decrypt.
	 * @return The decrypted value, otherwise the parameter value.
	 */
	private Object decryptValue(Object value){
		
		if((getVariable().isEncrypted()) && (value instanceof String)){
			
		    String datapoolName = getCellRecord().getEquivalenceClass().getDatapool().getName();
		    Map datapoolPasswordMap = DPLPasswordCollection.getInstance().getDatapoolPassword();		
		    
		    if((datapoolName != null) && (datapoolPasswordMap != null)){

		    	String password = ((String)(datapoolPasswordMap.get(datapoolName)));

		    	if(password != null){
		    		return (EncryptionManager.decrypt(((String)(value)), password));
		    	}
		    }
		}
		
		return value;
	}
} //DPLCellImpl
