/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractEnumerator.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * This is an "abstract" enumeration.
 * 
 * This is a generic enumerator that provides basic support for mapping between
 * name and value pairs.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 * 
*/
public abstract class AbstractEnumerator {
	
	/**
	 * The name of the enumerator.
	 */
	private final String name;

	/**
	 * The <code>int</code> value of the enumerator.
	 */
	private final int value;

	/**
	 * Creates an initialized instance.
	 * @param value the <code>int</code> value of the enumerator.
	 * @param name the name of the enumerator.
	 */
	protected AbstractEnumerator(int value, String name)
	{
	  this.name = name;
	  this.value = value;
	}

	/**
	 * Returns the name of the enumerator.
	 * @return the name.
	 */
	public final String getName()
	{
	  return name;
	}

	/**
	 * Returns the <code>int</code> value of the enumerator.
	 * @return the value.
	 */
	public final int getValue()
	{
	  return value;
	}

	/**
	 * Returns the name of the enumerator.
	 * @return the name.
	 */
	public final String toString()
	{
	  return name;
	}
}
