/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPropertyGroup.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A property group is a collection of properties.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface IPropertyGroup{
	
	/**
	 * Returns the list of properties that are contained by this group.  Implementors
	 * must enforce that all objects in the list are instances of {@link IProperty}.
	 * 
	 * @return List
	 */
	public List getProperties();
	
	/**
	 * Returns the property which is identified by a given name or <code>null</code> if
	 * there is no such property. 
	 * 
	 * @param name
	 * @return IProperty
	 */
	public IProperty getPropertyByName(String name);
}
