/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestSuite.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A test suite is a grouping mechanism for a set of zero or more test cases.
 * The order of tests in the suite is defined by the behavior for the test 
 * suite.  If the test suite does not have a behavior, then the execution order
 * of the suite's test cases is undefined.  Each test suite is associated by 
 * value to a set of test components and systems under test (SUTs) which 
 * implement the suite's test cases.  The behavior of the test suite is 
 * captured by and accessible from the referenced test components.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ITestSuite extends ITest {
	
	/**
	 * Returns the list of test cases that are contained by this test suite.  
	 * Implementors must enforce that all objects in the list are instances of 
	 * {@link ITestCase}.
	 *  
	 * <p>This reference is bidirectional and its opposite is 
	 * {@link ITestCase#getTestSuite()}.
	 * 
	 * @return List
	 */
	public List getITestCases();	 
	
	/**
	 * Returns the list of test components that are contained by this test.  
	 * Implementors must enforce that all objects in the list are instances of 
	 * {@link ITestComponent}.
	 * 
	 * <p>This reference is bidirectional and its opposite is 
	 * {@link IDeployableComponent#getOwner()}.
	 * 
	 * @return List
	 */
	public List getITestComponents();

	/**
	 * Returns the list of systems under test (SUTs)that are contained by this test.  
	 * Implementors must enforce that all objects in the list are instances of 
	 * {@link ISystemUnderTest}.
	 * 
	 * <p>This reference is bidirectional and its opposite is 
	 * {@link IDeployableComponent#getOwner()}.
	 * 
	 * @return List
	 */
	public List getISystemsUnderTest();	

	/**
	 * Returns the type of the suite.
	 *  
	 * @return String
	 */	
	public String getType();

	/**
	 * Sets the type of the suite.
	 *  
	 * @return String
	 */		
	public void setType(String type);

	/**
	 * Returns the list of suites referenced by this test suite.  Implementors 
	 * must enforce that all objects in the list are instances of 
	 * {@link ITestSuite}.
	 * 
	 * <p>This reference is bidirectional and its opposite is the
	 * {@link ITestSuite#getIReferencedSuites()} call on the other suite.
	 * 
	 * @return List
	 */	
	public List getIReferencedSuites();
	
}
