/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FacadeResourceFactoryImpl.java,v 1.5 2008/12/22 16:07:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;
import org.eclipse.hyades.models.common.util.ICommonConstants;

/**
 * FacadeResourceFactoryImpl.java
 * 
 * 
 * @author  Joseph P. Toomey
 * @author  Paul Slauenwhite
 * @version December 22, 2008
 * @since   January 25, 2005
 */
public class FacadeResourceFactoryImpl extends XMIResourceFactoryImpl {
	/**
 	* The default enconding for XML and XMI files. 
 	*/
	public final static String ENCODING = "UTF-8";

	/**
	 * File extension for the test suite resources
	 */
	public final static String TEST_SUITE_FILE_EXTENSION = "testsuite";

	public final static String PERSISTENCE_ID = "HyadesFacadeResource";
	
	/**
	 * 
	 */
	public FacadeResourceFactoryImpl() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl#createResource(org.eclipse.emf.common.util.URI)
	 */
	public Resource createResource(URI arg0) {
		FacadeResourceImpl resource = new FacadeResourceImpl(arg0);
		resource.setUseZip(true);
		resource.setEncoding(ENCODING);
		return resource;
	}

	/**
	 * <p>Initializes the EMF test models, including:</p>
	 * 
	 * <ul>
	 * <li>Loading the resource factories by adding the following extensions to the resource extension map, 
	 * if not already included, with a common instance of the facade resource factory 
	 * (see {@link FacadeResourceFactoryImpl}):
	 * <ul>
	 * <li>testsuite</li>
	 * <li>deploy</li>
	 * <li>execution</li>
	 * <li>artifact</li>
	 * <li>location</li>
	 * <li>datapool</li>
	 * <li>sut</li>
	 * <li>testcomponent</li>
	 * </ul>
	 * </li>
	 * <li>Creates, registers, and initializes the <b>Package</b> for the Common Test Profile model 
	 * (see {@link Common_TestprofilePackageImpl#init()}).</li>
	 * </ul>
	 */
	public static void initializeRequisiteModels() {
		
		Map map = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
		FacadeResourceFactoryImpl factory = new FacadeResourceFactoryImpl(); 
		
		if (!map.containsKey(ICommonConstants.TEST_SUITE_FILE_EXTENSION))
			map.put(ICommonConstants.TEST_SUITE_FILE_EXTENSION, factory);	
		if (!map.containsKey(ICommonConstants.DEPLOYMENT_FILE_EXTENSION))
			map.put(ICommonConstants.DEPLOYMENT_FILE_EXTENSION, factory);	
		if (!map.containsKey(ICommonConstants.EXECUTION_FILE_EXTENSION))
			map.put(ICommonConstants.EXECUTION_FILE_EXTENSION, factory);
		if (!map.containsKey(ICommonConstants.ARTIFACT_FILE_EXTENSION))
			map.put(ICommonConstants.ARTIFACT_FILE_EXTENSION, factory);
		if (!map.containsKey(ICommonConstants.LOCATION_FILE_EXTENSION))
			map.put(ICommonConstants.LOCATION_FILE_EXTENSION, factory);
		if (!map.containsKey(ICommonConstants.DATAPOOL_FILE_EXTENSION))
			map.put(ICommonConstants.DATAPOOL_FILE_EXTENSION, factory);
		if (!map.containsKey(ICommonConstants.SUT_EXTENSION))
			map.put(ICommonConstants.SUT_EXTENSION, factory);
		if (!map.containsKey(ICommonConstants.TEST_COMPONENT_EXTENSION))
			map.put(ICommonConstants.TEST_COMPONENT_EXTENSION, factory);

		Common_TestprofilePackageImpl.init();
	}
}
