/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesBVRInteractionAdapter.java,v 1.9 2008/07/03 14:12:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author Joseph P. Toomey
 * @author Peter Sun
 * @author Paul E. Slauenwhite
 * @author Jerome Bozier
 * @version July 2, 2008
 */
public class HyadesBVRInteractionAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesBVRInteractionAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object obj) {
		if (obj instanceof EObject)
		{
		  return ((EObject)obj).eClass() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		
		int eventType = notification.getEventType();
		
		if(!(notification.getNotifier() instanceof EObject))
		{
			return;
		}
		EObject container = ((EObject)notification.getNotifier()).eContainer();
		if(container instanceof TPFBehavior)
		{
			container = container.eContainer();
		}
		if(!(container instanceof TPFTestSuite))
		{
			return;
		}
		if(!FacadeResourceFactoryImpl.PERSISTENCE_ID.equals(((TPFTestSuiteImpl)container).getPersistenceId()))
		{
			return;
		}
		
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY)
		{
			switch (notification.getFeatureID(BVRInteraction.class))
			{
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
					BVRInteractionImpl interaction = (BVRInteractionImpl) notification.getNotifier();
					BVRInteractionFragmentImpl fragment = null;
					BVRLifelineImpl lifeline = null;
					List lifelines = null;
					Iterator itLifelines = null;
					
					switch(eventType) {	
						case Notification.ADD:
							fragment = (BVRInteractionFragmentImpl)notification.getNewValue();	
							HyadesUtil.INSTANCE.createSUTInstances(interaction, fragment);
							
							if(fragment instanceof ITestInvocation)
							{
								ITestSuite test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
								EObject rootContainer = EcoreUtil.getRootContainer(interaction);
								if (rootContainer instanceof ITestSuite) {
									ITestSuite owner = (ITestSuite) EcoreUtil.getRootContainer(interaction);							 	
									if(owner != null && test != null && !owner.getId().equals(test.getId()))
									{
										if(!HyadesUtil.INSTANCE.containsSuite(owner.getIReferencedSuites(), test))
										{
											owner.getIReferencedSuites().add(test);
										}
									}
								}
							}
							
							break;
						case Notification.REMOVE:
							fragment = (BVRInteractionFragmentImpl)notification.getOldValue();

							// Iterate over all lifelines in the interaction, and remove 
							// any references to this interaction fragment from each of them.
							lifelines = interaction.getLifelines();
							itLifelines = lifelines.iterator();
							while ( itLifelines.hasNext() )
							{
								lifeline = (BVRLifelineImpl)itLifelines.next();
								lifeline.getInteractionFragments().remove(fragment);
							}
							break;
					}					
				break;
			}			
		}
	}
		
}
