/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesUtil.java,v 1.4 2008/03/07 17:00:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * Contains utility methods to manipulate the Behavioral model facade.
 * <p/>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @version March 7, 2008
 * @since   January 25, 2005
 */
public class HyadesUtil {
	
	public static final HyadesUtil INSTANCE = new HyadesUtil();
	
	public void createSUTInstances(BVRInteractionImpl interaction, BVRInteractionFragmentImpl action)
	{
		TPFTestSuiteImpl testSuite = null;

		if(interaction == null || action == null)
		{
			return;
		}

		if(interaction.getBehavior().getTest() instanceof TPFTestCaseImpl)
		{
			testSuite = (TPFTestSuiteImpl)((TPFTestCaseImpl)(interaction.getBehavior().getTest())).getOwner();
		}
		if(interaction.getBehavior().getTest() instanceof TPFTestSuiteImpl)
		{
			testSuite = (TPFTestSuiteImpl)interaction.getBehavior().getTest();
		}
		if(testSuite != null)
		{
			List systemUnderTests = testSuite.getISystemsUnderTest();
			Iterator iter2 = systemUnderTests.iterator();
			while(iter2.hasNext())
			{
				TPFSUTImpl systemUnderTest = (TPFSUTImpl)iter2.next();
				List methods = systemUnderTest.getMethods();
				Iterator iter3 = methods.iterator();
				while(iter3.hasNext())
				{
					CFGOperationImpl method = (CFGOperationImpl)iter3.next();
					if(action.getMessages().size() > 0)
					{
						BVRMessageImpl message = (BVRMessageImpl)action.getMessages().get(0);
						if(method.getName().equals(message.getOperation().getName()))
						{
							BVRLifelineImpl sutLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
							sutLifeline.setDescription("self lifeline for " + systemUnderTest.getName());
							sutLifeline.setName(systemUnderTest.getName() + "_selfLifeline");
							interaction.getLifelines().add(sutLifeline);
												
							CFGInstanceImpl instance = (CFGInstanceImpl) Common_ConfigurationFactoryImpl.eINSTANCE.createCFGInstance();
							instance.setName("instance for " + systemUnderTest.getName());
							instance.setClassType((CFGClass)systemUnderTest);
							instance.setLifeline(sutLifeline);	
							((CFGClassImpl)systemUnderTest).getInstances().add(instance);
						}
					}											
				}									
			}					
		}
	}
	
	public ITestSuite getTestSuite(ITest test)
	{
		if(test instanceof ITestCase)
		{
			test = ((ITestCase)test).getOwner();
		}
		else if (!(test instanceof ITestSuite))
		{
			test = null;
		}
		return (ITestSuite)test;		
	}

	public boolean containsSuite(List referencedSuites, ITestSuite test)
	{
		if(referencedSuites == null || test == null)
		{
			return false;
		}
		Iterator iter = referencedSuites.iterator();
		while(iter.hasNext())
		{
			if(((ITestSuite)iter.next()).getId().equals(test.getId()))
			{
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Returns the target invocation associated with the input test case
	 * 
	 * @param input The test case
	 * @return The associated target invocation
	 */
	public static ITargetInvocation getTargetInvocation(ITestCase input)
	{	
		ITargetInvocation targetInvocation = null;
		
		IImplementor implementor = input.getImplementor();
		IBlock block = (implementor == null ? null : implementor.getBlock());
		if(block != null)
		{
			for(Iterator i = block.getActions().iterator(); i.hasNext();)
			{
				Object action = i.next();
				if(action instanceof ITargetInvocation)
				{
					targetInvocation = (ITargetInvocation)action;
					break;			
				}
			}						
		}
		return targetInvocation;
	}
	
	/**
	 * Creates the target invocation based on the input argument
	 * 
	 * @param input The test case
	 * @return Creates and associates a target invocation to the input test case
	 */
	public static ITargetInvocation createTargetInvocation(ITestCase input)
	{
		if(input == null)
			return null;
		
		if(input.getImplementor() == null)
			HyadesFactory.INSTANCE.createImplementor(input, false);
			
		ITargetInvocation targetInvocation = HyadesFactory.INSTANCE.createTargetInvocation(null);
		input.getImplementor().getBlock().getActions().add(targetInvocation); 
		
		return targetInvocation;
	}
	
	/**
	 * Returns the value of the variable set for the test suite passed as argument
	 * 
	 * @param testSuite The test suite
	 * @param variableName The name of the variable
	 * 
	 * @return The value of the variable
	 */
	public static String getTestSuiteVariable(ITest testSuite, String variableName)
	{
		IVariable var = findVariable(testSuite, variableName);
		if (var == null)
			return null;
		return var.getInitialValue();
	}
	
	/**
	 * Set the test suite variable to the argument passed in
	 */
	public static void setTestSuiteVariable(ITest testSuite, String variableName, String variableValue)
	{
		IVariable var = findVariable(testSuite, variableName);
		if (var == null)
		{
			IVariable varToAdd = HyadesFactory.INSTANCE.createVariable();
			varToAdd.setName(variableName);
			varToAdd.setInitialValue(variableValue);
			testSuite.getVariables().add(varToAdd);
		}
		else
			var.setInitialValue(variableValue);
		
	}
	
	private static IVariable findVariable (ITest testSuite, String variableName)
	{
		List variables = testSuite.getVariables();
		for (int i = 0, variableSize = variables.size(); i < variableSize; i++)
		{
			IVariable currentVariable = (IVariable) variables.get(i);
			if (currentVariable.getName() != null && currentVariable.getName().equals(variableName))
			{
				return currentVariable;
			}
		}
		
		return null;
	}
}
