/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRInteractionImpl.java,v 1.10 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.fragments.BVRGate;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getFormalGates <em>Formal Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getBehavior <em>Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRInteractionImpl extends EObjectImpl implements BVRInteraction
{
	
	/**
	 * The cached value of the '{@link #getLifelines() <em>Lifelines</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLifelines()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRLifeline> lifelines;

	/**
	 * The cached value of the '{@link #getInteractionFragments() <em>Interaction Fragments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragments()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRInteractionFragment> interactionFragments;

	/**
	 * The cached value of the '{@link #getFormalGates() <em>Formal Gates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormalGates()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGate> formalGates;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRInteractionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_FragmentsPackage.Literals.BVR_INTERACTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRLifeline> getLifelines() {
		if (lifelines == null) {
			lifelines = new EObjectContainmentWithInverseEList<BVRLifeline>(BVRLifeline.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION);
		}
		return lifelines;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRInteractionFragment> getInteractionFragments() {
		if (interactionFragments == null) {
			interactionFragments = new EObjectContainmentWithInverseEList<BVRInteractionFragment>(BVRInteractionFragment.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION);
		}
		return interactionFragments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGate> getFormalGates() {
		if (formalGates == null) {
			formalGates = new EObjectContainmentEList<BVRGate>(BVRGate.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES);
		}
		return formalGates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFBehavior getBehavior() {
		if (eContainerFeatureID() != Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR) return null;
		return (TPFBehavior)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBehavior(TPFBehavior newBehavior, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newBehavior, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBehavior(TPFBehavior newBehavior) {
		if (newBehavior != eInternalContainer() || (eContainerFeatureID() != Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR && newBehavior != null)) {
			if (EcoreUtil.isAncestor(this, newBehavior))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newBehavior != null)
				msgs = ((InternalEObject)newBehavior).eInverseAdd(this, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, TPFBehavior.class, msgs);
			msgs = basicSetBehavior(newBehavior, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, newBehavior, newBehavior));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getLifelines()).basicAdd(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInteractionFragments()).basicAdd(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetBehavior((TPFBehavior)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return ((InternalEList<?>)getLifelines()).basicRemove(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return ((InternalEList<?>)getInteractionFragments()).basicRemove(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				return ((InternalEList<?>)getFormalGates()).basicRemove(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return basicSetBehavior(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, TPFBehavior.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return getLifelines();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return getInteractionFragments();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				return getFormalGates();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return getBehavior();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				getLifelines().clear();
				getLifelines().addAll((Collection<? extends BVRLifeline>)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				getInteractionFragments().addAll((Collection<? extends BVRInteractionFragment>)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				getFormalGates().clear();
				getFormalGates().addAll((Collection<? extends BVRGate>)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				setBehavior((TPFBehavior)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				getLifelines().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				getFormalGates().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				setBehavior((TPFBehavior)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return lifelines != null && !lifelines.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return interactionFragments != null && !interactionFragments.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				return formalGates != null && !formalGates.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return getBehavior() != null;
		}
		return super.eIsSet(featureID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IBlock#getActions()
	 */
	public List getActions() {
		return getInteractionFragments();
	}
	
	private String name;
	private String description;
	private String id;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getId()
	 */
	public String getId() {
		return id;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

} //BVRInteractionImpl
