/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRExecutionOccurrenceImpl.java,v 1.9 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.interactions.BVREventOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestComponentImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Execution Occurrence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getFinishEventOccurrence <em>Finish Event Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getBeforeEventOccurrence <em>Before Event Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl#getOtherBehavior <em>Other Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRExecutionOccurrenceImpl extends BVRInteractionFragmentImpl implements BVRExecutionOccurrence
{
	/**
	 * The cached value of the '{@link #getFinishEventOccurrence() <em>Finish Event Occurrence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFinishEventOccurrence()
	 * @generated
	 * @ordered
	 */
	protected BVREventOccurrence finishEventOccurrence;

	/**
	 * The cached value of the '{@link #getBeforeEventOccurrence() <em>Before Event Occurrence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBeforeEventOccurrence()
	 * @generated
	 * @ordered
	 */
	protected BVREventOccurrence beforeEventOccurrence;

	/**
	 * The cached value of the '{@link #getOtherBehavior() <em>Other Behavior</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOtherBehavior()
	 * @generated
	 * @ordered
	 */
	protected TPFBehavior otherBehavior;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRExecutionOccurrenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_InteractionsPackage.Literals.BVR_EXECUTION_OCCURRENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVREventOccurrence getFinishEventOccurrence() {
		if (finishEventOccurrence != null && finishEventOccurrence.eIsProxy()) {
			InternalEObject oldFinishEventOccurrence = (InternalEObject)finishEventOccurrence;
			finishEventOccurrence = (BVREventOccurrence)eResolveProxy(oldFinishEventOccurrence);
			if (finishEventOccurrence != oldFinishEventOccurrence) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, oldFinishEventOccurrence, finishEventOccurrence));
			}
		}
		return finishEventOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVREventOccurrence basicGetFinishEventOccurrence() {
		return finishEventOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFinishEventOccurrence(BVREventOccurrence newFinishEventOccurrence, NotificationChain msgs) {
		BVREventOccurrence oldFinishEventOccurrence = finishEventOccurrence;
		finishEventOccurrence = newFinishEventOccurrence;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, oldFinishEventOccurrence, newFinishEventOccurrence);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinishEventOccurrence(BVREventOccurrence newFinishEventOccurrence) {
		if (newFinishEventOccurrence != finishEventOccurrence) {
			NotificationChain msgs = null;
			if (finishEventOccurrence != null)
				msgs = ((InternalEObject)finishEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
			if (newFinishEventOccurrence != null)
				msgs = ((InternalEObject)newFinishEventOccurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
			msgs = basicSetFinishEventOccurrence(newFinishEventOccurrence, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, newFinishEventOccurrence, newFinishEventOccurrence));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVREventOccurrence getBeforeEventOccurrence() {
		if (beforeEventOccurrence != null && beforeEventOccurrence.eIsProxy()) {
			InternalEObject oldBeforeEventOccurrence = (InternalEObject)beforeEventOccurrence;
			beforeEventOccurrence = (BVREventOccurrence)eResolveProxy(oldBeforeEventOccurrence);
			if (beforeEventOccurrence != oldBeforeEventOccurrence) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, oldBeforeEventOccurrence, beforeEventOccurrence));
			}
		}
		return beforeEventOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVREventOccurrence basicGetBeforeEventOccurrence() {
		return beforeEventOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBeforeEventOccurrence(BVREventOccurrence newBeforeEventOccurrence, NotificationChain msgs) {
		BVREventOccurrence oldBeforeEventOccurrence = beforeEventOccurrence;
		beforeEventOccurrence = newBeforeEventOccurrence;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, oldBeforeEventOccurrence, newBeforeEventOccurrence);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBeforeEventOccurrence(BVREventOccurrence newBeforeEventOccurrence) {
		if (newBeforeEventOccurrence != beforeEventOccurrence) {
			NotificationChain msgs = null;
			if (beforeEventOccurrence != null)
				msgs = ((InternalEObject)beforeEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
			if (newBeforeEventOccurrence != null)
				msgs = ((InternalEObject)newBeforeEventOccurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
			msgs = basicSetBeforeEventOccurrence(newBeforeEventOccurrence, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, newBeforeEventOccurrence, newBeforeEventOccurrence));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFBehavior getOtherBehavior() {
		if (otherBehavior != null && otherBehavior.eIsProxy()) {
			InternalEObject oldOtherBehavior = (InternalEObject)otherBehavior;
			otherBehavior = (TPFBehavior)eResolveProxy(oldOtherBehavior);
			if (otherBehavior != oldOtherBehavior) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR, oldOtherBehavior, otherBehavior));
			}
		}
		return otherBehavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFBehavior basicGetOtherBehavior() {
		return otherBehavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOtherBehavior(TPFBehavior newOtherBehavior) {
		TPFBehavior oldOtherBehavior = otherBehavior;
		otherBehavior = newOtherBehavior;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR, oldOtherBehavior, otherBehavior));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				if (finishEventOccurrence != null)
					msgs = ((InternalEObject)finishEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, BVREventOccurrence.class, msgs);
				return basicSetFinishEventOccurrence((BVREventOccurrence)otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				if (beforeEventOccurrence != null)
					msgs = ((InternalEObject)beforeEventOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, BVREventOccurrence.class, msgs);
				return basicSetBeforeEventOccurrence((BVREventOccurrence)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				return basicSetFinishEventOccurrence(null, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				return basicSetBeforeEventOccurrence(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				if (resolve) return getFinishEventOccurrence();
				return basicGetFinishEventOccurrence();
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				if (resolve) return getBeforeEventOccurrence();
				return basicGetBeforeEventOccurrence();
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
				if (resolve) return getOtherBehavior();
				return basicGetOtherBehavior();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				setFinishEventOccurrence((BVREventOccurrence)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				setBeforeEventOccurrence((BVREventOccurrence)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
				setOtherBehavior((TPFBehavior)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				setFinishEventOccurrence((BVREventOccurrence)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				setBeforeEventOccurrence((BVREventOccurrence)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
				setOtherBehavior((TPFBehavior)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE:
				return finishEventOccurrence != null;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE:
				return beforeEventOccurrence != null;
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
				return otherBehavior != null;
		}
		return super.eIsSet(featureID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation#getInvokedTest()
	 */
	public ITest getInvokedTest() {
		if(getOtherBehavior() != null)
		{
			ITest test = (ITest)getOtherBehavior().getTest();
			if(test instanceof TPFTest)
				return test;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation#setInvokedTest(org.eclipse.hyades.models.common.facades.behavioral.ITest)
	 */
	public void setInvokedTest(ITest test) {
		if ( test instanceof TPFTestCaseImpl || test instanceof TPFTestSuiteImpl)
		{
			if(test.getImplementor() != null)
			{
				setOtherBehavior((TPFBehaviorImpl)test.getImplementor());
			}
			else
			{
				throw new IllegalArgumentException("Invoked test must have an implementor.");
			}
		}
		else
		{
			throw new IllegalArgumentException("Invoked test must be a TPFTest.");			
		}
	}

	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedImplementor()
	 */
	public IImplementor getInvokedImplementor() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		return behavior;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedImplementorName()
	 */
	public String getInvokedImplementorName() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		if ( behavior != null )
			return behavior.getName();
		else
			return "";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#getInvokedTestComponent()
	 */
	public ITestComponent getInvokedTestComponent() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl) getOtherBehavior();
		TPFTestComponentImpl component = (TPFTestComponentImpl)behavior.getTestComponent();
		return component;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#setInvokedTestComponent(org.eclipse.hyades.models.common.facades.behavioral.ITestComponent, org.eclipse.hyades.models.common.facades.behavioral.IImplementor)
	 */
	public void setInvokedTestComponent(
		ITestComponent component,
		IImplementor implementor) 
	{
		// component can be ignored, since it is inferred from implementor
		if ( implementor != null )
		{
			setOtherBehavior((TPFBehaviorImpl)implementor);		
		}
		else
		{
			// TODO: declare an exception on this interface and throw it here
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation#setInvokedTestComponent(org.eclipse.hyades.models.common.facades.behavioral.ITestComponent, java.lang.String)
	 */
	public void setInvokedTestComponent(
		ITestComponent component,
		String implementorName) 
	{
		if ( component != null && implementorName != null )
		{
			TPFTestComponentImpl theComponent = (TPFTestComponentImpl) component;
			List behaviors = theComponent.getBehaviors();
			Iterator iter = behaviors.iterator();
			while(iter.hasNext())
			{
				TPFBehaviorImpl behavior = (TPFBehaviorImpl) iter.next();
				String name = behavior.getName();
				if ( name != null && name.equals(implementorName))
				{
					setInvokedTestComponent(component, (IImplementor) behavior);
					break;
				}
			}
			// TODO: Must thrown an exception here, or change interface to return boolean.
		}
		else
		{
			// TODO: declare an exception on this interface and throw it here
		}

	}

} //BVRExecutionOccurrenceImpl
