/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRInteractionFragmentImpl.java,v 1.10 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.impl.PropertyGroupImpl;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.BVRMessage;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction Fragment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getGeneralOrderings <em>General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getDefaultApplication <em>Default Application</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class BVRInteractionFragmentImpl extends CMNNamedElementImpl implements BVRInteractionFragment
{
	/**
	 * The cached value of the '{@link #getLifelines() <em>Lifelines</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLifelines()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRLifeline> lifelines;

	/**
	 * The cached value of the '{@link #getGeneralOrderings() <em>General Orderings</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGeneralOrderings()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGeneralOrdering> generalOrderings;

	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRMessage> messages;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<CMNAnnotation> annotations;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRProperty> properties;

	/**
	 * The cached value of the '{@link #getDefaultApplication() <em>Default Application</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultApplication()
	 * @generated
	 * @ordered
	 */
	protected TPFDefaultApplication defaultApplication;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRInteractionFragmentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_InteractionsPackage.Literals.BVR_INTERACTION_FRAGMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRLifeline> getLifelines() {
		if (lifelines == null) {
			lifelines = new EObjectWithInverseResolvingEList.ManyInverse<BVRLifeline>(BVRLifeline.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS);
		}
		return lifelines;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGeneralOrdering> getGeneralOrderings() {
		if (generalOrderings == null) {
			generalOrderings = new EObjectContainmentEList<BVRGeneralOrdering>(BVRGeneralOrdering.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS);
		}
		return generalOrderings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRMessage> getMessages() {
		if (messages == null) {
			messages = new EObjectContainmentWithInverseEList<BVRMessage>(BVRMessage.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES, Common_Behavior_InteractionsPackage.BVR_MESSAGE__INTERACTION_FRAGMENT);
		}
		return messages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CMNAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<CMNAnnotation>(CMNAnnotation.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction getInteraction() {
		if (eContainerFeatureID() != Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION) return null;
		return (BVRInteraction)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInteraction(BVRInteraction newInteraction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newInteraction, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteraction(BVRInteraction newInteraction) {
		if (newInteraction != eInternalContainer() || (eContainerFeatureID() != Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION && newInteraction != null)) {
			if (EcoreUtil.isAncestor(this, newInteraction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInteraction != null)
				msgs = ((InternalEObject)newInteraction).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
			msgs = basicSetInteraction(newInteraction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, newInteraction, newInteraction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<BVRProperty>(BVRProperty.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFDefaultApplication getDefaultApplication() {
		return defaultApplication;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefaultApplication(TPFDefaultApplication newDefaultApplication, NotificationChain msgs) {
		TPFDefaultApplication oldDefaultApplication = defaultApplication;
		defaultApplication = newDefaultApplication;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, oldDefaultApplication, newDefaultApplication);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultApplication(TPFDefaultApplication newDefaultApplication) {
		if (newDefaultApplication != defaultApplication) {
			NotificationChain msgs = null;
			if (defaultApplication != null)
				msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, Common_TestprofilePackage.TPF_DEFAULT_APPLICATION__INTERACTION_FRAGMENT, TPFDefaultApplication.class, msgs);
			if (newDefaultApplication != null)
				msgs = ((InternalEObject)newDefaultApplication).eInverseAdd(this, Common_TestprofilePackage.TPF_DEFAULT_APPLICATION__INTERACTION_FRAGMENT, TPFDefaultApplication.class, msgs);
			msgs = basicSetDefaultApplication(newDefaultApplication, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, newDefaultApplication, newDefaultApplication));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getLifelines()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getMessages()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetInteraction((BVRInteraction)otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				if (defaultApplication != null)
					msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, null, msgs);
				return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				return ((InternalEList<?>)getLifelines()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
				return ((InternalEList<?>)getGeneralOrderings()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				return ((InternalEList<?>)getMessages()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				return basicSetInteraction(null, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				return basicSetDefaultApplication(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				return eInternalContainer().eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				return getLifelines();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
				return getGeneralOrderings();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				return getMessages();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
				return getAnnotations();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				return getInteraction();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
				return getProperties();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				return getDefaultApplication();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				getLifelines().clear();
				getLifelines().addAll((Collection<? extends BVRLifeline>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				getGeneralOrderings().addAll((Collection<? extends BVRGeneralOrdering>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection<? extends BVRMessage>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends CMNAnnotation>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends BVRProperty>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				getLifelines().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				getMessages().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
				getProperties().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
				return lifelines != null && !lifelines.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
				return generalOrderings != null && !generalOrderings.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
				return messages != null && !messages.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
				return getInteraction() != null;
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
				return defaultApplication != null;
		}
		return super.eIsSet(featureID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#getActionProperties()
	 */
	public IPropertyGroup getActionProperties() {
		PropertyGroupImpl propertyGroup = new PropertyGroupImpl();
		propertyGroup.setProperties(getProperties());
		return propertyGroup;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException {
		
		throw new UnsupportedOperationException("");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#getActionAnnotations()
	 */
	public List getActionAnnotations() {
		return getAnnotations();
	}
} //BVRInteractionFragmentImpl
