/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRLifelineImpl.java,v 1.10 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRPartDecomposition;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Lifeline</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl#getInstances <em>Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl#getPartDecomposition <em>Part Decomposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl#getInteraction <em>Interaction</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRLifelineImpl extends CMNNamedElementImpl implements BVRLifeline
{
	/**
	 * The cached value of the '{@link #getInteractionFragments() <em>Interaction Fragments</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragments()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRInteractionFragment> interactionFragments;

	/**
	 * The cached value of the '{@link #getInstances() <em>Instances</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGInstance> instances;

	/**
	 * The cached value of the '{@link #getPartDecomposition() <em>Part Decomposition</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPartDecomposition()
	 * @generated
	 * @ordered
	 */
	protected BVRPartDecomposition partDecomposition;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRLifelineImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_InteractionsPackage.Literals.BVR_LIFELINE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRInteractionFragment> getInteractionFragments() {
		if (interactionFragments == null) {
			interactionFragments = new EObjectWithInverseResolvingEList.ManyInverse<BVRInteractionFragment>(BVRInteractionFragment.class, this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES);
		}
		return interactionFragments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGInstance> getInstances() {
		if (instances == null) {
			instances = new EObjectWithInverseResolvingEList<CFGInstance>(CFGInstance.class, this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE);
		}
		return instances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRPartDecomposition getPartDecomposition() {
		if (partDecomposition != null && partDecomposition.eIsProxy()) {
			InternalEObject oldPartDecomposition = (InternalEObject)partDecomposition;
			partDecomposition = (BVRPartDecomposition)eResolveProxy(oldPartDecomposition);
			if (partDecomposition != oldPartDecomposition) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION, oldPartDecomposition, partDecomposition));
			}
		}
		return partDecomposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRPartDecomposition basicGetPartDecomposition() {
		return partDecomposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPartDecomposition(BVRPartDecomposition newPartDecomposition) {
		BVRPartDecomposition oldPartDecomposition = partDecomposition;
		partDecomposition = newPartDecomposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION, oldPartDecomposition, partDecomposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction getInteraction() {
		if (eContainerFeatureID() != Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION) return null;
		return (BVRInteraction)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInteraction(BVRInteraction newInteraction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newInteraction, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteraction(BVRInteraction newInteraction) {
		if (newInteraction != eInternalContainer() || (eContainerFeatureID() != Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION && newInteraction != null)) {
			if (EcoreUtil.isAncestor(this, newInteraction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInteraction != null)
				msgs = ((InternalEObject)newInteraction).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES, BVRInteraction.class, msgs);
			msgs = basicSetInteraction(newInteraction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION, newInteraction, newInteraction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInteractionFragments()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInstances()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetInteraction((BVRInteraction)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				return ((InternalEList<?>)getInteractionFragments()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				return ((InternalEList<?>)getInstances()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				return basicSetInteraction(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				return eInternalContainer().eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES, BVRInteraction.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				return getInteractionFragments();
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				return getInstances();
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION:
				if (resolve) return getPartDecomposition();
				return basicGetPartDecomposition();
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				return getInteraction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				getInteractionFragments().addAll((Collection<? extends BVRInteractionFragment>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection<? extends CFGInstance>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION:
				setPartDecomposition((BVRPartDecomposition)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				getInstances().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION:
				setPartDecomposition((BVRPartDecomposition)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS:
				return interactionFragments != null && !interactionFragments.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES:
				return instances != null && !instances.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__PART_DECOMPOSITION:
				return partDecomposition != null;
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION:
				return getInteraction() != null;
		}
		return super.eIsSet(featureID);
	}

} //BVRLifelineImpl
