/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFRepositoryRecord.java,v 1.2 2009/05/05 15:49:17 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Repository Record</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a record (e.g. a defect) from a repository that is associated with a {@link TPFExecutionEvent}.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getID <em>ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getURI <em>URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getExecutionEvent <em>Execution Event</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getExecutionResult <em>Execution Result</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord()
 * @model
 * @generated
 */
public interface TPFRepositoryRecord extends EObject {
	/**
	 * Returns the value of the '<em><b>ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * ID of this record.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>ID</em>' attribute.
	 * @see #setID(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_ID()
	 * @model
	 * @generated
	 */
	String getID();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getID <em>ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>ID</em>' attribute.
	 * @see #getID()
	 * @generated
	 */
	void setID(String value);

	/**
	 * Returns the value of the '<em><b>URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A string that helps to retrieve the record from its repository.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>URI</em>' attribute.
	 * @see #setURI(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_URI()
	 * @model
	 * @generated
	 */
	String getURI();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getURI <em>URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>URI</em>' attribute.
	 * @see #getURI()
	 * @generated
	 */
	void setURI(String value);

	/**
	 * Returns the value of the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Label</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A user visible label for this record.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Label</em>' attribute.
	 * @see #setLabel(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_Label()
	 * @model
	 * @generated
	 */
	String getLabel();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getLabel <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Label</em>' attribute.
	 * @see #getLabel()
	 * @generated
	 */
	void setLabel(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A unique identifier for the type of the repository provider (e.g. a defect tracking provider like bugzilla can be "org.bugzilla").
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_Type()
	 * @model
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Execution Event</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent#getDefectRecords <em>Defect Records</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Execution Event</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Execution Event</em>' container reference.
	 * @see #setExecutionEvent(TPFExecutionEvent)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_ExecutionEvent()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent#getDefectRecords
	 * @model opposite="defectRecords" required="true"
	 * @generated
	 */
	TPFExecutionEvent getExecutionEvent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getExecutionEvent <em>Execution Event</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Execution Event</em>' container reference.
	 * @see #getExecutionEvent()
	 * @generated
	 */
	void setExecutionEvent(TPFExecutionEvent value);

	/**
	 * Returns the value of the '<em><b>Execution Result</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getRecords <em>Records</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Execution Result</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Execution Result</em>' reference.
	 * @see #setExecutionResult(TPFExecutionResult)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFRepositoryRecord_ExecutionResult()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getRecords
	 * @model opposite="records" required="true"
	 * @generated
	 */
	TPFExecutionResult getExecutionResult();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord#getExecutionResult <em>Execution Result</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Execution Result</em>' reference.
	 * @see #getExecutionResult()
	 * @generated
	 */
	void setExecutionResult(TPFExecutionResult value);

} // TPFRepositoryRecord
