/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFExecutionEventImpl.java,v 1.14 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.util.Guid;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNDefaultProperty;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.EObjectReference;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getOwnerId <em>Owner Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getText <em>Text</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getEventType <em>Event Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getScriptFileURI <em>Script File URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getScriptLineNumber <em>Script Line Number</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getInteractionFragment <em>Interaction Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getEObjectReferences <em>EObject References</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getDefectRecords <em>Defect Records</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionEventImpl extends CMNNamedElementImpl implements TPFExecutionEvent
{
	/**
	 * The default value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected static final String OWNER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected String ownerId = OWNER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final long TIMESTAMP_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected long timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected static final String EVENT_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected String eventType = EVENT_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getScriptFileURI() <em>Script File URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScriptFileURI()
	 * @generated
	 * @ordered
	 */
	protected static final String SCRIPT_FILE_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getScriptFileURI() <em>Script File URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScriptFileURI()
	 * @generated
	 * @ordered
	 */
	protected String scriptFileURI = SCRIPT_FILE_URI_EDEFAULT;

	/**
	 * The default value of the '{@link #getScriptLineNumber() <em>Script Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScriptLineNumber()
	 * @generated
	 * @ordered
	 */
	protected static final long SCRIPT_LINE_NUMBER_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getScriptLineNumber() <em>Script Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScriptLineNumber()
	 * @generated
	 * @ordered
	 */
	protected long scriptLineNumber = SCRIPT_LINE_NUMBER_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInteractionFragment() <em>Interaction Fragment</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragment()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionFragment interactionFragment;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFExecutionEvent> children;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<CMNDefaultProperty> properties;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<CMNAnnotation> annotations;

	/**
	 * The cached value of the '{@link #getEObjectReferences() <em>EObject References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEObjectReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<EObjectReference> eObjectReferences;

	/**
	 * The cached value of the '{@link #getDefectRecords() <em>Defect Records</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefectRecords()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFRepositoryRecord> defectRecords;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected TPFExecutionEventImpl()
	{
		super();
		id = new Guid().toString();
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_EXECUTION_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOwnerId() {
		return ownerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerId(String newOwnerId) {
		String oldOwnerId = ownerId;
		ownerId = newOwnerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID, oldOwnerId, ownerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(long newTimestamp) {
		long oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT, oldText, text));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEventType() {
		return eventType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEventType(String newEventType) {
		String oldEventType = eventType;
		eventType = newEventType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE, oldEventType, eventType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getScriptFileURI() {
		return scriptFileURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScriptFileURI(String newScriptFileURI) {
		String oldScriptFileURI = scriptFileURI;
		scriptFileURI = newScriptFileURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_FILE_URI, oldScriptFileURI, scriptFileURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getScriptLineNumber() {
		return scriptLineNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScriptLineNumber(long newScriptLineNumber) {
		long oldScriptLineNumber = scriptLineNumber;
		scriptLineNumber = newScriptLineNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_LINE_NUMBER, oldScriptLineNumber, scriptLineNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionHistory getExecutionHistory() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY) return null;
		return (TPFExecutionHistory)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExecutionHistory(TPFExecutionHistory newExecutionHistory, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newExecutionHistory, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionHistory(TPFExecutionHistory newExecutionHistory) {
		if (newExecutionHistory != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY && newExecutionHistory != null)) {
			if (EcoreUtil.isAncestor(this, newExecutionHistory))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newExecutionHistory != null)
				msgs = ((InternalEObject)newExecutionHistory).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
			msgs = basicSetExecutionHistory(newExecutionHistory, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, newExecutionHistory, newExecutionHistory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment getInteractionFragment() {
		if (interactionFragment != null && interactionFragment.eIsProxy()) {
			InternalEObject oldInteractionFragment = (InternalEObject)interactionFragment;
			interactionFragment = (BVRInteractionFragment)eResolveProxy(oldInteractionFragment);
			if (interactionFragment != oldInteractionFragment) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
			}
		}
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment basicGetInteractionFragment() {
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionFragment(BVRInteractionFragment newInteractionFragment) {
		BVRInteractionFragment oldInteractionFragment = interactionFragment;
		interactionFragment = newInteractionFragment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFExecutionEvent> getChildren() {
		if (children == null) {
			children = new EObjectContainmentWithInverseEList<TPFExecutionEvent>(TPFExecutionEvent.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionEvent getParent() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT) return null;
		return (TPFExecutionEvent)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(TPFExecutionEvent newParent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParent, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(TPFExecutionEvent newParent) {
		if (newParent != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CMNDefaultProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<CMNDefaultProperty>(CMNDefaultProperty.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CMNAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<CMNAnnotation>(CMNAnnotation.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObjectReference> getEObjectReferences() {
		if (eObjectReferences == null) {
			eObjectReferences = new EObjectContainmentEList<EObjectReference>(EObjectReference.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES);
		}
		return eObjectReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFRepositoryRecord> getDefectRecords() {
		if (defectRecords == null) {
			defectRecords = new EObjectContainmentWithInverseEList<TPFRepositoryRecord>(TPFRepositoryRecord.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS, Common_TestprofilePackage.TPF_REPOSITORY_RECORD__EXECUTION_EVENT);
		}
		return defectRecords;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetExecutionHistory((TPFExecutionHistory)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParent((TPFExecutionEvent)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDefectRecords()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return basicSetExecutionHistory(null, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return basicSetParent(null, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				return ((InternalEList<?>)getEObjectReferences()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				return ((InternalEList<?>)getDefectRecords()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return getOwnerId();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return getTimestamp();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return getText();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				return getEventType();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_FILE_URI:
				return getScriptFileURI();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_LINE_NUMBER:
				return getScriptLineNumber();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				if (resolve) return getInteractionFragment();
				return basicGetInteractionFragment();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return getChildren();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				return getProperties();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				return getAnnotations();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				return getEObjectReferences();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				return getDefectRecords();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp((Long)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				setEventType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_FILE_URI:
				setScriptFileURI((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_LINE_NUMBER:
				setScriptLineNumber((Long)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection<? extends TPFExecutionEvent>)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends CMNDefaultProperty>)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends CMNAnnotation>)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				getEObjectReferences().addAll((Collection<? extends EObjectReference>)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				getDefectRecords().clear();
				getDefectRecords().addAll((Collection<? extends TPFRepositoryRecord>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId(OWNER_ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText(TEXT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				setEventType(EVENT_TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_FILE_URI:
				setScriptFileURI(SCRIPT_FILE_URI_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_LINE_NUMBER:
				setScriptLineNumber(SCRIPT_LINE_NUMBER_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				getProperties().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				getDefectRecords().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				return EVENT_TYPE_EDEFAULT == null ? eventType != null : !EVENT_TYPE_EDEFAULT.equals(eventType);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_FILE_URI:
				return SCRIPT_FILE_URI_EDEFAULT == null ? scriptFileURI != null : !SCRIPT_FILE_URI_EDEFAULT.equals(scriptFileURI);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__SCRIPT_LINE_NUMBER:
				return scriptLineNumber != SCRIPT_LINE_NUMBER_EDEFAULT;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				return interactionFragment != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return children != null && !children.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				return eObjectReferences != null && !eObjectReferences.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DEFECT_RECORDS:
				return defectRecords != null && !defectRecords.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (ownerId: ");
		result.append(ownerId);
		result.append(", timestamp: ");
		result.append(timestamp);
		result.append(", text: ");
		result.append(text);
		result.append(", eventType: ");
		result.append(eventType);
		result.append(", scriptFileURI: ");
		result.append(scriptFileURI);
		result.append(", scriptLineNumber: ");
		result.append(scriptLineNumber);
		result.append(')');
		return result.toString();
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}
} //TPFExecutionEventImpl
