/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFInvocationEventImpl.java,v 1.11 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationReason;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Invocation Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFInvocationEventImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFInvocationEventImpl#getReason <em>Reason</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFInvocationEventImpl#getInvokedExecutionResult <em>Invoked Execution Result</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFInvocationEventImpl extends TPFExecutionEventImpl implements TPFInvocationEvent
{
	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final TPFInvocationStatus STATUS_EDEFAULT = TPFInvocationStatus.UNATTEMPTED_LITERAL;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected TPFInvocationStatus status = STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getReason() <em>Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReason()
	 * @generated
	 * @ordered
	 */
	protected static final TPFInvocationReason REASON_EDEFAULT = TPFInvocationReason.UNKNOWN_LITERAL;

	/**
	 * The cached value of the '{@link #getReason() <em>Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReason()
	 * @generated
	 * @ordered
	 */
	protected TPFInvocationReason reason = REASON_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInvokedExecutionResult() <em>Invoked Execution Result</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvokedExecutionResult()
	 * @generated
	 * @ordered
	 */
	protected TPFExecutionResult invokedExecutionResult;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFInvocationEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_INVOCATION_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFInvocationStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatus(TPFInvocationStatus newStatus) {
		TPFInvocationStatus oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_INVOCATION_EVENT__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFInvocationReason getReason() {
		return reason;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReason(TPFInvocationReason newReason) {
		TPFInvocationReason oldReason = reason;
		reason = newReason == null ? REASON_EDEFAULT : newReason;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_INVOCATION_EVENT__REASON, oldReason, reason));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionResult getInvokedExecutionResult() {
		return invokedExecutionResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvokedExecutionResult(TPFExecutionResult newInvokedExecutionResult, NotificationChain msgs) {
		TPFExecutionResult oldInvokedExecutionResult = invokedExecutionResult;
		invokedExecutionResult = newInvokedExecutionResult;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, oldInvokedExecutionResult, newInvokedExecutionResult);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvokedExecutionResult(TPFExecutionResult newInvokedExecutionResult) {
		if (newInvokedExecutionResult != invokedExecutionResult) {
			NotificationChain msgs = null;
			if (invokedExecutionResult != null)
				msgs = ((InternalEObject)invokedExecutionResult).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, TPFExecutionResult.class, msgs);
			if (newInvokedExecutionResult != null)
				msgs = ((InternalEObject)newInvokedExecutionResult).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, TPFExecutionResult.class, msgs);
			msgs = basicSetInvokedExecutionResult(newInvokedExecutionResult, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, newInvokedExecutionResult, newInvokedExecutionResult));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				if (invokedExecutionResult != null)
					msgs = ((InternalEObject)invokedExecutionResult).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, null, msgs);
				return basicSetInvokedExecutionResult((TPFExecutionResult)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				return basicSetInvokedExecutionResult(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__STATUS:
				return getStatus();
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__REASON:
				return getReason();
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				return getInvokedExecutionResult();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__STATUS:
				setStatus((TPFInvocationStatus)newValue);
				return;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__REASON:
				setReason((TPFInvocationReason)newValue);
				return;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				setInvokedExecutionResult((TPFExecutionResult)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__REASON:
				setReason(REASON_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				setInvokedExecutionResult((TPFExecutionResult)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__STATUS:
				return status != STATUS_EDEFAULT;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__REASON:
				return reason != REASON_EDEFAULT;
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT:
				return invokedExecutionResult != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (status: ");
		result.append(status);
		result.append(", reason: ");
		result.append(reason);
		result.append(')');
		return result.toString();
	}

} //TPFInvocationEventImpl
