/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFTestSuiteImpl.java,v 1.11 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Test Suite</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestObjectives <em>Test Objectives</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getBehavior <em>Behavior</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getPersistenceId <em>Persistence Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestCases <em>Test Cases</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getSUTs <em>SU Ts</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getArbiter <em>Arbiter</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestComponents <em>Test Components</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getReferencedSuites <em>Referenced Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getDatapools <em>Datapools</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFTestSuiteImpl extends CFGClassImpl implements TPFTestSuite
{
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTestObjectives() <em>Test Objectives</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestObjectives()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFTestObjective> testObjectives;

	/**
	 * The cached value of the '{@link #getBehavior() <em>Behavior</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehavior()
	 * @generated
	 * @ordered
	 */
	protected TPFBehavior behavior;

	/**
	 * The default value of the '{@link #getPersistenceId() <em>Persistence Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPersistenceId()
	 * @generated
	 * @ordered
	 */
	protected static final String PERSISTENCE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPersistenceId() <em>Persistence Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPersistenceId()
	 * @generated
	 * @ordered
	 */
	protected String persistenceId = PERSISTENCE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTestCases() <em>Test Cases</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestCases()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFTestCase> testCases;

	/**
	 * The cached value of the '{@link #getSUTs() <em>SU Ts</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSUTs()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFSUT> suTs;

	/**
	 * The cached value of the '{@link #getArbiter() <em>Arbiter</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArbiter()
	 * @generated
	 * @ordered
	 */
	protected TPFArbiter arbiter;

	/**
	 * The cached value of the '{@link #getTestComponents() <em>Test Components</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestComponents()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFTestComponent> testComponents;

	/**
	 * The cached value of the '{@link #getReferencedSuites() <em>Referenced Suites</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferencedSuites()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFTestSuite> referencedSuites;

	/**
	 * The cached value of the '{@link #getDatapools() <em>Datapools</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatapools()
	 * @generated
	 * @ordered
	 */
	protected EList<DPLDatapool> datapools;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFTestSuiteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_TEST_SUITE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFTestObjective> getTestObjectives() {
		if (testObjectives == null) {
			testObjectives = new EObjectContainmentWithInverseEList<TPFTestObjective>(TPFTestObjective.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES, Common_TestprofilePackage.TPF_TEST_OBJECTIVE__TEST);
		}
		return testObjectives;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFBehavior getBehavior() {
		return behavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBehavior(TPFBehavior newBehavior, NotificationChain msgs) {
		TPFBehavior oldBehavior = behavior;
		behavior = newBehavior;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, oldBehavior, newBehavior);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBehavior(TPFBehavior newBehavior) {
		if (newBehavior != behavior) {
			NotificationChain msgs = null;
			if (behavior != null)
				msgs = ((InternalEObject)behavior).eInverseRemove(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
			if (newBehavior != null)
				msgs = ((InternalEObject)newBehavior).eInverseAdd(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
			msgs = basicSetBehavior(newBehavior, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, newBehavior, newBehavior));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPersistenceId() {
		return persistenceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPersistenceId(String newPersistenceId) {
		String oldPersistenceId = persistenceId;
		persistenceId = newPersistenceId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID, oldPersistenceId, persistenceId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFTestCase> getTestCases() {
		if (testCases == null) {
			testCases = new EObjectContainmentWithInverseEList<TPFTestCase>(TPFTestCase.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE);
		}
		return testCases;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFSUT> getSUTs() {
		if (suTs == null) {
			suTs = new EObjectContainmentWithInverseEList<TPFSUT>(TPFSUT.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS, Common_TestprofilePackage.TPFSUT__TEST_SUITE);
		}
		return suTs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFArbiter getArbiter() {
		return arbiter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetArbiter(TPFArbiter newArbiter, NotificationChain msgs) {
		TPFArbiter oldArbiter = arbiter;
		arbiter = newArbiter;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, oldArbiter, newArbiter);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArbiter(TPFArbiter newArbiter) {
		if (newArbiter != arbiter) {
			NotificationChain msgs = null;
			if (arbiter != null)
				msgs = ((InternalEObject)arbiter).eInverseRemove(this, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, TPFArbiter.class, msgs);
			if (newArbiter != null)
				msgs = ((InternalEObject)newArbiter).eInverseAdd(this, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, TPFArbiter.class, msgs);
			msgs = basicSetArbiter(newArbiter, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, newArbiter, newArbiter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFTestComponent> getTestComponents() {
		if (testComponents == null) {
			testComponents = new EObjectContainmentWithInverseEList<TPFTestComponent>(TPFTestComponent.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE);
		}
		return testComponents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFTestSuite> getReferencedSuites() {
		if (referencedSuites == null) {
			referencedSuites = new EObjectResolvingEList<TPFTestSuite>(TPFTestSuite.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES);
		}
		return referencedSuites;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DPLDatapool> getDatapools() {
		if (datapools == null) {
			datapools = new EObjectResolvingEList<DPLDatapool>(DPLDatapool.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS);
		}
		return datapools;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTestObjectives()).basicAdd(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				if (behavior != null)
					msgs = ((InternalEObject)behavior).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, null, msgs);
				return basicSetBehavior((TPFBehavior)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTestCases()).basicAdd(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSUTs()).basicAdd(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				if (arbiter != null)
					msgs = ((InternalEObject)arbiter).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, null, msgs);
				return basicSetArbiter((TPFArbiter)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTestComponents()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				return ((InternalEList<?>)getTestObjectives()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				return basicSetBehavior(null, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				return ((InternalEList<?>)getTestCases()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				return ((InternalEList<?>)getSUTs()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				return basicSetArbiter(null, msgs);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				return ((InternalEList<?>)getTestComponents()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
				return getType();
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				return getTestObjectives();
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				return getBehavior();
			case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
				return getPersistenceId();
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				return getTestCases();
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				return getSUTs();
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				return getArbiter();
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				return getTestComponents();
			case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
				return getReferencedSuites();
			case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
				return getDatapools();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
				setType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				getTestObjectives().clear();
				getTestObjectives().addAll((Collection<? extends TPFTestObjective>)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				setBehavior((TPFBehavior)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
				setPersistenceId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				getTestCases().clear();
				getTestCases().addAll((Collection<? extends TPFTestCase>)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				getSUTs().clear();
				getSUTs().addAll((Collection<? extends TPFSUT>)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				setArbiter((TPFArbiter)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				getTestComponents().clear();
				getTestComponents().addAll((Collection<? extends TPFTestComponent>)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
				getReferencedSuites().clear();
				getReferencedSuites().addAll((Collection<? extends TPFTestSuite>)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
				getDatapools().clear();
				getDatapools().addAll((Collection<? extends DPLDatapool>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				getTestObjectives().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				setBehavior((TPFBehavior)null);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
				setPersistenceId(PERSISTENCE_ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				getTestCases().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				getSUTs().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				setArbiter((TPFArbiter)null);
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				getTestComponents().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
				getReferencedSuites().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
				getDatapools().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
				return testObjectives != null && !testObjectives.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
				return behavior != null;
			case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
				return PERSISTENCE_ID_EDEFAULT == null ? persistenceId != null : !PERSISTENCE_ID_EDEFAULT.equals(persistenceId);
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
				return testCases != null && !testCases.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
				return suTs != null && !suTs.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
				return arbiter != null;
			case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
				return testComponents != null && !testComponents.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
				return referencedSuites != null && !referencedSuites.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
				return datapools != null && !datapools.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == TPFTest.class) {
			switch (derivedFeatureID) {
				case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE: return Common_TestprofilePackage.TPF_TEST__TYPE;
				case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES: return Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES;
				case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR: return Common_TestprofilePackage.TPF_TEST__BEHAVIOR;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == TPFTest.class) {
			switch (baseFeatureID) {
				case Common_TestprofilePackage.TPF_TEST__TYPE: return Common_TestprofilePackage.TPF_TEST_SUITE__TYPE;
				case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES: return Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES;
				case Common_TestprofilePackage.TPF_TEST__BEHAVIOR: return Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", persistenceId: ");
		result.append(persistenceId);
		result.append(')');
		return result.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getISystemsUnderTest()
	 */
	public List getISystemsUnderTest() {
		return (List)getSUTs();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getITestCases()
	 */
	public List getITestCases() {
		return (List)getTestCases();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getITestComponents()
	 */
	public List getITestComponents() {
		return (List)getTestComponents();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getImplementor()
	 */
	public IImplementor getImplementor() {
		
		return (TPFBehaviorImpl)getBehavior();
	}

	private TPFBehavior getDeployableBehavior()
	{
		// This method currently takes the first behavior of the TestComponent, since every
		// behavior should point to the same deployable entity.
		return (TPFBehaviorImpl)getBehavior();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public String getLocation() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getLocation();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public String getResource() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getResource();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public void setLocation(String location) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setLocation(location);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public void setResource(String resource) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setResource(resource);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getVariables()
	 */
	public List getVariables() {
		return getInstances();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getIReferencedSuites()
	 */
	public List getIReferencedSuites() {
		return getReferencedSuites();
	}

} //TPFTestSuiteImpl
