/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFVerdictEventImpl.java,v 1.11 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Verdict Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFVerdictEventImpl#getVerdict <em>Verdict</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFVerdictEventImpl#getReason <em>Reason</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFVerdictEventImpl#getCausedBy <em>Caused By</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFVerdictEventImpl extends TPFExecutionEventImpl implements TPFVerdictEvent
{
	/**
	 * The default value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerdict()
	 * @generated
	 * @ordered
	 */
	protected static final TPFVerdict VERDICT_EDEFAULT = TPFVerdict.INCONCLUSIVE_LITERAL;

	/**
	 * The cached value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerdict()
	 * @generated
	 * @ordered
	 */
	protected TPFVerdict verdict = VERDICT_EDEFAULT;

	/**
	 * The default value of the '{@link #getReason() <em>Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReason()
	 * @generated
	 * @ordered
	 */
	protected static final TPFVerdictReason REASON_EDEFAULT = TPFVerdictReason.UNKNOWN_LITERAL;

	/**
	 * The cached value of the '{@link #getReason() <em>Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReason()
	 * @generated
	 * @ordered
	 */
	protected TPFVerdictReason reason = REASON_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCausedBy() <em>Caused By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCausedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFExecutionEvent> causedBy;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFVerdictEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_VERDICT_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFVerdict getVerdict() {
		return verdict;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVerdict(TPFVerdict newVerdict) {
		TPFVerdict oldVerdict = verdict;
		verdict = newVerdict == null ? VERDICT_EDEFAULT : newVerdict;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_VERDICT_EVENT__VERDICT, oldVerdict, verdict));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFVerdictReason getReason() {
		return reason;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReason(TPFVerdictReason newReason) {
		TPFVerdictReason oldReason = reason;
		reason = newReason == null ? REASON_EDEFAULT : newReason;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_VERDICT_EVENT__REASON, oldReason, reason));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFExecutionEvent> getCausedBy() {
		if (causedBy == null) {
			causedBy = new EObjectResolvingEList<TPFExecutionEvent>(TPFExecutionEvent.class, this, Common_TestprofilePackage.TPF_VERDICT_EVENT__CAUSED_BY);
		}
		return causedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__VERDICT:
				return getVerdict();
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__REASON:
				return getReason();
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__CAUSED_BY:
				return getCausedBy();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__VERDICT:
				setVerdict((TPFVerdict)newValue);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__REASON:
				setReason((TPFVerdictReason)newValue);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__CAUSED_BY:
				getCausedBy().clear();
				getCausedBy().addAll((Collection<? extends TPFExecutionEvent>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__VERDICT:
				setVerdict(VERDICT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__REASON:
				setReason(REASON_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__CAUSED_BY:
				getCausedBy().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__VERDICT:
				return verdict != VERDICT_EDEFAULT;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__REASON:
				return reason != REASON_EDEFAULT;
			case Common_TestprofilePackage.TPF_VERDICT_EVENT__CAUSED_BY:
				return causedBy != null && !causedBy.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (verdict: ");
		result.append(verdict);
		result.append(", reason: ");
		result.append(reason);
		result.append(')');
		return result.toString();
	}

} //TPFVerdictEventImpl
