/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: EncryptionManager.java,v 1.1 2008/03/20 17:47:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.hyades.models.common.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;


/**
 * It's used to provide encryption and decryption algorithm for a datapool.
 * 
 * @author Huang Xin Ying 
 * @verion February 28, 2008 
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public class EncryptionManager {
    
	/**
	 * Encrypt input String using RC4 algorithm  
	 * @param content
	 * @param pass
	 * @return
	 */
	public static String encrypt(String content, String pass) {		
		return new RC4Encrypter().cipherMessage(pass, content);
	}

	/**
	 * Decrypt input String using RC4 algorithm 
	 * @param content
	 * @param pass
	 * @return
	 */
	public static String decrypt(String content, String pass) {		
		return new RC4Encrypter().decipherMessage(pass, content);
	}
    
	/**
	 * Encode input String using MD5 algorithm
	 * @param str
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws UnsupportedEncodingException
	 */
	public static String EncoderByMd5(String str)
			throws NoSuchAlgorithmException, UnsupportedEncodingException {
		if (str == null)
			return null;
		
		return new RC4Encrypter().byteArrayToHexString(MessageDigest.getInstance("MD5").digest(str.getBytes()));
	}

	public static class RC4Encrypter {
		
		public static final String[] HEXARRAY = {
	        "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"
	    };

		public String cipherMessage(String pass, String content) {
			if (pass == null || pass.equals("") || content == null
					|| content.equals("")) {
				return content;
			}
			try {
				SecretKeySpec key = this.generateKey(pass);
				Cipher cipher = Cipher.getInstance("RC4");
				cipher.init(Cipher.ENCRYPT_MODE, key);
				byte[] code = cipher.update(content.getBytes());
				return byteArrayToHexString(code);
			} catch (Throwable t) {
				  //Ignore and return null.
			}
			return null;
		}

		public String decipherMessage(String pass, String encryptStr)

		{
			if (pass == null || pass.equals("") || encryptStr == null
					|| encryptStr.equals("")) {
				return encryptStr;
			}
			try {
				SecretKeySpec key = this.generateKey(pass);
				Cipher cipher = Cipher.getInstance("RC4");
				cipher.init(Cipher.DECRYPT_MODE, key);
				byte[] text = hexStringToByteArray(encryptStr);
				byte[] code = cipher.update(text);
				return new String(code);
			} catch (Throwable t) {
				//Ignore and return null.
			}
			return null;
		}

		private SecretKeySpec generateKey(String inpass)

		{
			try {
				byte[] pass = inpass.getBytes();

				MessageDigest md5 = MessageDigest.getInstance("MD5");

				md5.update(pass);
				byte temp[] = md5.digest();

				SecretKeySpec key = new SecretKeySpec(temp, "RC4");
				return key;

			} catch (Throwable t) {
				//Ignore and return null.
			}
			return null;
		}
		
		/**
	      * Method converting byte array into String.
	      *
	      * @param The byte array to be converted.
	      * @return A <code>String[]</code> containing String value of byte array.
	      */
	     public  String byteArrayToHexString(byte[] bytes){
	      
	         String result = "";
	          for (int i = 0; i < bytes.length; i++){
	            //the up 4 bits
	            int tmp = bytes[i] >>> 4;
	            result += HEXARRAY[tmp % 16];
	            //the lower 4 bits
	            tmp = bytes[i] & 0x0f;
	              result += HEXARRAY[tmp % 16];
	           }
	         
	           return result;
	           
	     }
	    
	     /**
	      * Method converting String into byte[].
	      *
	      * @param The String to be converted.
	      * @return A <code>byte[]</code> containing byte[] value of string.
	      */ 
	    public  byte[] hexStringToByteArray(String hex){
	        
	    	byte[] bytes = new byte[hex.length() / 2];
	         for (int i = 0; i < bytes.length; i++){
	              bytes[i] = (byte) Integer.parseInt(hex.substring(2*i, 2*i+2), 16);
	         }
	           
	        return bytes;
	    }		
	}	
}
