/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLParserUtil.java,v 1.3 2006/02/08 19:56:42 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.common.util;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


/**
 * Convenience Class to parse XML strings to DOM Document for XML contents retrieval.
 */
public class XMLParserUtil 
{
	private static DocumentBuilder parser;
	
	public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException 
	{
		if(parser == null)
		{
		//	 JPT: Remove xerces use
			DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
			documentBuilderFactory.setNamespaceAware(true);
			documentBuilderFactory.setValidating(false);
			parser = documentBuilderFactory.newDocumentBuilder();
		}
		
		return parser;
	}
	
	public synchronized static Document parse(String xmlString) throws IOException, SAXException, ParserConfigurationException
	{
		StringReader reader = new StringReader(xmlString);
		InputSource inputSource = new InputSource(reader);		
		return getDocumentBuilder().parse(inputSource);
	}
}
