/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCGCEvent.java,v 1.2 2007/03/01 16:44:06 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRCGC Event</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Represents a start, fininsh or other garbage collection (GC) events
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTime <em>Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTotalObjectSpace <em>Total Object Space</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjectSpace <em>Used Object Space</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjects <em>Used Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCGCEvent#getOwnerThread <em>Owner Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent()
 * @model
 * @generated
 */
public interface TRCGCEvent extends EObject {
	/**
	 * Returns the value of the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time represented here is the time when the event was generated, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Time</em>' attribute.
	 * @see #setTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_Time()
	 * @model
	 * @generated
	 */
	double getTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTime <em>Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time</em>' attribute.
	 * @see #getTime()
	 * @generated
	 */
	void setTime(double value);

	/**
	 * Returns the value of the '<em><b>Total Object Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Total amount of object space (in bytes)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Object Space</em>' attribute.
	 * @see #setTotalObjectSpace(long)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_TotalObjectSpace()
	 * @model
	 * @generated
	 */
	long getTotalObjectSpace();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTotalObjectSpace <em>Total Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Object Space</em>' attribute.
	 * @see #getTotalObjectSpace()
	 * @generated
	 */
	void setTotalObjectSpace(long value);

	/**
	 * Returns the value of the '<em><b>Used Object Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Amount of space used by the objects (in bytes)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Used Object Space</em>' attribute.
	 * @see #setUsedObjectSpace(long)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_UsedObjectSpace()
	 * @model
	 * @generated
	 */
	long getUsedObjectSpace();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjectSpace <em>Used Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Used Object Space</em>' attribute.
	 * @see #getUsedObjectSpace()
	 * @generated
	 */
	void setUsedObjectSpace(long value);

	/**
	 * Returns the value of the '<em><b>Used Objects</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of used objects on the heap
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Used Objects</em>' attribute.
	 * @see #setUsedObjects(long)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_UsedObjects()
	 * @model
	 * @generated
	 */
	long getUsedObjects();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjects <em>Used Objects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Used Objects</em>' attribute.
	 * @see #getUsedObjects()
	 * @generated
	 */
	void setUsedObjects(long value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The type of the GC event, could be start, finish, etc.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_Type()
	 * @model
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Owner Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner Thread</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owner Thread</em>' reference.
	 * @see #setOwnerThread(TRCThread)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCGCEvent_OwnerThread()
	 * @model required="true"
	 * @generated
	 */
	TRCThread getOwnerThread();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getOwnerThread <em>Owner Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Thread</em>' reference.
	 * @see #getOwnerThread()
	 * @generated
	 */
	void setOwnerThread(TRCThread value);

} // TRCGCEvent