/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCHeapObject.java,v 1.9 2010/12/07 21:07:55 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Heap Object</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCHeapObject#getRefOwner <em>Ref Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCHeapObject#getRefTarget <em>Ref Target</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCHeapObject()
 * @model
 * @generated
 */
public interface TRCHeapObject extends TRCObject {
	/**
	 * Returns the value of the '<em><b>Ref Owner</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObjectReference}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCObjectReference#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ref Owner</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * transient
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ref Owner</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCHeapObject_RefOwner()
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference#getOwner
	 * @model opposite="owner" resolveProxies="false" transient="true"
	 * @generated
	 */
	EList<TRCObjectReference> getRefOwner();

	/**
	 * Returns the value of the '<em><b>Ref Target</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObjectReference}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCObjectReference#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ref Target</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * transient
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ref Target</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCHeapObject_RefTarget()
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference#getTarget
	 * @model opposite="target" resolveProxies="false" transient="true"
	 * @generated
	 */
	EList<TRCObjectReference> getRefTarget();

} // TRCHeapObject
