/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCInputOutputContainer.java,v 1.8 2009/05/05 15:49:16 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Input Output Container</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The container of all parameters/return values and also of the Map entries (key=TRCMethodInvocation, value=list of TRCObjectValue).
 * 
 * The instances of this class will be root objects in resources with trciovxmi extension.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getEntries <em>Entries</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getInputOutputValues <em>Input Output Values</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCInputOutputContainer()
 * @model
 * @generated
 */
public interface TRCInputOutputContainer extends EObject {
	/**
	 * Returns the value of the '<em><b>Process</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer <em>Input Output Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' reference.
	 * @see #setProcess(TRCProcess)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCInputOutputContainer_Process()
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer
	 * @model opposite="inputOutputContainer" required="true"
	 * @generated
	 */
	TRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess <em>Process</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(TRCProcess value);

	/**
	 * Returns the value of the '<em><b>Entries</b></em>' map.
	 * The key is of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation},
	 * and the value is of type list of {@link org.eclipse.hyades.models.trace.TRCObjectValue},
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Entries</em>' map isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Entries</em>' map.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCInputOutputContainer_Entries()
	 * @model mapType="org.eclipse.hyades.models.trace.TRCInputOutputEntry<org.eclipse.hyades.models.trace.TRCMethodInvocation, org.eclipse.hyades.models.trace.TRCObjectValue>"
	 * @generated
	 */
	EMap<TRCMethodInvocation, EList<TRCObjectValue>> getEntries();

	/**
	 * Returns the value of the '<em><b>Input Output Values</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObjectValue}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Input Output Values</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Output Values</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCInputOutputContainer_InputOutputValues()
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue#getContainer
	 * @model opposite="container" resolveProxies="false" transient="true"
	 * @generated
	 */
	EList<TRCObjectValue> getInputOutputValues();

} // TRCInputOutputContainer
