/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCMethodProperties.java,v 1.8 2009/05/05 15:49:16 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TRC Method Properties</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Used as a bitmask for the TRCMethod.modifier field.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodProperties()
 * @model
 * @generated
 */
public enum TRCMethodProperties implements Enumerator
{
	/**
	 * The '<em><b>JAVA NATIVE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA NATIVE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_NATIVE
	 * @generated
	 * @ordered
	 */
	JAVA_NATIVE_LITERAL(1, "JAVA_NATIVE", "JAVA_NATIVE"),
	/**
	 * The '<em><b>JAVA SYNCHRONIZED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA SYNCHRONIZED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_SYNCHRONIZED
	 * @generated
	 * @ordered
	 */
	JAVA_SYNCHRONIZED_LITERAL(2, "JAVA_SYNCHRONIZED", "JAVA_SYNCHRONIZED"),
	/**
	 * The '<em><b>JAVA PUBLIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA PUBLIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_PUBLIC
	 * @generated
	 * @ordered
	 */
	JAVA_PUBLIC_LITERAL(4, "JAVA_PUBLIC", "JAVA_PUBLIC"),
	/**
	 * The '<em><b>JAVA PRIVATE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA PRIVATE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_PRIVATE
	 * @generated
	 * @ordered
	 */
	JAVA_PRIVATE_LITERAL(8, "JAVA_PRIVATE", "JAVA_PRIVATE"),
	/**
	 * The '<em><b>JAVA PROTECTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA PROTECTED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_PROTECTED
	 * @generated
	 * @ordered
	 */
	JAVA_PROTECTED_LITERAL(16, "JAVA_PROTECTED", "JAVA_PROTECTED"),
	/**
	 * The '<em><b>JAVA DEFAULT VISIBILITY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA DEFAULT VISIBILITY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_DEFAULT_VISIBILITY
	 * @generated
	 * @ordered
	 */
	JAVA_DEFAULT_VISIBILITY_LITERAL(32, "JAVA_DEFAULT_VISIBILITY", "JAVA_DEFAULT_VISIBILITY"),
	/**
	 * The '<em><b>JAVA STATIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA STATIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_STATIC
	 * @generated
	 * @ordered
	 */
	JAVA_STATIC_LITERAL(64, "JAVA_STATIC", "JAVA_STATIC"),
	/**
	 * The '<em><b>JAVA CONSTRUCTOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA CONSTRUCTOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_CONSTRUCTOR
	 * @generated
	 * @ordered
	 */
	JAVA_CONSTRUCTOR_LITERAL(128, "JAVA_CONSTRUCTOR", "JAVA_CONSTRUCTOR"),
	/**
	 * The '<em><b>JAVA ABSTRACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA ABSTRACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_ABSTRACT
	 * @generated
	 * @ordered
	 */
	JAVA_ABSTRACT_LITERAL(256, "JAVA_ABSTRACT", "JAVA_ABSTRACT"),
	/**
	 * The '<em><b>JAVA FINALIZER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA FINALIZER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_FINALIZER
	 * @generated
	 * @ordered
	 */
	JAVA_FINALIZER_LITERAL(512, "JAVA_FINALIZER", "JAVA_FINALIZER");
	/**
	 * The '<em><b>JAVA NATIVE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_NATIVE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_NATIVE = 1;

	/**
	 * The '<em><b>JAVA SYNCHRONIZED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_SYNCHRONIZED_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_SYNCHRONIZED = 2;

	/**
	 * The '<em><b>JAVA PUBLIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_PUBLIC_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_PUBLIC = 4;

	/**
	 * The '<em><b>JAVA PRIVATE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_PRIVATE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_PRIVATE = 8;

	/**
	 * The '<em><b>JAVA PROTECTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_PROTECTED_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_PROTECTED = 16;

	/**
	 * The '<em><b>JAVA DEFAULT VISIBILITY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_DEFAULT_VISIBILITY_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_DEFAULT_VISIBILITY = 32;

	/**
	 * The '<em><b>JAVA STATIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_STATIC_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_STATIC = 64;

	/**
	 * The '<em><b>JAVA CONSTRUCTOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_CONSTRUCTOR_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_CONSTRUCTOR = 128;

	/**
	 * The '<em><b>JAVA ABSTRACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_ABSTRACT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_ABSTRACT = 256;

	/**
	 * The '<em><b>JAVA FINALIZER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_FINALIZER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_FINALIZER = 512;

	/**
	 * An array of all the '<em><b>TRC Method Properties</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TRCMethodProperties[] VALUES_ARRAY =
		new TRCMethodProperties[] {
			JAVA_NATIVE_LITERAL,
			JAVA_SYNCHRONIZED_LITERAL,
			JAVA_PUBLIC_LITERAL,
			JAVA_PRIVATE_LITERAL,
			JAVA_PROTECTED_LITERAL,
			JAVA_DEFAULT_VISIBILITY_LITERAL,
			JAVA_STATIC_LITERAL,
			JAVA_CONSTRUCTOR_LITERAL,
			JAVA_ABSTRACT_LITERAL,
			JAVA_FINALIZER_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TRC Method Properties</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<TRCMethodProperties> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TRC Method Properties</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCMethodProperties get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCMethodProperties result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Method Properties</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCMethodProperties getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCMethodProperties result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Method Properties</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCMethodProperties get(int value) {
		switch (value) {
			case JAVA_NATIVE: return JAVA_NATIVE_LITERAL;
			case JAVA_SYNCHRONIZED: return JAVA_SYNCHRONIZED_LITERAL;
			case JAVA_PUBLIC: return JAVA_PUBLIC_LITERAL;
			case JAVA_PRIVATE: return JAVA_PRIVATE_LITERAL;
			case JAVA_PROTECTED: return JAVA_PROTECTED_LITERAL;
			case JAVA_DEFAULT_VISIBILITY: return JAVA_DEFAULT_VISIBILITY_LITERAL;
			case JAVA_STATIC: return JAVA_STATIC_LITERAL;
			case JAVA_CONSTRUCTOR: return JAVA_CONSTRUCTOR_LITERAL;
			case JAVA_ABSTRACT: return JAVA_ABSTRACT_LITERAL;
			case JAVA_FINALIZER: return JAVA_FINALIZER_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TRCMethodProperties(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

	public static String getString(String key)
	{
		return key;
	}

	public static TRCMethodProperties getByLabel(String label)
	{
		if(label != null)
		{
			for (int i = 0, maxi=VALUES_ARRAY.length; i < maxi; i++)
			{
				if(label.equals(VALUES_ARRAY[i].getLabel()))
					return VALUES_ARRAY[i];							
			}
		}
		return VALUES_ARRAY[0];	
	}

	public String getLabel()
	{
		try
		{
			return getString(getClass().getName() + "." + getName());
		}
		catch(RuntimeException e)
		{
			return getName();
		} 
	}
}
