/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectValue.java,v 1.9 2009/05/05 15:49:16 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Object Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This represent the toString() value of an object. The collection agent can send a different string representation of the object if the output from toString() method is not appropiate.
 * 
 * Later we can extend this class with specialized value classes.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCObjectValue#getStringValue <em>String Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCObjectValue#getTRCInputOutputEntry <em>TRC Input Output Entry</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCObjectValue#getContainer <em>Container</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValue()
 * @model
 * @generated
 */
public interface TRCObjectValue extends EObject {
	/**
	 * Returns the value of the '<em><b>String Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>String Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>String Value</em>' attribute.
	 * @see #setStringValue(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValue_StringValue()
	 * @model
	 * @generated
	 */
	String getStringValue();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getStringValue <em>String Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>String Value</em>' attribute.
	 * @see #getStringValue()
	 * @generated
	 */
	void setStringValue(String value);

	/**
	 * Returns the value of the '<em><b>TRC Input Output Entry</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>TRC Input Output Entry</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>TRC Input Output Entry</em>' container reference.
	 * @see #setTRCInputOutputEntry(Map.Entry)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValue_TRCInputOutputEntry()
	 * @model mapType="org.eclipse.hyades.models.trace.TRCInputOutputEntry<org.eclipse.hyades.models.trace.TRCMethodInvocation, org.eclipse.hyades.models.trace.TRCObjectValue>" transient="true"
	 * @generated
	 */
	Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> getTRCInputOutputEntry();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getTRCInputOutputEntry <em>TRC Input Output Entry</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>TRC Input Output Entry</em>' container reference.
	 * @see #getTRCInputOutputEntry()
	 * @generated
	 */
	void setTRCInputOutputEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> value);

	/**
	 * Returns the value of the '<em><b>Container</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getInputOutputValues <em>Input Output Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Container</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Container</em>' reference.
	 * @see #setContainer(TRCInputOutputContainer)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValue_Container()
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer#getInputOutputValues
	 * @model opposite="inputOutputValues" resolveProxies="false" transient="true"
	 * @generated
	 */
	TRCInputOutputContainer getContainer();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getContainer <em>Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Container</em>' reference.
	 * @see #getContainer()
	 * @generated
	 */
	void setContainer(TRCInputOutputContainer value);

} // TRCObjectValue
