/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectValueKind.java,v 1.8 2009/05/05 15:49:16 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TRC Object Value Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValueKind()
 * @model
 * @generated
 */
public enum TRCObjectValueKind implements Enumerator
{
	/**
	 * The '<em><b>This</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #THIS
	 * @generated
	 * @ordered
	 */
	THIS_LITERAL(0, "this", "this"),
	/**
	 * The '<em><b>Aggregated</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AGGREGATED
	 * @generated
	 * @ordered
	 */
	AGGREGATED_LITERAL(1, "aggregated", "aggregated"),
	/**
	 * The '<em><b>Query</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #QUERY
	 * @generated
	 * @ordered
	 */
	QUERY_LITERAL(2, "query", "query"),
	/**
	 * The '<em><b>Protocol</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL
	 * @generated
	 * @ordered
	 */
	PROTOCOL_LITERAL(3, "protocol", "protocol"),
	/**
	 * The '<em><b>Exception</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXCEPTION
	 * @generated
	 * @ordered
	 */
	EXCEPTION_LITERAL(4, "exception", "exception");
	/**
	 * The '<em><b>This</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents the value of "this" or "self"
	 * <!-- end-model-doc -->
	 * @see #THIS_LITERAL
	 * @model name="this"
	 * @generated
	 * @ordered
	 */
	public static final int THIS = 0;

	/**
	 * The '<em><b>Aggregated</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents multiple or all parameters/return values in one object
	 * <!-- end-model-doc -->
	 * @see #AGGREGATED_LITERAL
	 * @model name="aggregated"
	 * @generated
	 * @ordered
	 */
	public static final int AGGREGATED = 1;

	/**
	 * The '<em><b>Query</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Used for SQL query parameters, this will include data source + SQL statement
	 * <!-- end-model-doc -->
	 * @see #QUERY_LITERAL
	 * @model name="query"
	 * @generated
	 * @ordered
	 */
	public static final int QUERY = 2;

	/**
	 * The '<em><b>Protocol</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents protocol related parameters, for example for HTTP: request, response
	 * <!-- end-model-doc -->
	 * @see #PROTOCOL_LITERAL
	 * @model name="protocol"
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL = 3;

	/**
	 * The '<em><b>Exception</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * the method exited with an exception
	 * <!-- end-model-doc -->
	 * @see #EXCEPTION_LITERAL
	 * @model name="exception"
	 * @generated
	 * @ordered
	 */
	public static final int EXCEPTION = 4;

	/**
	 * An array of all the '<em><b>TRC Object Value Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TRCObjectValueKind[] VALUES_ARRAY =
		new TRCObjectValueKind[] {
			THIS_LITERAL,
			AGGREGATED_LITERAL,
			QUERY_LITERAL,
			PROTOCOL_LITERAL,
			EXCEPTION_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TRC Object Value Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<TRCObjectValueKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TRC Object Value Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValueKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCObjectValueKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Object Value Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValueKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCObjectValueKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Object Value Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValueKind get(int value) {
		switch (value) {
			case THIS: return THIS_LITERAL;
			case AGGREGATED: return AGGREGATED_LITERAL;
			case QUERY: return QUERY_LITERAL;
			case PROTOCOL: return PROTOCOL_LITERAL;
			case EXCEPTION: return EXCEPTION_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TRCObjectValueKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
}
