/**********************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel - Initial API and implementation
 *
 * $Id: TRCThreadExecEvent.java,v 1.3 2009/05/05 15:49:16 paules Exp $
 **********************************************************************/
package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Thread Exec Event</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent#getRunningEvents <em>Running Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent#isInCriticalPath <em>In Critical Path</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThreadExecEvent()
 * @model
 * @generated
 */
public interface TRCThreadExecEvent extends TRCThreadEvent {
	/**
	 * Returns the value of the '<em><b>Running Events</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCThreadRunningEvent}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Running Events</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Running Events</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThreadExecEvent_RunningEvents()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<TRCThreadRunningEvent> getRunningEvents();

	/**
	 * Returns the value of the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>In Critical Path</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>In Critical Path</em>' attribute.
	 * @see #setInCriticalPath(boolean)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCThreadExecEvent_InCriticalPath()
	 * @model
	 * @generated
	 */
	boolean isInCriticalPath();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent#isInCriticalPath <em>In Critical Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>In Critical Path</em>' attribute.
	 * @see #isInCriticalPath()
	 * @generated
	 */
	void setInCriticalPath(boolean value);

} // TRCThreadExecEvent