/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TracePackage.java,v 1.15 2010/12/08 18:45:46 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The purpose of the trace model is to capture execution behavior of an application. This includes call stack tracing as well as object/memory observation. All over multi process/tier environments.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.trace.TraceFactory
 * @model kind="package"
 * @generated
 */
public interface TracePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "trace";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/trace.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Trace";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TracePackage eINSTANCE = org.eclipse.hyades.models.trace.impl.TracePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl <em>TRC Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObject()
	 * @generated
	 */
	int TRC_OBJECT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCLanguageElementImpl <em>TRC Language Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCLanguageElementImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLanguageElement()
	 * @generated
	 */
	int TRC_LANGUAGE_ELEMENT = 43;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl <em>TRC Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCClassImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCClass()
	 * @generated
	 */
	int TRC_CLASS = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl <em>TRC Method Invocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodInvocation()
	 * @generated
	 */
	int TRC_METHOD_INVOCATION = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl <em>TRC Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCProcessImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCProcess()
	 * @generated
	 */
	int TRC_PROCESS = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl <em>TRC Thread</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThread()
	 * @generated
	 */
	int TRC_THREAD = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl <em>TRC Method</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCMethodImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethod()
	 * @generated
	 */
	int TRC_METHOD = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl <em>TRC Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCPackageImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCPackage()
	 * @generated
	 */
	int TRC_PACKAGE = 7;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl <em>TRC Collection Boundary</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCCollectionBoundary()
	 * @generated
	 */
	int TRC_COLLECTION_BOUNDARY = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl <em>TRC Class Loader</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCClassLoader()
	 * @generated
	 */
	int TRC_CLASS_LOADER = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl <em>TRC Source Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSourceInfo()
	 * @generated
	 */
	int TRC_SOURCE_INFO = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl <em>TRC Heap Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapObject()
	 * @generated
	 */
	int TRC_HEAP_OBJECT = 11;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl <em>TRC Trace Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCTraceObject()
	 * @generated
	 */
	int TRC_TRACE_OBJECT = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl <em>TRC Full Trace Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullTraceObject()
	 * @generated
	 */
	int TRC_FULL_TRACE_OBJECT = 12;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl <em>TRC Full Heap Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullHeapObject()
	 * @generated
	 */
	int TRC_FULL_HEAP_OBJECT = 14;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl <em>TRC Object Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectReference()
	 * @generated
	 */
	int TRC_OBJECT_REFERENCE = 15;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl <em>TRC Heap Dump</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapDump()
	 * @generated
	 */
	int TRC_HEAP_DUMP = 16;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl <em>TRC Aggregated Method Invocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION = 17;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl <em>TRC Full Method Invocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullMethodInvocation()
	 * @generated
	 */
	int TRC_FULL_METHOD_INVOCATION = 18;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl <em>TRC Heap Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapRoot()
	 * @generated
	 */
	int TRC_HEAP_ROOT = 19;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl <em>TRC Array Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCArrayClass()
	 * @generated
	 */
	int TRC_ARRAY_CLASS = 20;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl <em>TRC Aggregated Object Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCAggregatedObjectReference()
	 * @generated
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE = 21;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadEventImpl <em>TRC Thread Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadEvent()
	 * @generated
	 */
	int TRC_THREAD_EVENT = 22;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl <em>TRC Thread Sleeping Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadSleepingEvent()
	 * @generated
	 */
	int TRC_THREAD_SLEEPING_EVENT = 23;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl <em>TRC Thread Waiting For Object Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForObjectEvent()
	 * @generated
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT = 24;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl <em>TRC Thread Waiting For Lock Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForLockEvent()
	 * @generated
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT = 25;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadRunningEventImpl <em>TRC Thread Running Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadRunningEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadRunningEvent()
	 * @generated
	 */
	int TRC_THREAD_RUNNING_EVENT = 26;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadEventImpl <em>TRC Thread Dead Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadEvent()
	 * @generated
	 */
	int TRC_THREAD_DEAD_EVENT = 27;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl <em>TRC Method With LL Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodWithLLData()
	 * @generated
	 */
	int TRC_METHOD_WITH_LL_DATA = 28;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCLLDataImpl <em>TRCLL Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCLLDataImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLLData()
	 * @generated
	 */
	int TRCLL_DATA = 29;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCSourceInfoWithLLDataImpl <em>TRC Source Info With LL Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCSourceInfoWithLLDataImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSourceInfoWithLLData()
	 * @generated
	 */
	int TRC_SOURCE_INFO_WITH_LL_DATA = 30;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl <em>TRC Line Coverage Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLineCoverageData()
	 * @generated
	 */
	int TRC_LINE_COVERAGE_DATA = 31;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl <em>TRC Object Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValue()
	 * @generated
	 */
	int TRC_OBJECT_VALUE = 32;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputEntryImpl <em>TRC Input Output Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCInputOutputEntryImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCInputOutputEntry()
	 * @generated
	 */
	int TRC_INPUT_OUTPUT_ENTRY = 33;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl <em>TRC Input Output Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCInputOutputContainer()
	 * @generated
	 */
	int TRC_INPUT_OUTPUT_CONTAINER = 34;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl <em>TRC Caller Callee Invocation Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCCallerCalleeInvocationInfo()
	 * @generated
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO = 35;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl <em>TRC Typed Object Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCTypedObjectValue()
	 * @generated
	 */
	int TRC_TYPED_OBJECT_VALUE = 36;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCMthdLckAccEntryImpl <em>TRC Mthd Lck Acc Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCMthdLckAccEntryImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMthdLckAccEntry()
	 * @generated
	 */
	int TRC_MTHD_LCK_ACC_ENTRY = 37;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl <em>TRC Lock Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLockAccess()
	 * @generated
	 */
	int TRC_LOCK_ACCESS = 38;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl <em>TRC Line Performance Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLinePerformanceData()
	 * @generated
	 */
	int TRC_LINE_PERFORMANCE_DATA = 39;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSitesEntryImpl <em>TRC Object Allocation Sites Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSitesEntryImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationSitesEntry()
	 * @generated
	 */
	int TRC_OBJECT_ALLOCATION_SITES_ENTRY = 40;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl <em>TRC Object Allocation Site</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationSite()
	 * @generated
	 */
	int TRC_OBJECT_ALLOCATION_SITE = 41;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadLockEventImpl <em>TRC Thread Dead Lock Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadLockEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadLockEvent()
	 * @generated
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT = 42;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl <em>TRCGC Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCGCEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCGCEvent()
	 * @generated
	 */
	int TRCGC_EVENT = 0;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__TIME = 0;

	/**
	 * The feature id for the '<em><b>Total Object Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__TOTAL_OBJECT_SPACE = 1;

	/**
	 * The feature id for the '<em><b>Used Object Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__USED_OBJECT_SPACE = 2;

	/**
	 * The feature id for the '<em><b>Used Objects</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__USED_OBJECTS = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__TYPE = 4;

	/**
	 * The feature id for the '<em><b>Owner Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT__OWNER_THREAD = 5;

	/**
	 * The number of structural features of the '<em>TRCGC Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCGC_EVENT_FEATURE_COUNT = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT__ID = 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT__SIZE = 1;

	/**
	 * The feature id for the '<em><b>Is A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT__IS_A = 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT__PROCESS = 3;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT__CUMULATIVE_SIZE = 4;

	/**
	 * The number of structural features of the '<em>TRC Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_FEATURE_COUNT = 5;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LANGUAGE_ELEMENT__SOURCE_INFO = 0;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LANGUAGE_ELEMENT__ANNOTATIONS = 1;

	/**
	 * The number of structural features of the '<em>TRC Language Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LANGUAGE_ELEMENT_FEATURE_COUNT = 2;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__SOURCE_INFO = TRC_LANGUAGE_ELEMENT__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__ANNOTATIONS = TRC_LANGUAGE_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__ID = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__NAME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Load Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__LOAD_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Unload Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__UNLOAD_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__INTERFACE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__LINE_NO = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__LINE_COUNT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__BASE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__CUMULATIVE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__CALLS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__INHERITED_CALLS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__INHERITED_BASE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__INHERITED_CUMULATIVE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__TOTAL_SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__TOTAL_INSTANCES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__COLLECTED_SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__COLLECTED_INSTANCES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__TOTAL_CPU_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__OBJECTS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Loaded By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__LOADED_BY = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__METHODS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Class Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__CLASS_OBJECTS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__PACKAGE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Class Loader</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__CLASS_LOADER = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Enclosed By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__ENCLOSED_BY = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Extends</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__EXTENDS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Implements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__IMPLEMENTS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Locks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__LOCKS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS__CUMULATIVE_SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The number of structural features of the '<em>TRC Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS_FEATURE_COUNT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__METHOD = 0;

	/**
	 * The feature id for the '<em><b>Invoked By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__INVOKED_BY = 1;

	/**
	 * The feature id for the '<em><b>Invokes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__INVOKES = 2;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__THREAD = 3;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__PROCESS = 4;

	/**
	 * The feature id for the '<em><b>Owning Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION__OWNING_OBJECT = 5;

	/**
	 * The number of structural features of the '<em>TRC Method Invocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_INVOCATION_FEATURE_COUNT = 6;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__AGENT = HierarchyPackage.ABSTRACT_TRC_PROCESS__AGENT;

	/**
	 * The feature id for the '<em><b>Pid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__PID = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__NAME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__ID = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__START_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__STOP_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Last Event Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__LAST_EVENT_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Init Finished Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INIT_FINISHED_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__BASE_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__CUMULATIVE_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__CALLS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INHERITED_CALLS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INHERITED_BASE_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INHERITED_CUMULATIVE_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__TOTAL_SIZE = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__TOTAL_INSTANCES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__COLLECTED_SIZE = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__COLLECTED_INSTANCES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Reference Pointer Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__REFERENCE_POINTER_SIZE = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__TOTAL_CPU_TIME = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Cpu Sample Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__CPU_SAMPLE_RESOLUTION = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Thread States</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__THREAD_STATES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Precision</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__PRECISION = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Languages</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__LANGUAGES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__THREADS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__PACKAGES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Class Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__CLASS_CLASS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Collection Boundary Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__COLLECTION_BOUNDARY_POINTS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Class Loaders</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__CLASS_LOADERS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Source Infos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__SOURCE_INFOS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Objects</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__OBJECTS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Heap Dumps</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__HEAP_DUMPS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INVOCATIONS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Input Output Container</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__INPUT_OUTPUT_CONTAINER = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Method Lock Access Entries</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Allocation Sites Entries</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__ALLOCATION_SITES_ENTRIES = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__ANNOTATIONS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Gc Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS__GC_EVENTS = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 36;

	/**
	 * The number of structural features of the '<em>TRC Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_FEATURE_COUNT = HierarchyPackage.ABSTRACT_TRC_PROCESS_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__NAME = 1;

	/**
	 * The feature id for the '<em><b>Group Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__GROUP_NAME = 2;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__START_TIME = 3;

	/**
	 * The feature id for the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__STOP_TIME = 4;

	/**
	 * The feature id for the '<em><b>Max Stack Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__MAX_STACK_DEPTH = 5;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__TOTAL_CPU_TIME = 6;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__PROCESS = 7;

	/**
	 * The feature id for the '<em><b>Initial Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__INITIAL_INVOCATIONS = 8;

	/**
	 * The feature id for the '<em><b>Thread Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__THREAD_OBJECT = 9;

	/**
	 * The feature id for the '<em><b>Thread Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__THREAD_EVENTS = 10;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD__ANNOTATIONS = 11;

	/**
	 * The number of structural features of the '<em>TRC Thread</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_FEATURE_COUNT = 12;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__SOURCE_INFO = TRC_LANGUAGE_ELEMENT__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__ANNOTATIONS = TRC_LANGUAGE_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__ID = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__NAME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Signature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__SIGNATURE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__MODIFIER = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__NOTATION = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__LINE_NO = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__LINE_COUNT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__BASE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__CUMULATIVE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__CALLS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__TOTAL_CPU_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Defining Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__DEFINING_CLASS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD__INVOCATIONS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>TRC Method</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_FEATURE_COUNT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__SOURCE_INFO = TRC_LANGUAGE_ELEMENT__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__ANNOTATIONS = TRC_LANGUAGE_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__NAME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__BASE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__CUMULATIVE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__CALLS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__INHERITED_CALLS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__INHERITED_BASE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__INHERITED_CUMULATIVE_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__TOTAL_SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__TOTAL_INSTANCES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__COLLECTED_SIZE = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__COLLECTED_INSTANCES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__TOTAL_CPU_TIME = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__PROCESS = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__CLASSES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Sub Packages</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__SUB_PACKAGES = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE__PARENT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>TRC Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PACKAGE_FEATURE_COUNT = TRC_LANGUAGE_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__NAME = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__START_TIME = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME;

	/**
	 * The feature id for the '<em><b>Collection Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__COLLECTION_MODE = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__CONFIGURATION = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Last Invocation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_INVOCATION = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__PROCESS = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_CLASS = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Last Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_THREAD = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Last Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_OBJECT = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Last Package</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_PACKAGE = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__LAST_METHOD = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Heap Dump</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY__HEAP_DUMP = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>TRC Collection Boundary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_COLLECTION_BOUNDARY_FEATURE_COUNT = HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS_LOADER__PROCESS = 0;

	/**
	 * The feature id for the '<em><b>Class Loader Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE = 1;

	/**
	 * The number of structural features of the '<em>TRC Class Loader</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CLASS_LOADER_FEATURE_COUNT = 2;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO__LOCATION = 0;

	/**
	 * The feature id for the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO__LANGUAGE = 1;

	/**
	 * The number of structural features of the '<em>TRC Source Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO_FEATURE_COUNT = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__ID = TRC_OBJECT__ID;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__SIZE = TRC_OBJECT__SIZE;

	/**
	 * The feature id for the '<em><b>Is A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__IS_A = TRC_OBJECT__IS_A;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__PROCESS = TRC_OBJECT__PROCESS;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__CUMULATIVE_SIZE = TRC_OBJECT__CUMULATIVE_SIZE;

	/**
	 * The feature id for the '<em><b>Ref Owner</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__REF_OWNER = TRC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ref Target</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT__REF_TARGET = TRC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Heap Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_OBJECT_FEATURE_COUNT = TRC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__ID = TRC_OBJECT__ID;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__SIZE = TRC_OBJECT__SIZE;

	/**
	 * The feature id for the '<em><b>Is A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__IS_A = TRC_OBJECT__IS_A;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__PROCESS = TRC_OBJECT__PROCESS;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__CUMULATIVE_SIZE = TRC_OBJECT__CUMULATIVE_SIZE;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__INVOCATIONS = TRC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT__THREAD = TRC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Trace Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TRACE_OBJECT_FEATURE_COUNT = TRC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__ID = TRC_TRACE_OBJECT__ID;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__SIZE = TRC_TRACE_OBJECT__SIZE;

	/**
	 * The feature id for the '<em><b>Is A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__IS_A = TRC_TRACE_OBJECT__IS_A;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__PROCESS = TRC_TRACE_OBJECT__PROCESS;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__CUMULATIVE_SIZE = TRC_TRACE_OBJECT__CUMULATIVE_SIZE;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__INVOCATIONS = TRC_TRACE_OBJECT__INVOCATIONS;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__THREAD = TRC_TRACE_OBJECT__THREAD;

	/**
	 * The feature id for the '<em><b>Create Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__CREATE_TIME = TRC_TRACE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Collect Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__COLLECT_TIME = TRC_TRACE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__BASE_TIME = TRC_TRACE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__CUMULATIVE_TIME = TRC_TRACE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT__CALLS = TRC_TRACE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>TRC Full Trace Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_TRACE_OBJECT_FEATURE_COUNT = TRC_TRACE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__ID = TRC_HEAP_OBJECT__ID;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__SIZE = TRC_HEAP_OBJECT__SIZE;

	/**
	 * The feature id for the '<em><b>Is A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__IS_A = TRC_HEAP_OBJECT__IS_A;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__PROCESS = TRC_HEAP_OBJECT__PROCESS;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__CUMULATIVE_SIZE = TRC_HEAP_OBJECT__CUMULATIVE_SIZE;

	/**
	 * The feature id for the '<em><b>Ref Owner</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__REF_OWNER = TRC_HEAP_OBJECT__REF_OWNER;

	/**
	 * The feature id for the '<em><b>Ref Target</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__REF_TARGET = TRC_HEAP_OBJECT__REF_TARGET;

	/**
	 * The feature id for the '<em><b>Heap Dump First Seen</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN = TRC_HEAP_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Full Heap Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_HEAP_OBJECT_FEATURE_COUNT = TRC_HEAP_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Heap Dump</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_REFERENCE__HEAP_DUMP = 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_REFERENCE__OWNER = 1;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_REFERENCE__TARGET = 2;

	/**
	 * The number of structural features of the '<em>TRC Object Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_REFERENCE_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__ID = 0;

	/**
	 * The feature id for the '<em><b>Entry Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__ENTRY_TIME = 1;

	/**
	 * The feature id for the '<em><b>Exit Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__EXIT_TIME = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__NAME = 3;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__REFERENCES = 4;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__PROCESS = 5;

	/**
	 * The feature id for the '<em><b>Gc Roots</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP__GC_ROOTS = 6;

	/**
	 * The number of structural features of the '<em>TRC Heap Dump</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_DUMP_FEATURE_COUNT = 7;

	/**
	 * The feature id for the '<em><b>Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__METHOD = TRC_METHOD_INVOCATION__METHOD;

	/**
	 * The feature id for the '<em><b>Invoked By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY = TRC_METHOD_INVOCATION__INVOKED_BY;

	/**
	 * The feature id for the '<em><b>Invokes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__INVOKES = TRC_METHOD_INVOCATION__INVOKES;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__THREAD = TRC_METHOD_INVOCATION__THREAD;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__PROCESS = TRC_METHOD_INVOCATION__PROCESS;

	/**
	 * The feature id for the '<em><b>Owning Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT = TRC_METHOD_INVOCATION__OWNING_OBJECT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__COUNT = TRC_METHOD_INVOCATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Min Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Max Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Caller Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO = TRC_METHOD_INVOCATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>TRC Aggregated Method Invocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_METHOD_INVOCATION_FEATURE_COUNT = TRC_METHOD_INVOCATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__METHOD = TRC_METHOD_INVOCATION__METHOD;

	/**
	 * The feature id for the '<em><b>Invoked By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__INVOKED_BY = TRC_METHOD_INVOCATION__INVOKED_BY;

	/**
	 * The feature id for the '<em><b>Invokes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__INVOKES = TRC_METHOD_INVOCATION__INVOKES;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__THREAD = TRC_METHOD_INVOCATION__THREAD;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__PROCESS = TRC_METHOD_INVOCATION__PROCESS;

	/**
	 * The feature id for the '<em><b>Owning Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT = TRC_METHOD_INVOCATION__OWNING_OBJECT;

	/**
	 * The feature id for the '<em><b>Stack Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__STACK_DEPTH = TRC_METHOD_INVOCATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entry Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__ENTRY_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Exit Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__EXIT_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ticket</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__TICKET = TRC_METHOD_INVOCATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__OVERHEAD = TRC_METHOD_INVOCATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Caller Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO = TRC_METHOD_INVOCATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION__CPU_TIME = TRC_METHOD_INVOCATION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>TRC Full Method Invocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FULL_METHOD_INVOCATION_FEATURE_COUNT = TRC_METHOD_INVOCATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Frame</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT__FRAME = 1;

	/**
	 * The feature id for the '<em><b>Heap Dump</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT__HEAP_DUMP = 2;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT__THREAD = 3;

	/**
	 * The feature id for the '<em><b>Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT__OBJECT = 4;

	/**
	 * The number of structural features of the '<em>TRC Heap Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_HEAP_ROOT_FEATURE_COUNT = 5;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__SOURCE_INFO = TRC_CLASS__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__ANNOTATIONS = TRC_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__ID = TRC_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__NAME = TRC_CLASS__NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__SIZE = TRC_CLASS__SIZE;

	/**
	 * The feature id for the '<em><b>Load Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__LOAD_TIME = TRC_CLASS__LOAD_TIME;

	/**
	 * The feature id for the '<em><b>Unload Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__UNLOAD_TIME = TRC_CLASS__UNLOAD_TIME;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__INTERFACE = TRC_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__LINE_NO = TRC_CLASS__LINE_NO;

	/**
	 * The feature id for the '<em><b>Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__LINE_COUNT = TRC_CLASS__LINE_COUNT;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__BASE_TIME = TRC_CLASS__BASE_TIME;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__CUMULATIVE_TIME = TRC_CLASS__CUMULATIVE_TIME;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__CALLS = TRC_CLASS__CALLS;

	/**
	 * The feature id for the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__INHERITED_CALLS = TRC_CLASS__INHERITED_CALLS;

	/**
	 * The feature id for the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__INHERITED_BASE_TIME = TRC_CLASS__INHERITED_BASE_TIME;

	/**
	 * The feature id for the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__INHERITED_CUMULATIVE_TIME = TRC_CLASS__INHERITED_CUMULATIVE_TIME;

	/**
	 * The feature id for the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__TOTAL_SIZE = TRC_CLASS__TOTAL_SIZE;

	/**
	 * The feature id for the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__TOTAL_INSTANCES = TRC_CLASS__TOTAL_INSTANCES;

	/**
	 * The feature id for the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__COLLECTED_SIZE = TRC_CLASS__COLLECTED_SIZE;

	/**
	 * The feature id for the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__COLLECTED_INSTANCES = TRC_CLASS__COLLECTED_INSTANCES;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__TOTAL_CPU_TIME = TRC_CLASS__TOTAL_CPU_TIME;

	/**
	 * The feature id for the '<em><b>Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__OBJECTS = TRC_CLASS__OBJECTS;

	/**
	 * The feature id for the '<em><b>Loaded By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__LOADED_BY = TRC_CLASS__LOADED_BY;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__METHODS = TRC_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Class Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__CLASS_OBJECTS = TRC_CLASS__CLASS_OBJECTS;

	/**
	 * The feature id for the '<em><b>Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__PACKAGE = TRC_CLASS__PACKAGE;

	/**
	 * The feature id for the '<em><b>Class Loader</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__CLASS_LOADER = TRC_CLASS__CLASS_LOADER;

	/**
	 * The feature id for the '<em><b>Enclosed By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__ENCLOSED_BY = TRC_CLASS__ENCLOSED_BY;

	/**
	 * The feature id for the '<em><b>Extends</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__EXTENDS = TRC_CLASS__EXTENDS;

	/**
	 * The feature id for the '<em><b>Implements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__IMPLEMENTS = TRC_CLASS__IMPLEMENTS;

	/**
	 * The feature id for the '<em><b>Locks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__LOCKS = TRC_CLASS__LOCKS;

	/**
	 * The feature id for the '<em><b>Cumulative Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__CUMULATIVE_SIZE = TRC_CLASS__CUMULATIVE_SIZE;

	/**
	 * The feature id for the '<em><b>Array Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__ARRAY_TYPE = TRC_CLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS__ELEMENT_TYPE = TRC_CLASS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Array Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ARRAY_CLASS_FEATURE_COUNT = TRC_CLASS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Heap Dump</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP = TRC_OBJECT_REFERENCE__HEAP_DUMP;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__OWNER = TRC_OBJECT_REFERENCE__OWNER;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__TARGET = TRC_OBJECT_REFERENCE__TARGET;

	/**
	 * The feature id for the '<em><b>Owner Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE = TRC_OBJECT_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE = TRC_OBJECT_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE__COUNT = TRC_OBJECT_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>TRC Aggregated Object Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGGREGATED_OBJECT_REFERENCE_FEATURE_COUNT = TRC_OBJECT_REFERENCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EVENT__TIME = 0;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EVENT__THREAD = 1;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EVENT__ANNOTATIONS = 2;

	/**
	 * The number of structural features of the '<em>TRC Thread Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EVENT_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_SLEEPING_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_SLEEPING_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_SLEEPING_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Sleeping Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Thread Sleeping Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_SLEEPING_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Waiting For</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR = TRC_THREAD_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Thread Waiting For Object Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_OBJECT_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Locked Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Locking Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD = TRC_THREAD_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Thread Waiting For Lock Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_LOCK_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_RUNNING_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_RUNNING_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_RUNNING_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The number of structural features of the '<em>TRC Thread Running Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_RUNNING_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The number of structural features of the '<em>TRC Thread Dead Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__SOURCE_INFO = TRC_METHOD__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__ANNOTATIONS = TRC_METHOD__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__ID = TRC_METHOD__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__NAME = TRC_METHOD__NAME;

	/**
	 * The feature id for the '<em><b>Signature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__SIGNATURE = TRC_METHOD__SIGNATURE;

	/**
	 * The feature id for the '<em><b>Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__MODIFIER = TRC_METHOD__MODIFIER;

	/**
	 * The feature id for the '<em><b>Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__NOTATION = TRC_METHOD__NOTATION;

	/**
	 * The feature id for the '<em><b>Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__LINE_NO = TRC_METHOD__LINE_NO;

	/**
	 * The feature id for the '<em><b>Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__LINE_COUNT = TRC_METHOD__LINE_COUNT;

	/**
	 * The feature id for the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__BASE_TIME = TRC_METHOD__BASE_TIME;

	/**
	 * The feature id for the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__CUMULATIVE_TIME = TRC_METHOD__CUMULATIVE_TIME;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__CALLS = TRC_METHOD__CALLS;

	/**
	 * The feature id for the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__TOTAL_CPU_TIME = TRC_METHOD__TOTAL_CPU_TIME;

	/**
	 * The feature id for the '<em><b>Defining Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS = TRC_METHOD__DEFINING_CLASS;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__INVOCATIONS = TRC_METHOD__INVOCATIONS;

	/**
	 * The feature id for the '<em><b>LL Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA__LL_DATA = TRC_METHOD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Method With LL Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_METHOD_WITH_LL_DATA_FEATURE_COUNT = TRC_METHOD_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Summary Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA__SUMMARY_UNITS = 0;

	/**
	 * The feature id for the '<em><b>Summary Nonzero</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA__SUMMARY_NONZERO = 1;

	/**
	 * The feature id for the '<em><b>Type Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA__TYPE_ID = 2;

	/**
	 * The feature id for the '<em><b>Headings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA__HEADINGS = 3;

	/**
	 * The feature id for the '<em><b>Method</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA__METHOD = 4;

	/**
	 * The number of structural features of the '<em>TRCLL Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRCLL_DATA_FEATURE_COUNT = 5;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO_WITH_LL_DATA__LOCATION = TRC_SOURCE_INFO__LOCATION;

	/**
	 * The feature id for the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO_WITH_LL_DATA__LANGUAGE = TRC_SOURCE_INFO__LANGUAGE;

	/**
	 * The feature id for the '<em><b>LL Datas</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO_WITH_LL_DATA__LL_DATAS = TRC_SOURCE_INFO_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Source Info With LL Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_SOURCE_INFO_WITH_LL_DATA_FEATURE_COUNT = TRC_SOURCE_INFO_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Summary Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS = TRCLL_DATA__SUMMARY_UNITS;

	/**
	 * The feature id for the '<em><b>Summary Nonzero</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO = TRCLL_DATA__SUMMARY_NONZERO;

	/**
	 * The feature id for the '<em><b>Type Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__TYPE_ID = TRCLL_DATA__TYPE_ID;

	/**
	 * The feature id for the '<em><b>Headings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__HEADINGS = TRCLL_DATA__HEADINGS;

	/**
	 * The feature id for the '<em><b>Method</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__METHOD = TRCLL_DATA__METHOD;

	/**
	 * The feature id for the '<em><b>Line Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__LINE_TABLE = TRCLL_DATA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Hit Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__HIT_TABLE = TRCLL_DATA_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Count Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__COUNT_TABLE = TRCLL_DATA_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA__SOURCE_INFO = TRCLL_DATA_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>TRC Line Coverage Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_COVERAGE_DATA_FEATURE_COUNT = TRCLL_DATA_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>String Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_VALUE__STRING_VALUE = 0;

	/**
	 * The feature id for the '<em><b>TRC Input Output Entry</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY = 1;

	/**
	 * The feature id for the '<em><b>Container</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_VALUE__CONTAINER = 2;

	/**
	 * The number of structural features of the '<em>TRC Object Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_VALUE_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_ENTRY__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Container</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_ENTRY__CONTAINER = 1;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_ENTRY__KEY = 2;

	/**
	 * The number of structural features of the '<em>TRC Input Output Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_ENTRY_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_CONTAINER__PROCESS = 0;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_CONTAINER__ENTRIES = 1;

	/**
	 * The feature id for the '<em><b>Input Output Values</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES = 2;

	/**
	 * The number of structural features of the '<em>TRC Input Output Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_INPUT_OUTPUT_CONTAINER_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD = TRC_FULL_METHOD_INVOCATION__METHOD;

	/**
	 * The feature id for the '<em><b>Invoked By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY = TRC_FULL_METHOD_INVOCATION__INVOKED_BY;

	/**
	 * The feature id for the '<em><b>Invokes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES = TRC_FULL_METHOD_INVOCATION__INVOKES;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__THREAD = TRC_FULL_METHOD_INVOCATION__THREAD;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS = TRC_FULL_METHOD_INVOCATION__PROCESS;

	/**
	 * The feature id for the '<em><b>Owning Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__OWNING_OBJECT = TRC_FULL_METHOD_INVOCATION__OWNING_OBJECT;

	/**
	 * The feature id for the '<em><b>Stack Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__STACK_DEPTH = TRC_FULL_METHOD_INVOCATION__STACK_DEPTH;

	/**
	 * The feature id for the '<em><b>Entry Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__ENTRY_TIME = TRC_FULL_METHOD_INVOCATION__ENTRY_TIME;

	/**
	 * The feature id for the '<em><b>Exit Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__EXIT_TIME = TRC_FULL_METHOD_INVOCATION__EXIT_TIME;

	/**
	 * The feature id for the '<em><b>Ticket</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__TICKET = TRC_FULL_METHOD_INVOCATION__TICKET;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__OVERHEAD = TRC_FULL_METHOD_INVOCATION__OVERHEAD;

	/**
	 * The feature id for the '<em><b>Caller Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__CALLER_LINE_NO = TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO;

	/**
	 * The feature id for the '<em><b>Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__CPU_TIME = TRC_FULL_METHOD_INVOCATION__CPU_TIME;

	/**
	 * The feature id for the '<em><b>Call Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME = TRC_FULL_METHOD_INVOCATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Return Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME = TRC_FULL_METHOD_INVOCATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Call Overhead</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD = TRC_FULL_METHOD_INVOCATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>TRC Caller Callee Invocation Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CALLER_CALLEE_INVOCATION_INFO_FEATURE_COUNT = TRC_FULL_METHOD_INVOCATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>String Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__STRING_VALUE = TRC_OBJECT_VALUE__STRING_VALUE;

	/**
	 * The feature id for the '<em><b>TRC Input Output Entry</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY = TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY;

	/**
	 * The feature id for the '<em><b>Container</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__CONTAINER = TRC_OBJECT_VALUE__CONTAINER;

	/**
	 * The feature id for the '<em><b>Value Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__VALUE_KIND = TRC_OBJECT_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Position Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__POSITION_KIND = TRC_OBJECT_VALUE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__POSITION = TRC_OBJECT_VALUE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE__OBJECT = TRC_OBJECT_VALUE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>TRC Typed Object Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_TYPED_OBJECT_VALUE_FEATURE_COUNT = TRC_OBJECT_VALUE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MTHD_LCK_ACC_ENTRY__PROCESS = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MTHD_LCK_ACC_ENTRY__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MTHD_LCK_ACC_ENTRY__KEY = 2;

	/**
	 * The number of structural features of the '<em>TRC Mthd Lck Acc Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MTHD_LCK_ACC_ENTRY_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Require Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS__REQUIRE_TIME = 0;

	/**
	 * The feature id for the '<em><b>Request Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS__REQUEST_TIME = 1;

	/**
	 * The feature id for the '<em><b>Release Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS__RELEASE_TIME = 2;

	/**
	 * The feature id for the '<em><b>At Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS__AT_LINE = 3;

	/**
	 * The feature id for the '<em><b>On Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS__ON_OBJECT = 4;

	/**
	 * The number of structural features of the '<em>TRC Lock Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LOCK_ACCESS_FEATURE_COUNT = 5;

	/**
	 * The feature id for the '<em><b>Summary Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__SUMMARY_UNITS = TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS;

	/**
	 * The feature id for the '<em><b>Summary Nonzero</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__SUMMARY_NONZERO = TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO;

	/**
	 * The feature id for the '<em><b>Type Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__TYPE_ID = TRC_LINE_COVERAGE_DATA__TYPE_ID;

	/**
	 * The feature id for the '<em><b>Headings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__HEADINGS = TRC_LINE_COVERAGE_DATA__HEADINGS;

	/**
	 * The feature id for the '<em><b>Method</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__METHOD = TRC_LINE_COVERAGE_DATA__METHOD;

	/**
	 * The feature id for the '<em><b>Line Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__LINE_TABLE = TRC_LINE_COVERAGE_DATA__LINE_TABLE;

	/**
	 * The feature id for the '<em><b>Hit Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__HIT_TABLE = TRC_LINE_COVERAGE_DATA__HIT_TABLE;

	/**
	 * The feature id for the '<em><b>Count Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__COUNT_TABLE = TRC_LINE_COVERAGE_DATA__COUNT_TABLE;

	/**
	 * The feature id for the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__SOURCE_INFO = TRC_LINE_COVERAGE_DATA__SOURCE_INFO;

	/**
	 * The feature id for the '<em><b>Accumulated Time Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE = TRC_LINE_COVERAGE_DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Line Performance Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_LINE_PERFORMANCE_DATA_FEATURE_COUNT = TRC_LINE_COVERAGE_DATA_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITES_ENTRY__KEY = 1;

	/**
	 * The feature id for the '<em><b>Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITES_ENTRY__PROCESS = 2;

	/**
	 * The number of structural features of the '<em>TRC Object Allocation Sites Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITES_ENTRY_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>At Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITE__AT_LINE = 0;

	/**
	 * The feature id for the '<em><b>TRC Object Allocation Sites Entry</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY = 1;

	/**
	 * The feature id for the '<em><b>Allocated Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT = 2;

	/**
	 * The number of structural features of the '<em>TRC Object Allocation Site</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_SITE_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__TIME = TRC_THREAD_WAITING_FOR_LOCK_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__THREAD = TRC_THREAD_WAITING_FOR_LOCK_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__ANNOTATIONS = TRC_THREAD_WAITING_FOR_LOCK_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Locked Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__LOCKED_OBJECT = TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT;

	/**
	 * The feature id for the '<em><b>Locking Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__LOCKING_THREAD = TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD;

	/**
	 * The feature id for the '<em><b>Next Dead Lock Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT = TRC_THREAD_WAITING_FOR_LOCK_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Thread Dead Lock Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_LOCK_EVENT_FEATURE_COUNT = TRC_THREAD_WAITING_FOR_LOCK_EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl <em>TRC Object Allocation Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationAnnotation()
	 * @generated
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION = 44;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__NAME = HierarchyPackage.TRC_ANNOTATION__NAME;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__VALUES = HierarchyPackage.TRC_ANNOTATION__VALUES;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS = HierarchyPackage.TRC_ANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES = HierarchyPackage.TRC_ANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Line Numbers</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS = HierarchyPackage.TRC_ANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Create Times</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES = HierarchyPackage.TRC_ANNOTATION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>TRC Object Allocation Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OBJECT_ALLOCATION_ANNOTATION_FEATURE_COUNT = HierarchyPackage.TRC_ANNOTATION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitTimeoutExceedEventImpl <em>TRC Thread Wait Timeout Exceed Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitTimeoutExceedEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitTimeoutExceedEvent()
	 * @generated
	 */
	int TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT = 45;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The number of structural features of the '<em>TRC Thread Wait Timeout Exceed Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForJoinEventImpl <em>TRC Thread Waiting For Join Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForJoinEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForJoinEvent()
	 * @generated
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT = 46;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT__TIME = TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT__THREAD = TRC_THREAD_WAITING_FOR_OBJECT_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT__ANNOTATIONS = TRC_THREAD_WAITING_FOR_OBJECT_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT__TIMEOUT = TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT;

	/**
	 * The feature id for the '<em><b>Object Waiting For</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT__OBJECT_WAITING_FOR = TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR;

	/**
	 * The number of structural features of the '<em>TRC Thread Waiting For Join Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_WAITING_FOR_JOIN_EVENT_FEATURE_COUNT = TRC_THREAD_WAITING_FOR_OBJECT_EVENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl <em>TRC Thread Exec Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadExecEvent()
	 * @generated
	 */
	int TRC_THREAD_EXEC_EVENT = 47;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT__TIME = TRC_THREAD_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT__THREAD = TRC_THREAD_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT__ANNOTATIONS = TRC_THREAD_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS = TRC_THREAD_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TRC Thread Exec Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_EXEC_EVENT_FEATURE_COUNT = TRC_THREAD_EVENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadNotifyAllEventImpl <em>TRC Thread Notify All Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadNotifyAllEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadNotifyAllEvent()
	 * @generated
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT = 48;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The number of structural features of the '<em>TRC Thread Notify All Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_ALL_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadNotifyEventImpl <em>TRC Thread Notify Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadNotifyEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadNotifyEvent()
	 * @generated
	 */
	int TRC_THREAD_NOTIFY_EVENT = 49;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The number of structural features of the '<em>TRC Thread Notify Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_NOTIFY_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadAndNotifyJoinedEventImpl <em>TRC Thread Dead And Notify Joined Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadAndNotifyJoinedEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadAndNotifyJoinedEvent()
	 * @generated
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT = 50;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The number of structural features of the '<em>TRC Thread Dead And Notify Joined Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl <em>TRC Thread Start Thread Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadStartThreadEvent()
	 * @generated
	 */
	int TRC_THREAD_START_THREAD_EVENT = 51;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The feature id for the '<em><b>Started Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Thread Start Thread Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_START_THREAD_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl <em>TRC Thread Interrupt Thread Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadInterruptThreadEvent()
	 * @generated
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT = 52;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The feature id for the '<em><b>Interrupted Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Thread Interrupt Thread Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_INTERRUPT_THREAD_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl <em>TRC Thread Handoff Lock Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadHandoffLockEvent()
	 * @generated
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT = 53;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__TIME = TRC_THREAD_EXEC_EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Thread</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__THREAD = TRC_THREAD_EXEC_EVENT__THREAD;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__ANNOTATIONS = TRC_THREAD_EXEC_EVENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Running Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__RUNNING_EVENTS = TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS;

	/**
	 * The feature id for the '<em><b>In Critical Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__IN_CRITICAL_PATH = TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH;

	/**
	 * The feature id for the '<em><b>Locked Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TRC Thread Handoff Lock Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_THREAD_HANDOFF_LOCK_EVENT_FEATURE_COUNT = TRC_THREAD_EXEC_EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCPrimitiveType <em>TRC Primitive Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCPrimitiveType
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCPrimitiveType()
	 * @generated
	 */
	int TRC_PRIMITIVE_TYPE = 54;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCSignatureNotation <em>TRC Signature Notation</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCSignatureNotation
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSignatureNotation()
	 * @generated
	 */
	int TRC_SIGNATURE_NOTATION = 55;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCMethodProperties <em>TRC Method Properties</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCMethodProperties
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodProperties()
	 * @generated
	 */
	int TRC_METHOD_PROPERTIES = 56;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCGCRootType <em>TRCGC Root Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCGCRootType
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCGCRootType()
	 * @generated
	 */
	int TRCGC_ROOT_TYPE = 57;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCObjectValueKind <em>TRC Object Value Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCObjectValueKind
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValueKind()
	 * @generated
	 */
	int TRC_OBJECT_VALUE_KIND = 58;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.trace.TRCObjectValuePosition <em>TRC Object Value Position</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.TRCObjectValuePosition
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValuePosition()
	 * @generated
	 */
	int TRC_OBJECT_VALUE_POSITION = 59;

	/**
	 * The meta object id for the '<em>EObject ID</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEObjectID()
	 * @generated
	 */
	int EOBJECT_ID = 60;

	/**
	 * The meta object id for the '<em>EMethod ID</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEMethodID()
	 * @generated
	 */
	int EMETHOD_ID = 61;

	/**
	 * The meta object id for the '<em>EClass ID</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEClassID()
	 * @generated
	 */
	int ECLASS_ID = 62;


	/**
	 * The meta object id for the '<em>LL Unit Data</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.trace.util.LLUnitData
	 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getLLUnitData()
	 * @generated
	 */
	int LL_UNIT_DATA = 63;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCObject <em>TRC Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject
	 * @generated
	 */
	EClass getTRCObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCObject#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject#getId()
	 * @see #getTRCObject()
	 * @generated
	 */
	EAttribute getTRCObject_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCObject#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject#getSize()
	 * @see #getTRCObject()
	 * @generated
	 */
	EAttribute getTRCObject_Size();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCObject#getIsA <em>Is A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Is A</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject#getIsA()
	 * @see #getTRCObject()
	 * @generated
	 */
	EReference getTRCObject_IsA();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCObject#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject#getProcess()
	 * @see #getTRCObject()
	 * @generated
	 */
	EReference getTRCObject_Process();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCObject#getCumulativeSize <em>Cumulative Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObject#getCumulativeSize()
	 * @see #getTRCObject()
	 * @generated
	 */
	EAttribute getTRCObject_CumulativeSize();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCClass <em>TRC Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Class</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass
	 * @generated
	 */
	EClass getTRCClass();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getId()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getName()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getSize()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_Size();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getLoadTime <em>Load Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Load Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getLoadTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_LoadTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getUnloadTime <em>Unload Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unload Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getUnloadTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_UnloadTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#isInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Interface</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#isInterface()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_Interface();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getLineNo <em>Line No</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line No</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getLineNo()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_LineNo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getLineCount <em>Line Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Count</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getLineCount()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_LineCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getBaseTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getCumulativeTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getCalls <em>Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getCalls()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_Calls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCalls <em>Inherited Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedCalls()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_InheritedCalls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedBaseTime <em>Inherited Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedBaseTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_InheritedBaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getInheritedCumulativeTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_InheritedCumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalSize <em>Total Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalSize()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_TotalSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalInstances <em>Total Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalInstances()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_TotalInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedSize <em>Collected Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getCollectedSize()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_CollectedSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getCollectedInstances <em>Collected Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getCollectedInstances()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_CollectedInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getTotalCpuTime()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_TotalCpuTime();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getObjects <em>Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Objects</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getObjects()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Objects();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCClass#getLoadedBy <em>Loaded By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Loaded By</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getLoadedBy()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_LoadedBy();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getMethods <em>Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Methods</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getMethods()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Methods();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getClassObjects <em>Class Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Class Objects</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getClassObjects()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_ClassObjects();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCClass#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Package</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getPackage()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Package();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCClass#getClassLoader <em>Class Loader</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Loader</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getClassLoader()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_ClassLoader();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCClass#getEnclosedBy <em>Enclosed By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enclosed By</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getEnclosedBy()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_EnclosedBy();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getExtends <em>Extends</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Extends</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getExtends()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Extends();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getImplements <em>Implements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Implements</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getImplements()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Implements();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCClass#getLocks <em>Locks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Locks</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getLocks()
	 * @see #getTRCClass()
	 * @generated
	 */
	EReference getTRCClass_Locks();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCClass#getCumulativeSize <em>Cumulative Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClass#getCumulativeSize()
	 * @see #getTRCClass()
	 * @generated
	 */
	EAttribute getTRCClass_CumulativeSize();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation <em>TRC Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Method Invocation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation
	 * @generated
	 */
	EClass getTRCMethodInvocation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getOwningObject <em>Owning Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owning Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getOwningObject()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_OwningObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getMethod <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Method</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getMethod()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_Method();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy <em>Invoked By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Invoked By</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_InvokedBy();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokes <em>Invokes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Invokes</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokes()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_Invokes();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getThread <em>Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getThread()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_Thread();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess()
	 * @see #getTRCMethodInvocation()
	 * @generated
	 */
	EReference getTRCMethodInvocation_Process();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCProcess <em>TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess
	 * @generated
	 */
	EClass getTRCProcess();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getPid <em>Pid</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pid</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getPid()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Pid();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getName()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getId()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getStartTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getStopTime <em>Stop Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getStopTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_StopTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getLastEventTime <em>Last Event Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Last Event Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getLastEventTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_LastEventTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getInitFinishedTime <em>Init Finished Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Init Finished Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInitFinishedTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_InitFinishedTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getBaseTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCumulativeTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getCalls <em>Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCalls()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Calls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCalls <em>Inherited Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInheritedCalls()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_InheritedCalls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedBaseTime <em>Inherited Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInheritedBaseTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_InheritedBaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInheritedCumulativeTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_InheritedCumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalSize <em>Total Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getTotalSize()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_TotalSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalInstances <em>Total Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getTotalInstances()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_TotalInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedSize <em>Collected Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCollectedSize()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_CollectedSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedInstances <em>Collected Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCollectedInstances()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_CollectedInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getReferencePointerSize <em>Reference Pointer Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference Pointer Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getReferencePointerSize()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_ReferencePointerSize();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.trace.TRCProcess#getThreadStates <em>Thread States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Thread States</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getThreadStates()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_ThreadStates();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getPrecision <em>Precision</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Precision</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getPrecision()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Precision();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.trace.TRCProcess#getLanguages <em>Languages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Languages</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getLanguages()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_Languages();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getTotalCpuTime()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_TotalCpuTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCProcess#getCpuSampleResolution <em>Cpu Sample Resolution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cpu Sample Resolution</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCpuSampleResolution()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EAttribute getTRCProcess_CpuSampleResolution();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getThreads <em>Threads</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Threads</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getThreads()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_Threads();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Packages</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getPackages()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_Packages();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCProcess#getClassClass <em>Class Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Class</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getClassClass()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_ClassClass();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectionBoundaryPoints <em>Collection Boundary Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Collection Boundary Points</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCollectionBoundaryPoints()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_CollectionBoundaryPoints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getClassLoaders <em>Class Loaders</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Class Loaders</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getClassLoaders()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_ClassLoaders();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getSourceInfos <em>Source Infos</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Source Infos</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getSourceInfos()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_SourceInfos();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getObjects <em>Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Objects</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getObjects()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_Objects();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getHeapDumps <em>Heap Dumps</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Heap Dumps</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getHeapDumps()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_HeapDumps();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Invocations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInvocations()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_Invocations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer <em>Input Output Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Input Output Container</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_InputOutputContainer();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.models.trace.TRCProcess#getMethodLockAccessEntries <em>Method Lock Access Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Method Lock Access Entries</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getMethodLockAccessEntries()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_MethodLockAccessEntries();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.models.trace.TRCProcess#getAllocationSitesEntries <em>Allocation Sites Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Allocation Sites Entries</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getAllocationSitesEntries()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_AllocationSitesEntries();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getAnnotations()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_Annotations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCProcess#getGcEvents <em>Gc Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Gc Events</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getGcEvents()
	 * @see #getTRCProcess()
	 * @generated
	 */
	EReference getTRCProcess_GcEvents();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThread <em>TRC Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread
	 * @generated
	 */
	EClass getTRCThread();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getId()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getName()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getGroupName <em>Group Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Group Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getGroupName()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_GroupName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getStartTime()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getStopTime <em>Stop Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getStopTime()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_StopTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getMaxStackDepth <em>Max Stack Depth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Stack Depth</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getMaxStackDepth()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_MaxStackDepth();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThread#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getTotalCpuTime()
	 * @see #getTRCThread()
	 * @generated
	 */
	EAttribute getTRCThread_TotalCpuTime();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCThread#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getProcess()
	 * @see #getTRCThread()
	 * @generated
	 */
	EReference getTRCThread_Process();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThread#getThreadObject <em>Thread Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Thread Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getThreadObject()
	 * @see #getTRCThread()
	 * @generated
	 */
	EReference getTRCThread_ThreadObject();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCThread#getThreadEvents <em>Thread Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Thread Events</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getThreadEvents()
	 * @see #getTRCThread()
	 * @generated
	 */
	EReference getTRCThread_ThreadEvents();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCThread#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getAnnotations()
	 * @see #getTRCThread()
	 * @generated
	 */
	EReference getTRCThread_Annotations();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCThread#getInitialInvocations <em>Initial Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Initial Invocations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThread#getInitialInvocations()
	 * @see #getTRCThread()
	 * @generated
	 */
	EReference getTRCThread_InitialInvocations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCMethod <em>TRC Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Method</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod
	 * @generated
	 */
	EClass getTRCMethod();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getId()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getName()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getSignature <em>Signature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signature</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getSignature()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Signature();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getModifier <em>Modifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Modifier</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getModifier()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Modifier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getNotation <em>Notation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getNotation()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Notation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getLineNo <em>Line No</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line No</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getLineNo()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_LineNo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getLineCount <em>Line Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Count</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getLineCount()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_LineCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getBaseTime()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getCumulativeTime()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getCalls <em>Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getCalls()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_Calls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCMethod#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getTotalCpuTime()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EAttribute getTRCMethod_TotalCpuTime();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCMethod#getDefiningClass <em>Defining Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Defining Class</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getDefiningClass()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EReference getTRCMethod_DefiningClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCMethod#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Invocations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getInvocations()
	 * @see #getTRCMethod()
	 * @generated
	 */
	EReference getTRCMethod_Invocations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCPackage <em>TRC Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Package</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage
	 * @generated
	 */
	EClass getTRCPackage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getName()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getBaseTime()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getCumulativeTime()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getCalls <em>Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getCalls()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_Calls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCalls <em>Inherited Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getInheritedCalls()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_InheritedCalls();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedBaseTime <em>Inherited Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getInheritedBaseTime()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_InheritedBaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inherited Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getInheritedCumulativeTime()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_InheritedCumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalSize <em>Total Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getTotalSize()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_TotalSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalInstances <em>Total Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getTotalInstances()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_TotalInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedSize <em>Collected Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getCollectedSize()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_CollectedSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedInstances <em>Collected Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collected Instances</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getCollectedInstances()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_CollectedInstances();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getTotalCpuTime()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EAttribute getTRCPackage_TotalCpuTime();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCPackage#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getProcess()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EReference getTRCPackage_Process();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCPackage#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Classes</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getClasses()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EReference getTRCPackage_Classes();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCPackage#getSubPackages <em>Sub Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sub Packages</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getSubPackages()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EReference getTRCPackage_SubPackages();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCPackage#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getParent()
	 * @see #getTRCPackage()
	 * @generated
	 */
	EReference getTRCPackage_Parent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary <em>TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Collection Boundary</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary
	 * @generated
	 */
	EClass getTRCCollectionBoundary();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastInvocation <em>Last Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Invocation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastInvocation()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastInvocation();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_Process();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastClass <em>Last Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Class</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastClass()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastThread <em>Last Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastThread()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastThread();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastObject <em>Last Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastObject()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastPackage <em>Last Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Package</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastPackage()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastPackage();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastMethod <em>Last Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Method</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastMethod()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_LastMethod();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getHeapDump <em>Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Heap Dump</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getHeapDump()
	 * @see #getTRCCollectionBoundary()
	 * @generated
	 */
	EReference getTRCCollectionBoundary_HeapDump();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCClassLoader <em>TRC Class Loader</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Class Loader</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader
	 * @generated
	 */
	EClass getTRCClassLoader();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCClassLoader#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader#getProcess()
	 * @see #getTRCClassLoader()
	 * @generated
	 */
	EReference getTRCClassLoader_Process();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCClassLoader#getClassLoaderInstance <em>Class Loader Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Loader Instance</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader#getClassLoaderInstance()
	 * @see #getTRCClassLoader()
	 * @generated
	 */
	EReference getTRCClassLoader_ClassLoaderInstance();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCSourceInfo <em>TRC Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Source Info</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfo
	 * @generated
	 */
	EClass getTRCSourceInfo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCSourceInfo#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfo#getLocation()
	 * @see #getTRCSourceInfo()
	 * @generated
	 */
	EAttribute getTRCSourceInfo_Location();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCSourceInfo#getLanguage <em>Language</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Language</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfo#getLanguage()
	 * @see #getTRCSourceInfo()
	 * @generated
	 */
	EAttribute getTRCSourceInfo_Language();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCHeapObject <em>TRC Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Heap Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapObject
	 * @generated
	 */
	EClass getTRCHeapObject();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCHeapObject#getRefOwner <em>Ref Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Ref Owner</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapObject#getRefOwner()
	 * @see #getTRCHeapObject()
	 * @generated
	 */
	EReference getTRCHeapObject_RefOwner();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCHeapObject#getRefTarget <em>Ref Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Ref Target</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapObject#getRefTarget()
	 * @see #getTRCHeapObject()
	 * @generated
	 */
	EReference getTRCHeapObject_RefTarget();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject <em>TRC Full Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Full Trace Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject
	 * @generated
	 */
	EClass getTRCFullTraceObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject#getCreateTime <em>Create Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Create Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject#getCreateTime()
	 * @see #getTRCFullTraceObject()
	 * @generated
	 */
	EAttribute getTRCFullTraceObject_CreateTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject#getCollectTime <em>Collect Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collect Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject#getCollectTime()
	 * @see #getTRCFullTraceObject()
	 * @generated
	 */
	EAttribute getTRCFullTraceObject_CollectTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject#getBaseTime()
	 * @see #getTRCFullTraceObject()
	 * @generated
	 */
	EAttribute getTRCFullTraceObject_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject#getCumulativeTime()
	 * @see #getTRCFullTraceObject()
	 * @generated
	 */
	EAttribute getTRCFullTraceObject_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject#getCalls <em>Calls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Calls</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject#getCalls()
	 * @see #getTRCFullTraceObject()
	 * @generated
	 */
	EAttribute getTRCFullTraceObject_Calls();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCTraceObject <em>TRC Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Trace Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTraceObject
	 * @generated
	 */
	EClass getTRCTraceObject();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCTraceObject#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Invocations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTraceObject#getInvocations()
	 * @see #getTRCTraceObject()
	 * @generated
	 */
	EReference getTRCTraceObject_Invocations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCTraceObject#getThread <em>Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTraceObject#getThread()
	 * @see #getTRCTraceObject()
	 * @generated
	 */
	EReference getTRCTraceObject_Thread();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCFullHeapObject <em>TRC Full Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Full Heap Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullHeapObject
	 * @generated
	 */
	EClass getTRCFullHeapObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullHeapObject#getHeapDumpFirstSeen <em>Heap Dump First Seen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Heap Dump First Seen</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullHeapObject#getHeapDumpFirstSeen()
	 * @see #getTRCFullHeapObject()
	 * @generated
	 */
	EAttribute getTRCFullHeapObject_HeapDumpFirstSeen();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCObjectReference <em>TRC Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object Reference</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference
	 * @generated
	 */
	EClass getTRCObjectReference();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCObjectReference#getHeapDump <em>Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Heap Dump</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference#getHeapDump()
	 * @see #getTRCObjectReference()
	 * @generated
	 */
	EReference getTRCObjectReference_HeapDump();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCObjectReference#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owner</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference#getOwner()
	 * @see #getTRCObjectReference()
	 * @generated
	 */
	EReference getTRCObjectReference_Owner();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCObjectReference#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference#getTarget()
	 * @see #getTRCObjectReference()
	 * @generated
	 */
	EReference getTRCObjectReference_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCHeapDump <em>TRC Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Heap Dump</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump
	 * @generated
	 */
	EClass getTRCHeapDump();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getId()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EAttribute getTRCHeapDump_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getEntryTime <em>Entry Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entry Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getEntryTime()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EAttribute getTRCHeapDump_EntryTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getExitTime <em>Exit Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exit Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getExitTime()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EAttribute getTRCHeapDump_ExitTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getName()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EAttribute getTRCHeapDump_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getReferences <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>References</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getReferences()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EReference getTRCHeapDump_References();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getProcess()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EReference getTRCHeapDump_Process();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getGcRoots <em>Gc Roots</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Gc Roots</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getGcRoots()
	 * @see #getTRCHeapDump()
	 * @generated
	 */
	EReference getTRCHeapDump_GcRoots();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation <em>TRC Aggregated Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Aggregated Method Invocation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation
	 * @generated
	 */
	EClass getTRCAggregatedMethodInvocation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCount()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_Count();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getBaseTime <em>Base Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Base Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getBaseTime()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_BaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCumulativeTime <em>Cumulative Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cumulative Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCumulativeTime()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_CumulativeTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getMinTime <em>Min Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getMinTime()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_MinTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getMaxTime <em>Max Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getMaxTime()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_MaxTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCallerLineNo <em>Caller Line No</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Caller Line No</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getCallerLineNo()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_CallerLineNo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getTotalCpuTime <em>Total Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation#getTotalCpuTime()
	 * @see #getTRCAggregatedMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCAggregatedMethodInvocation_TotalCpuTime();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation <em>TRC Full Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Full Method Invocation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation
	 * @generated
	 */
	EClass getTRCFullMethodInvocation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getStackDepth <em>Stack Depth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stack Depth</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getStackDepth()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_StackDepth();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getEntryTime <em>Entry Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entry Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getEntryTime()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_EntryTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getExitTime <em>Exit Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exit Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getExitTime()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_ExitTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getTicket <em>Ticket</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ticket</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getTicket()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_Ticket();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getOverhead <em>Overhead</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Overhead</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getOverhead()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_Overhead();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCallerLineNo <em>Caller Line No</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Caller Line No</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCallerLineNo()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_CallerLineNo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCpuTime <em>Cpu Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cpu Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCpuTime()
	 * @see #getTRCFullMethodInvocation()
	 * @generated
	 */
	EAttribute getTRCFullMethodInvocation_CpuTime();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCHeapRoot <em>TRC Heap Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Heap Root</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot
	 * @generated
	 */
	EClass getTRCHeapRoot();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapRoot#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot#getType()
	 * @see #getTRCHeapRoot()
	 * @generated
	 */
	EAttribute getTRCHeapRoot_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCHeapRoot#getFrame <em>Frame</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Frame</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot#getFrame()
	 * @see #getTRCHeapRoot()
	 * @generated
	 */
	EAttribute getTRCHeapRoot_Frame();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCHeapRoot#getHeapDump <em>Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Heap Dump</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot#getHeapDump()
	 * @see #getTRCHeapRoot()
	 * @generated
	 */
	EReference getTRCHeapRoot_HeapDump();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCHeapRoot#getThread <em>Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot#getThread()
	 * @see #getTRCHeapRoot()
	 * @generated
	 */
	EReference getTRCHeapRoot_Thread();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCHeapRoot#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot#getObject()
	 * @see #getTRCHeapRoot()
	 * @generated
	 */
	EReference getTRCHeapRoot_Object();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCArrayClass <em>TRC Array Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Array Class</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCArrayClass
	 * @generated
	 */
	EClass getTRCArrayClass();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCArrayClass#getArrayType <em>Array Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Array Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCArrayClass#getArrayType()
	 * @see #getTRCArrayClass()
	 * @generated
	 */
	EAttribute getTRCArrayClass_ArrayType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCArrayClass#getElementType <em>Element Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Element Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCArrayClass#getElementType()
	 * @see #getTRCArrayClass()
	 * @generated
	 */
	EReference getTRCArrayClass_ElementType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference <em>TRC Aggregated Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Aggregated Object Reference</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference
	 * @generated
	 */
	EClass getTRCAggregatedObjectReference();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getOwnerSize <em>Owner Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Owner Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getOwnerSize()
	 * @see #getTRCAggregatedObjectReference()
	 * @generated
	 */
	EAttribute getTRCAggregatedObjectReference_OwnerSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getTargetSize <em>Target Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Target Size</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getTargetSize()
	 * @see #getTRCAggregatedObjectReference()
	 * @generated
	 */
	EAttribute getTRCAggregatedObjectReference_TargetSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference#getCount()
	 * @see #getTRCAggregatedObjectReference()
	 * @generated
	 */
	EAttribute getTRCAggregatedObjectReference_Count();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadEvent <em>TRC Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent
	 * @generated
	 */
	EClass getTRCThreadEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThreadEvent#getTime <em>Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent#getTime()
	 * @see #getTRCThreadEvent()
	 * @generated
	 */
	EAttribute getTRCThreadEvent_Time();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCThreadEvent#getThread <em>Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent#getThread()
	 * @see #getTRCThreadEvent()
	 * @generated
	 */
	EReference getTRCThreadEvent_Thread();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCThreadEvent#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent#getAnnotations()
	 * @see #getTRCThreadEvent()
	 * @generated
	 */
	EReference getTRCThreadEvent_Annotations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadSleepingEvent <em>TRC Thread Sleeping Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Sleeping Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadSleepingEvent
	 * @generated
	 */
	EClass getTRCThreadSleepingEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThreadSleepingEvent#getSleepingTime <em>Sleeping Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sleeping Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadSleepingEvent#getSleepingTime()
	 * @see #getTRCThreadSleepingEvent()
	 * @generated
	 */
	EAttribute getTRCThreadSleepingEvent_SleepingTime();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent <em>TRC Thread Waiting For Object Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Waiting For Object Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent
	 * @generated
	 */
	EClass getTRCThreadWaitingForObjectEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent#getTimeout <em>Timeout</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timeout</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent#getTimeout()
	 * @see #getTRCThreadWaitingForObjectEvent()
	 * @generated
	 */
	EAttribute getTRCThreadWaitingForObjectEvent_Timeout();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent#getObjectWaitingFor <em>Object Waiting For</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Object Waiting For</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent#getObjectWaitingFor()
	 * @see #getTRCThreadWaitingForObjectEvent()
	 * @generated
	 */
	EReference getTRCThreadWaitingForObjectEvent_ObjectWaitingFor();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent <em>TRC Thread Waiting For Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Waiting For Lock Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent
	 * @generated
	 */
	EClass getTRCThreadWaitingForLockEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent#getLockedObject <em>Locked Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Locked Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent#getLockedObject()
	 * @see #getTRCThreadWaitingForLockEvent()
	 * @generated
	 */
	EReference getTRCThreadWaitingForLockEvent_LockedObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent#getLockingThread <em>Locking Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Locking Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent#getLockingThread()
	 * @see #getTRCThreadWaitingForLockEvent()
	 * @generated
	 */
	EReference getTRCThreadWaitingForLockEvent_LockingThread();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadRunningEvent <em>TRC Thread Running Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Running Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadRunningEvent
	 * @generated
	 */
	EClass getTRCThreadRunningEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadEvent <em>TRC Thread Dead Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Dead Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadEvent
	 * @generated
	 */
	EClass getTRCThreadDeadEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCMethodWithLLData <em>TRC Method With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Method With LL Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodWithLLData
	 * @generated
	 */
	EClass getTRCMethodWithLLData();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.trace.TRCMethodWithLLData#getLLData <em>LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>LL Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodWithLLData#getLLData()
	 * @see #getTRCMethodWithLLData()
	 * @generated
	 */
	EReference getTRCMethodWithLLData_LLData();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCLLData <em>TRCLL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRCLL Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData
	 * @generated
	 */
	EClass getTRCLLData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryUnits <em>Summary Units</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Summary Units</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData#getSummaryUnits()
	 * @see #getTRCLLData()
	 * @generated
	 */
	EAttribute getTRCLLData_SummaryUnits();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryNonzero <em>Summary Nonzero</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Summary Nonzero</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData#getSummaryNonzero()
	 * @see #getTRCLLData()
	 * @generated
	 */
	EAttribute getTRCLLData_SummaryNonzero();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLLData#getTypeId <em>Type Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type Id</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData#getTypeId()
	 * @see #getTRCLLData()
	 * @generated
	 */
	EAttribute getTRCLLData_TypeId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLLData#getHeadings <em>Headings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Headings</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData#getHeadings()
	 * @see #getTRCLLData()
	 * @generated
	 */
	EAttribute getTRCLLData_Headings();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCLLData#getMethod <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Method</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLLData#getMethod()
	 * @see #getTRCLLData()
	 * @generated
	 */
	EReference getTRCLLData_Method();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData <em>TRC Source Info With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Source Info With LL Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData
	 * @generated
	 */
	EClass getTRCSourceInfoWithLLData();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData#getLLDatas <em>LL Datas</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>LL Datas</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData#getLLDatas()
	 * @see #getTRCSourceInfoWithLLData()
	 * @generated
	 */
	EReference getTRCSourceInfoWithLLData_LLDatas();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData <em>TRC Line Coverage Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Line Coverage Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData
	 * @generated
	 */
	EClass getTRCLineCoverageData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getLineTable <em>Line Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Table</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData#getLineTable()
	 * @see #getTRCLineCoverageData()
	 * @generated
	 */
	EAttribute getTRCLineCoverageData_LineTable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getHitTable <em>Hit Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hit Table</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData#getHitTable()
	 * @see #getTRCLineCoverageData()
	 * @generated
	 */
	EAttribute getTRCLineCoverageData_HitTable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getCountTable <em>Count Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count Table</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData#getCountTable()
	 * @see #getTRCLineCoverageData()
	 * @generated
	 */
	EAttribute getTRCLineCoverageData_CountTable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getSourceInfo <em>Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source Info</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData#getSourceInfo()
	 * @see #getTRCLineCoverageData()
	 * @generated
	 */
	EReference getTRCLineCoverageData_SourceInfo();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCObjectValue <em>TRC Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object Value</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue
	 * @generated
	 */
	EClass getTRCObjectValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getStringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>String Value</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue#getStringValue()
	 * @see #getTRCObjectValue()
	 * @generated
	 */
	EAttribute getTRCObjectValue_StringValue();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getTRCInputOutputEntry <em>TRC Input Output Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>TRC Input Output Entry</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue#getTRCInputOutputEntry()
	 * @see #getTRCObjectValue()
	 * @generated
	 */
	EReference getTRCObjectValue_TRCInputOutputEntry();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCObjectValue#getContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Container</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue#getContainer()
	 * @see #getTRCObjectValue()
	 * @generated
	 */
	EReference getTRCObjectValue_Container();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>TRC Input Output Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Input Output Entry</em>'.
	 * @see java.util.Map.Entry
	 * @model features="value container key" 
	 *        valueType="org.eclipse.hyades.models.trace.TRCObjectValue" valueOpposite="TRCInputOutputEntry" valueContainment="true" valueMany="true"
	 *        containerType="org.eclipse.hyades.models.trace.TRCInputOutputContainer" containerOpposite="entries" containerRequired="true"
	 *        keyType="org.eclipse.hyades.models.trace.TRCMethodInvocation"
	 * @generated
	 */
	EClass getTRCInputOutputEntry();

	/**
	 * Returns the meta object for the containment reference list '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCInputOutputEntry()
	 * @generated
	 */
	EReference getTRCInputOutputEntry_Value();

	/**
	 * Returns the meta object for the container reference '{@link java.util.Map.Entry <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Container</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCInputOutputEntry()
	 * @generated
	 */
	EReference getTRCInputOutputEntry_Container();

	/**
	 * Returns the meta object for the reference '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCInputOutputEntry()
	 * @generated
	 */
	EReference getTRCInputOutputEntry_Key();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer <em>TRC Input Output Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Input Output Container</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer
	 * @generated
	 */
	EClass getTRCInputOutputContainer();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess()
	 * @see #getTRCInputOutputContainer()
	 * @generated
	 */
	EReference getTRCInputOutputContainer_Process();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getEntries <em>Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Entries</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer#getEntries()
	 * @see #getTRCInputOutputContainer()
	 * @generated
	 */
	EReference getTRCInputOutputContainer_Entries();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getInputOutputValues <em>Input Output Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Input Output Values</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer#getInputOutputValues()
	 * @see #getTRCInputOutputContainer()
	 * @generated
	 */
	EReference getTRCInputOutputContainer_InputOutputValues();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo <em>TRC Caller Callee Invocation Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Caller Callee Invocation Info</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo
	 * @generated
	 */
	EClass getTRCCallerCalleeInvocationInfo();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallTime <em>Call Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Call Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallTime()
	 * @see #getTRCCallerCalleeInvocationInfo()
	 * @generated
	 */
	EAttribute getTRCCallerCalleeInvocationInfo_CallTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getReturnTime <em>Return Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Return Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getReturnTime()
	 * @see #getTRCCallerCalleeInvocationInfo()
	 * @generated
	 */
	EAttribute getTRCCallerCalleeInvocationInfo_ReturnTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallOverhead <em>Call Overhead</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Call Overhead</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallOverhead()
	 * @see #getTRCCallerCalleeInvocationInfo()
	 * @generated
	 */
	EAttribute getTRCCallerCalleeInvocationInfo_CallOverhead();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue <em>TRC Typed Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Typed Object Value</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue
	 * @generated
	 */
	EClass getTRCTypedObjectValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue#getValueKind <em>Value Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value Kind</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue#getValueKind()
	 * @see #getTRCTypedObjectValue()
	 * @generated
	 */
	EAttribute getTRCTypedObjectValue_ValueKind();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue#getPositionKind <em>Position Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Position Kind</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue#getPositionKind()
	 * @see #getTRCTypedObjectValue()
	 * @generated
	 */
	EAttribute getTRCTypedObjectValue_PositionKind();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Position</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue#getPosition()
	 * @see #getTRCTypedObjectValue()
	 * @generated
	 */
	EAttribute getTRCTypedObjectValue_Position();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue#getObject()
	 * @see #getTRCTypedObjectValue()
	 * @generated
	 */
	EReference getTRCTypedObjectValue_Object();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>TRC Mthd Lck Acc Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Mthd Lck Acc Entry</em>'.
	 * @see java.util.Map.Entry
	 * @model features="process value key" 
	 *        processType="org.eclipse.hyades.models.trace.TRCProcess" processOpposite="methodLockAccessEntries" processRequired="true"
	 *        valueType="org.eclipse.hyades.models.trace.TRCLockAccess" valueContainment="true" valueRequired="true" valueMany="true"
	 *        keyType="org.eclipse.hyades.models.trace.TRCMethodInvocation" keyRequired="true"
	 * @generated
	 */
	EClass getTRCMthdLckAccEntry();

	/**
	 * Returns the meta object for the container reference '{@link java.util.Map.Entry <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCMthdLckAccEntry()
	 * @generated
	 */
	EReference getTRCMthdLckAccEntry_Process();

	/**
	 * Returns the meta object for the containment reference list '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCMthdLckAccEntry()
	 * @generated
	 */
	EReference getTRCMthdLckAccEntry_Value();

	/**
	 * Returns the meta object for the reference '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCMthdLckAccEntry()
	 * @generated
	 */
	EReference getTRCMthdLckAccEntry_Key();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCLockAccess <em>TRC Lock Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Lock Access</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess
	 * @generated
	 */
	EClass getTRCLockAccess();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLockAccess#getRequireTime <em>Require Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Require Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess#getRequireTime()
	 * @see #getTRCLockAccess()
	 * @generated
	 */
	EAttribute getTRCLockAccess_RequireTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLockAccess#getRequestTime <em>Request Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Request Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess#getRequestTime()
	 * @see #getTRCLockAccess()
	 * @generated
	 */
	EAttribute getTRCLockAccess_RequestTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLockAccess#getReleaseTime <em>Release Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Release Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess#getReleaseTime()
	 * @see #getTRCLockAccess()
	 * @generated
	 */
	EAttribute getTRCLockAccess_ReleaseTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLockAccess#getAtLine <em>At Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>At Line</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess#getAtLine()
	 * @see #getTRCLockAccess()
	 * @generated
	 */
	EAttribute getTRCLockAccess_AtLine();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCLockAccess#getOnObject <em>On Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>On Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess#getOnObject()
	 * @see #getTRCLockAccess()
	 * @generated
	 */
	EReference getTRCLockAccess_OnObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCLinePerformanceData <em>TRC Line Performance Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Line Performance Data</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLinePerformanceData
	 * @generated
	 */
	EClass getTRCLinePerformanceData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCLinePerformanceData#getAccumulatedTimeTable <em>Accumulated Time Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Accumulated Time Table</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLinePerformanceData#getAccumulatedTimeTable()
	 * @see #getTRCLinePerformanceData()
	 * @generated
	 */
	EAttribute getTRCLinePerformanceData_AccumulatedTimeTable();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>TRC Object Allocation Sites Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object Allocation Sites Entry</em>'.
	 * @see java.util.Map.Entry
	 * @model features="value key process" 
	 *        valueType="org.eclipse.hyades.models.trace.TRCObjectAllocationSite" valueOpposite="TRCObjectAllocationSitesEntry" valueContainment="true" valueRequired="true" valueMany="true"
	 *        keyType="org.eclipse.hyades.models.trace.TRCMethodInvocation"
	 *        processType="org.eclipse.hyades.models.trace.TRCProcess" processOpposite="allocationSitesEntries"
	 * @generated
	 */
	EClass getTRCObjectAllocationSitesEntry();

	/**
	 * Returns the meta object for the containment reference list '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCObjectAllocationSitesEntry()
	 * @generated
	 */
	EReference getTRCObjectAllocationSitesEntry_Value();

	/**
	 * Returns the meta object for the reference '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCObjectAllocationSitesEntry()
	 * @generated
	 */
	EReference getTRCObjectAllocationSitesEntry_Key();

	/**
	 * Returns the meta object for the container reference '{@link java.util.Map.Entry <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process</em>'.
	 * @see java.util.Map.Entry
	 * @see #getTRCObjectAllocationSitesEntry()
	 * @generated
	 */
	EReference getTRCObjectAllocationSitesEntry_Process();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite <em>TRC Object Allocation Site</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object Allocation Site</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite
	 * @generated
	 */
	EClass getTRCObjectAllocationSite();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getAtLine <em>At Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>At Line</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getAtLine()
	 * @see #getTRCObjectAllocationSite()
	 * @generated
	 */
	EAttribute getTRCObjectAllocationSite_AtLine();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getTRCObjectAllocationSitesEntry <em>TRC Object Allocation Sites Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>TRC Object Allocation Sites Entry</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getTRCObjectAllocationSitesEntry()
	 * @see #getTRCObjectAllocationSite()
	 * @generated
	 */
	EReference getTRCObjectAllocationSite_TRCObjectAllocationSitesEntry();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getAllocatedObject <em>Allocated Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Allocated Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite#getAllocatedObject()
	 * @see #getTRCObjectAllocationSite()
	 * @generated
	 */
	EReference getTRCObjectAllocationSite_AllocatedObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent <em>TRC Thread Dead Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Dead Lock Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent
	 * @generated
	 */
	EClass getTRCThreadDeadLockEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent#getNextDeadLockEvent <em>Next Dead Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Next Dead Lock Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent#getNextDeadLockEvent()
	 * @see #getTRCThreadDeadLockEvent()
	 * @generated
	 */
	EReference getTRCThreadDeadLockEvent_NextDeadLockEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCLanguageElement <em>TRC Language Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Language Element</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLanguageElement
	 * @generated
	 */
	EClass getTRCLanguageElement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCLanguageElement#getSourceInfo <em>Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source Info</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLanguageElement#getSourceInfo()
	 * @see #getTRCLanguageElement()
	 * @generated
	 */
	EReference getTRCLanguageElement_SourceInfo();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCLanguageElement#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCLanguageElement#getAnnotations()
	 * @see #getTRCLanguageElement()
	 * @generated
	 */
	EReference getTRCLanguageElement_Annotations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCGCEvent <em>TRCGC Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRCGC Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent
	 * @generated
	 */
	EClass getTRCGCEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTime <em>Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getTime()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EAttribute getTRCGCEvent_Time();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getTotalObjectSpace <em>Total Object Space</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Object Space</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getTotalObjectSpace()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EAttribute getTRCGCEvent_TotalObjectSpace();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjectSpace <em>Used Object Space</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Used Object Space</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjectSpace()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EAttribute getTRCGCEvent_UsedObjectSpace();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjects <em>Used Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Used Objects</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getUsedObjects()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EAttribute getTRCGCEvent_UsedObjects();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getType()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EAttribute getTRCGCEvent_Type();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCGCEvent#getOwnerThread <em>Owner Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owner Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent#getOwnerThread()
	 * @see #getTRCGCEvent()
	 * @generated
	 */
	EReference getTRCGCEvent_OwnerThread();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation <em>TRC Object Allocation Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Object Allocation Annotation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation
	 * @generated
	 */
	EClass getTRCObjectAllocationAnnotation();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getMethods <em>Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Methods</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getMethods()
	 * @see #getTRCObjectAllocationAnnotation()
	 * @generated
	 */
	EReference getTRCObjectAllocationAnnotation_Methods();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Classes</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getClasses()
	 * @see #getTRCObjectAllocationAnnotation()
	 * @generated
	 */
	EReference getTRCObjectAllocationAnnotation_Classes();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getLineNumbers <em>Line Numbers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Line Numbers</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getLineNumbers()
	 * @see #getTRCObjectAllocationAnnotation()
	 * @generated
	 */
	EAttribute getTRCObjectAllocationAnnotation_LineNumbers();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getCreateTimes <em>Create Times</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Create Times</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation#getCreateTimes()
	 * @see #getTRCObjectAllocationAnnotation()
	 * @generated
	 */
	EAttribute getTRCObjectAllocationAnnotation_CreateTimes();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent <em>TRC Thread Wait Timeout Exceed Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Wait Timeout Exceed Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent
	 * @generated
	 */
	EClass getTRCThreadWaitTimeoutExceedEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent <em>TRC Thread Waiting For Join Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Waiting For Join Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent
	 * @generated
	 */
	EClass getTRCThreadWaitingForJoinEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent <em>TRC Thread Exec Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Exec Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadExecEvent
	 * @generated
	 */
	EClass getTRCThreadExecEvent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent#getRunningEvents <em>Running Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Running Events</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadExecEvent#getRunningEvents()
	 * @see #getTRCThreadExecEvent()
	 * @generated
	 */
	EReference getTRCThreadExecEvent_RunningEvents();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent#isInCriticalPath <em>In Critical Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>In Critical Path</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadExecEvent#isInCriticalPath()
	 * @see #getTRCThreadExecEvent()
	 * @generated
	 */
	EAttribute getTRCThreadExecEvent_InCriticalPath();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent <em>TRC Thread Notify All Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Notify All Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent
	 * @generated
	 */
	EClass getTRCThreadNotifyAllEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadNotifyEvent <em>TRC Thread Notify Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Notify Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadNotifyEvent
	 * @generated
	 */
	EClass getTRCThreadNotifyEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent <em>TRC Thread Dead And Notify Joined Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Dead And Notify Joined Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent
	 * @generated
	 */
	EClass getTRCThreadDeadAndNotifyJoinedEvent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent <em>TRC Thread Start Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Start Thread Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent
	 * @generated
	 */
	EClass getTRCThreadStartThreadEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent#getStartedThread <em>Started Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Started Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent#getStartedThread()
	 * @see #getTRCThreadStartThreadEvent()
	 * @generated
	 */
	EReference getTRCThreadStartThreadEvent_StartedThread();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent <em>TRC Thread Interrupt Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Interrupt Thread Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent
	 * @generated
	 */
	EClass getTRCThreadInterruptThreadEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent#getInterruptedThread <em>Interrupted Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Interrupted Thread</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent#getInterruptedThread()
	 * @see #getTRCThreadInterruptThreadEvent()
	 * @generated
	 */
	EReference getTRCThreadInterruptThreadEvent_InterruptedThread();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent <em>TRC Thread Handoff Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Thread Handoff Lock Event</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent
	 * @generated
	 */
	EClass getTRCThreadHandoffLockEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent#getLockedObject <em>Locked Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Locked Object</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent#getLockedObject()
	 * @see #getTRCThreadHandoffLockEvent()
	 * @generated
	 */
	EReference getTRCThreadHandoffLockEvent_LockedObject();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCPrimitiveType <em>TRC Primitive Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Primitive Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCPrimitiveType
	 * @generated
	 */
	EEnum getTRCPrimitiveType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCSignatureNotation <em>TRC Signature Notation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Signature Notation</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCSignatureNotation
	 * @generated
	 */
	EEnum getTRCSignatureNotation();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCMethodProperties <em>TRC Method Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Method Properties</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCMethodProperties
	 * @generated
	 */
	EEnum getTRCMethodProperties();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCGCRootType <em>TRCGC Root Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRCGC Root Type</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCGCRootType
	 * @generated
	 */
	EEnum getTRCGCRootType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCObjectValueKind <em>TRC Object Value Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Object Value Kind</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValueKind
	 * @generated
	 */
	EEnum getTRCObjectValueKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.trace.TRCObjectValuePosition <em>TRC Object Value Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Object Value Position</em>'.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValuePosition
	 * @generated
	 */
	EEnum getTRCObjectValuePosition();

	/**
	 * Returns the meta object for data type '<em>EObject ID</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>EObject ID</em>'.
	 * @model instanceClass="long"
	 * @generated
	 */
	EDataType getEObjectID();

	/**
	 * Returns the meta object for data type '<em>EMethod ID</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>EMethod ID</em>'.
	 * @model instanceClass="int"
	 * @generated
	 */
	EDataType getEMethodID();

	/**
	 * Returns the meta object for data type '<em>EClass ID</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>EClass ID</em>'.
	 * @model instanceClass="long"
	 * @generated
	 */
	EDataType getEClassID();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.models.trace.util.LLUnitData <em>LL Unit Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>LL Unit Data</em>'.
	 * @see org.eclipse.hyades.models.trace.util.LLUnitData
	 * @model instanceClass="org.eclipse.hyades.models.trace.util.LLUnitData"
	 * @generated
	 */
	EDataType getLLUnitData();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TraceFactory getTraceFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals  {
		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl <em>TRC Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObject()
		 * @generated
		 */
		EClass TRC_OBJECT = eINSTANCE.getTRCObject();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT__ID = eINSTANCE.getTRCObject_Id();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT__SIZE = eINSTANCE.getTRCObject_Size();

		/**
		 * The meta object literal for the '<em><b>Is A</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT__IS_A = eINSTANCE.getTRCObject_IsA();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT__PROCESS = eINSTANCE.getTRCObject_Process();

		/**
		 * The meta object literal for the '<em><b>Cumulative Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT__CUMULATIVE_SIZE = eINSTANCE.getTRCObject_CumulativeSize();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl <em>TRC Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCClassImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCClass()
		 * @generated
		 */
		EClass TRC_CLASS = eINSTANCE.getTRCClass();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__ID = eINSTANCE.getTRCClass_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__NAME = eINSTANCE.getTRCClass_Name();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__SIZE = eINSTANCE.getTRCClass_Size();

		/**
		 * The meta object literal for the '<em><b>Load Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__LOAD_TIME = eINSTANCE.getTRCClass_LoadTime();

		/**
		 * The meta object literal for the '<em><b>Unload Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__UNLOAD_TIME = eINSTANCE.getTRCClass_UnloadTime();

		/**
		 * The meta object literal for the '<em><b>Interface</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__INTERFACE = eINSTANCE.getTRCClass_Interface();

		/**
		 * The meta object literal for the '<em><b>Line No</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__LINE_NO = eINSTANCE.getTRCClass_LineNo();

		/**
		 * The meta object literal for the '<em><b>Line Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__LINE_COUNT = eINSTANCE.getTRCClass_LineCount();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__BASE_TIME = eINSTANCE.getTRCClass_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__CUMULATIVE_TIME = eINSTANCE.getTRCClass_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__CALLS = eINSTANCE.getTRCClass_Calls();

		/**
		 * The meta object literal for the '<em><b>Inherited Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__INHERITED_CALLS = eINSTANCE.getTRCClass_InheritedCalls();

		/**
		 * The meta object literal for the '<em><b>Inherited Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__INHERITED_BASE_TIME = eINSTANCE.getTRCClass_InheritedBaseTime();

		/**
		 * The meta object literal for the '<em><b>Inherited Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__INHERITED_CUMULATIVE_TIME = eINSTANCE.getTRCClass_InheritedCumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Total Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__TOTAL_SIZE = eINSTANCE.getTRCClass_TotalSize();

		/**
		 * The meta object literal for the '<em><b>Total Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__TOTAL_INSTANCES = eINSTANCE.getTRCClass_TotalInstances();

		/**
		 * The meta object literal for the '<em><b>Collected Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__COLLECTED_SIZE = eINSTANCE.getTRCClass_CollectedSize();

		/**
		 * The meta object literal for the '<em><b>Collected Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__COLLECTED_INSTANCES = eINSTANCE.getTRCClass_CollectedInstances();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__TOTAL_CPU_TIME = eINSTANCE.getTRCClass_TotalCpuTime();

		/**
		 * The meta object literal for the '<em><b>Objects</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__OBJECTS = eINSTANCE.getTRCClass_Objects();

		/**
		 * The meta object literal for the '<em><b>Loaded By</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__LOADED_BY = eINSTANCE.getTRCClass_LoadedBy();

		/**
		 * The meta object literal for the '<em><b>Methods</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__METHODS = eINSTANCE.getTRCClass_Methods();

		/**
		 * The meta object literal for the '<em><b>Class Objects</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__CLASS_OBJECTS = eINSTANCE.getTRCClass_ClassObjects();

		/**
		 * The meta object literal for the '<em><b>Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__PACKAGE = eINSTANCE.getTRCClass_Package();

		/**
		 * The meta object literal for the '<em><b>Class Loader</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__CLASS_LOADER = eINSTANCE.getTRCClass_ClassLoader();

		/**
		 * The meta object literal for the '<em><b>Enclosed By</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__ENCLOSED_BY = eINSTANCE.getTRCClass_EnclosedBy();

		/**
		 * The meta object literal for the '<em><b>Extends</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__EXTENDS = eINSTANCE.getTRCClass_Extends();

		/**
		 * The meta object literal for the '<em><b>Implements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__IMPLEMENTS = eINSTANCE.getTRCClass_Implements();

		/**
		 * The meta object literal for the '<em><b>Locks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS__LOCKS = eINSTANCE.getTRCClass_Locks();

		/**
		 * The meta object literal for the '<em><b>Cumulative Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CLASS__CUMULATIVE_SIZE = eINSTANCE.getTRCClass_CumulativeSize();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl <em>TRC Method Invocation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodInvocation()
		 * @generated
		 */
		EClass TRC_METHOD_INVOCATION = eINSTANCE.getTRCMethodInvocation();

		/**
		 * The meta object literal for the '<em><b>Method</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__METHOD = eINSTANCE.getTRCMethodInvocation_Method();

		/**
		 * The meta object literal for the '<em><b>Invoked By</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__INVOKED_BY = eINSTANCE.getTRCMethodInvocation_InvokedBy();

		/**
		 * The meta object literal for the '<em><b>Invokes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__INVOKES = eINSTANCE.getTRCMethodInvocation_Invokes();

		/**
		 * The meta object literal for the '<em><b>Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__THREAD = eINSTANCE.getTRCMethodInvocation_Thread();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__PROCESS = eINSTANCE.getTRCMethodInvocation_Process();

		/**
		 * The meta object literal for the '<em><b>Owning Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_INVOCATION__OWNING_OBJECT = eINSTANCE.getTRCMethodInvocation_OwningObject();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl <em>TRC Process</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCProcessImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCProcess()
		 * @generated
		 */
		EClass TRC_PROCESS = eINSTANCE.getTRCProcess();

		/**
		 * The meta object literal for the '<em><b>Pid</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__PID = eINSTANCE.getTRCProcess_Pid();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__NAME = eINSTANCE.getTRCProcess_Name();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__ID = eINSTANCE.getTRCProcess_Id();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__START_TIME = eINSTANCE.getTRCProcess_StartTime();

		/**
		 * The meta object literal for the '<em><b>Stop Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__STOP_TIME = eINSTANCE.getTRCProcess_StopTime();

		/**
		 * The meta object literal for the '<em><b>Last Event Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__LAST_EVENT_TIME = eINSTANCE.getTRCProcess_LastEventTime();

		/**
		 * The meta object literal for the '<em><b>Init Finished Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__INIT_FINISHED_TIME = eINSTANCE.getTRCProcess_InitFinishedTime();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__BASE_TIME = eINSTANCE.getTRCProcess_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__CUMULATIVE_TIME = eINSTANCE.getTRCProcess_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__CALLS = eINSTANCE.getTRCProcess_Calls();

		/**
		 * The meta object literal for the '<em><b>Inherited Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__INHERITED_CALLS = eINSTANCE.getTRCProcess_InheritedCalls();

		/**
		 * The meta object literal for the '<em><b>Inherited Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__INHERITED_BASE_TIME = eINSTANCE.getTRCProcess_InheritedBaseTime();

		/**
		 * The meta object literal for the '<em><b>Inherited Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__INHERITED_CUMULATIVE_TIME = eINSTANCE.getTRCProcess_InheritedCumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Total Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__TOTAL_SIZE = eINSTANCE.getTRCProcess_TotalSize();

		/**
		 * The meta object literal for the '<em><b>Total Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__TOTAL_INSTANCES = eINSTANCE.getTRCProcess_TotalInstances();

		/**
		 * The meta object literal for the '<em><b>Collected Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__COLLECTED_SIZE = eINSTANCE.getTRCProcess_CollectedSize();

		/**
		 * The meta object literal for the '<em><b>Collected Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__COLLECTED_INSTANCES = eINSTANCE.getTRCProcess_CollectedInstances();

		/**
		 * The meta object literal for the '<em><b>Reference Pointer Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__REFERENCE_POINTER_SIZE = eINSTANCE.getTRCProcess_ReferencePointerSize();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__TOTAL_CPU_TIME = eINSTANCE.getTRCProcess_TotalCpuTime();

		/**
		 * The meta object literal for the '<em><b>Cpu Sample Resolution</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__CPU_SAMPLE_RESOLUTION = eINSTANCE.getTRCProcess_CpuSampleResolution();

		/**
		 * The meta object literal for the '<em><b>Thread States</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__THREAD_STATES = eINSTANCE.getTRCProcess_ThreadStates();

		/**
		 * The meta object literal for the '<em><b>Precision</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__PRECISION = eINSTANCE.getTRCProcess_Precision();

		/**
		 * The meta object literal for the '<em><b>Languages</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PROCESS__LANGUAGES = eINSTANCE.getTRCProcess_Languages();

		/**
		 * The meta object literal for the '<em><b>Threads</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__THREADS = eINSTANCE.getTRCProcess_Threads();

		/**
		 * The meta object literal for the '<em><b>Packages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__PACKAGES = eINSTANCE.getTRCProcess_Packages();

		/**
		 * The meta object literal for the '<em><b>Class Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__CLASS_CLASS = eINSTANCE.getTRCProcess_ClassClass();

		/**
		 * The meta object literal for the '<em><b>Collection Boundary Points</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__COLLECTION_BOUNDARY_POINTS = eINSTANCE.getTRCProcess_CollectionBoundaryPoints();

		/**
		 * The meta object literal for the '<em><b>Class Loaders</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__CLASS_LOADERS = eINSTANCE.getTRCProcess_ClassLoaders();

		/**
		 * The meta object literal for the '<em><b>Source Infos</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__SOURCE_INFOS = eINSTANCE.getTRCProcess_SourceInfos();

		/**
		 * The meta object literal for the '<em><b>Objects</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__OBJECTS = eINSTANCE.getTRCProcess_Objects();

		/**
		 * The meta object literal for the '<em><b>Heap Dumps</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__HEAP_DUMPS = eINSTANCE.getTRCProcess_HeapDumps();

		/**
		 * The meta object literal for the '<em><b>Invocations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__INVOCATIONS = eINSTANCE.getTRCProcess_Invocations();

		/**
		 * The meta object literal for the '<em><b>Input Output Container</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__INPUT_OUTPUT_CONTAINER = eINSTANCE.getTRCProcess_InputOutputContainer();

		/**
		 * The meta object literal for the '<em><b>Method Lock Access Entries</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES = eINSTANCE.getTRCProcess_MethodLockAccessEntries();

		/**
		 * The meta object literal for the '<em><b>Allocation Sites Entries</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__ALLOCATION_SITES_ENTRIES = eINSTANCE.getTRCProcess_AllocationSitesEntries();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__ANNOTATIONS = eINSTANCE.getTRCProcess_Annotations();

		/**
		 * The meta object literal for the '<em><b>Gc Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PROCESS__GC_EVENTS = eINSTANCE.getTRCProcess_GcEvents();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl <em>TRC Thread</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThread()
		 * @generated
		 */
		EClass TRC_THREAD = eINSTANCE.getTRCThread();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__ID = eINSTANCE.getTRCThread_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__NAME = eINSTANCE.getTRCThread_Name();

		/**
		 * The meta object literal for the '<em><b>Group Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__GROUP_NAME = eINSTANCE.getTRCThread_GroupName();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__START_TIME = eINSTANCE.getTRCThread_StartTime();

		/**
		 * The meta object literal for the '<em><b>Stop Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__STOP_TIME = eINSTANCE.getTRCThread_StopTime();

		/**
		 * The meta object literal for the '<em><b>Max Stack Depth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__MAX_STACK_DEPTH = eINSTANCE.getTRCThread_MaxStackDepth();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD__TOTAL_CPU_TIME = eINSTANCE.getTRCThread_TotalCpuTime();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD__PROCESS = eINSTANCE.getTRCThread_Process();

		/**
		 * The meta object literal for the '<em><b>Initial Invocations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD__INITIAL_INVOCATIONS = eINSTANCE.getTRCThread_InitialInvocations();

		/**
		 * The meta object literal for the '<em><b>Thread Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD__THREAD_OBJECT = eINSTANCE.getTRCThread_ThreadObject();

		/**
		 * The meta object literal for the '<em><b>Thread Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD__THREAD_EVENTS = eINSTANCE.getTRCThread_ThreadEvents();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD__ANNOTATIONS = eINSTANCE.getTRCThread_Annotations();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl <em>TRC Method</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCMethodImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethod()
		 * @generated
		 */
		EClass TRC_METHOD = eINSTANCE.getTRCMethod();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__ID = eINSTANCE.getTRCMethod_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__NAME = eINSTANCE.getTRCMethod_Name();

		/**
		 * The meta object literal for the '<em><b>Signature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__SIGNATURE = eINSTANCE.getTRCMethod_Signature();

		/**
		 * The meta object literal for the '<em><b>Modifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__MODIFIER = eINSTANCE.getTRCMethod_Modifier();

		/**
		 * The meta object literal for the '<em><b>Notation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__NOTATION = eINSTANCE.getTRCMethod_Notation();

		/**
		 * The meta object literal for the '<em><b>Line No</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__LINE_NO = eINSTANCE.getTRCMethod_LineNo();

		/**
		 * The meta object literal for the '<em><b>Line Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__LINE_COUNT = eINSTANCE.getTRCMethod_LineCount();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__BASE_TIME = eINSTANCE.getTRCMethod_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__CUMULATIVE_TIME = eINSTANCE.getTRCMethod_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__CALLS = eINSTANCE.getTRCMethod_Calls();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_METHOD__TOTAL_CPU_TIME = eINSTANCE.getTRCMethod_TotalCpuTime();

		/**
		 * The meta object literal for the '<em><b>Defining Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD__DEFINING_CLASS = eINSTANCE.getTRCMethod_DefiningClass();

		/**
		 * The meta object literal for the '<em><b>Invocations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD__INVOCATIONS = eINSTANCE.getTRCMethod_Invocations();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCPackageImpl <em>TRC Package</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCPackageImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCPackage()
		 * @generated
		 */
		EClass TRC_PACKAGE = eINSTANCE.getTRCPackage();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__NAME = eINSTANCE.getTRCPackage_Name();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__BASE_TIME = eINSTANCE.getTRCPackage_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__CUMULATIVE_TIME = eINSTANCE.getTRCPackage_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__CALLS = eINSTANCE.getTRCPackage_Calls();

		/**
		 * The meta object literal for the '<em><b>Inherited Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__INHERITED_CALLS = eINSTANCE.getTRCPackage_InheritedCalls();

		/**
		 * The meta object literal for the '<em><b>Inherited Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__INHERITED_BASE_TIME = eINSTANCE.getTRCPackage_InheritedBaseTime();

		/**
		 * The meta object literal for the '<em><b>Inherited Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__INHERITED_CUMULATIVE_TIME = eINSTANCE.getTRCPackage_InheritedCumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Total Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__TOTAL_SIZE = eINSTANCE.getTRCPackage_TotalSize();

		/**
		 * The meta object literal for the '<em><b>Total Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__TOTAL_INSTANCES = eINSTANCE.getTRCPackage_TotalInstances();

		/**
		 * The meta object literal for the '<em><b>Collected Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__COLLECTED_SIZE = eINSTANCE.getTRCPackage_CollectedSize();

		/**
		 * The meta object literal for the '<em><b>Collected Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__COLLECTED_INSTANCES = eINSTANCE.getTRCPackage_CollectedInstances();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_PACKAGE__TOTAL_CPU_TIME = eINSTANCE.getTRCPackage_TotalCpuTime();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PACKAGE__PROCESS = eINSTANCE.getTRCPackage_Process();

		/**
		 * The meta object literal for the '<em><b>Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PACKAGE__CLASSES = eINSTANCE.getTRCPackage_Classes();

		/**
		 * The meta object literal for the '<em><b>Sub Packages</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PACKAGE__SUB_PACKAGES = eINSTANCE.getTRCPackage_SubPackages();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_PACKAGE__PARENT = eINSTANCE.getTRCPackage_Parent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl <em>TRC Collection Boundary</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCCollectionBoundary()
		 * @generated
		 */
		EClass TRC_COLLECTION_BOUNDARY = eINSTANCE.getTRCCollectionBoundary();

		/**
		 * The meta object literal for the '<em><b>Last Invocation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_INVOCATION = eINSTANCE.getTRCCollectionBoundary_LastInvocation();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__PROCESS = eINSTANCE.getTRCCollectionBoundary_Process();

		/**
		 * The meta object literal for the '<em><b>Last Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_CLASS = eINSTANCE.getTRCCollectionBoundary_LastClass();

		/**
		 * The meta object literal for the '<em><b>Last Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_THREAD = eINSTANCE.getTRCCollectionBoundary_LastThread();

		/**
		 * The meta object literal for the '<em><b>Last Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_OBJECT = eINSTANCE.getTRCCollectionBoundary_LastObject();

		/**
		 * The meta object literal for the '<em><b>Last Package</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_PACKAGE = eINSTANCE.getTRCCollectionBoundary_LastPackage();

		/**
		 * The meta object literal for the '<em><b>Last Method</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__LAST_METHOD = eINSTANCE.getTRCCollectionBoundary_LastMethod();

		/**
		 * The meta object literal for the '<em><b>Heap Dump</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_COLLECTION_BOUNDARY__HEAP_DUMP = eINSTANCE.getTRCCollectionBoundary_HeapDump();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl <em>TRC Class Loader</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCClassLoader()
		 * @generated
		 */
		EClass TRC_CLASS_LOADER = eINSTANCE.getTRCClassLoader();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS_LOADER__PROCESS = eINSTANCE.getTRCClassLoader_Process();

		/**
		 * The meta object literal for the '<em><b>Class Loader Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE = eINSTANCE.getTRCClassLoader_ClassLoaderInstance();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl <em>TRC Source Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSourceInfo()
		 * @generated
		 */
		EClass TRC_SOURCE_INFO = eINSTANCE.getTRCSourceInfo();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_SOURCE_INFO__LOCATION = eINSTANCE.getTRCSourceInfo_Location();

		/**
		 * The meta object literal for the '<em><b>Language</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_SOURCE_INFO__LANGUAGE = eINSTANCE.getTRCSourceInfo_Language();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl <em>TRC Heap Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapObject()
		 * @generated
		 */
		EClass TRC_HEAP_OBJECT = eINSTANCE.getTRCHeapObject();

		/**
		 * The meta object literal for the '<em><b>Ref Owner</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_OBJECT__REF_OWNER = eINSTANCE.getTRCHeapObject_RefOwner();

		/**
		 * The meta object literal for the '<em><b>Ref Target</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_OBJECT__REF_TARGET = eINSTANCE.getTRCHeapObject_RefTarget();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl <em>TRC Full Trace Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullTraceObject()
		 * @generated
		 */
		EClass TRC_FULL_TRACE_OBJECT = eINSTANCE.getTRCFullTraceObject();

		/**
		 * The meta object literal for the '<em><b>Create Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_TRACE_OBJECT__CREATE_TIME = eINSTANCE.getTRCFullTraceObject_CreateTime();

		/**
		 * The meta object literal for the '<em><b>Collect Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_TRACE_OBJECT__COLLECT_TIME = eINSTANCE.getTRCFullTraceObject_CollectTime();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_TRACE_OBJECT__BASE_TIME = eINSTANCE.getTRCFullTraceObject_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_TRACE_OBJECT__CUMULATIVE_TIME = eINSTANCE.getTRCFullTraceObject_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Calls</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_TRACE_OBJECT__CALLS = eINSTANCE.getTRCFullTraceObject_Calls();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl <em>TRC Trace Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCTraceObject()
		 * @generated
		 */
		EClass TRC_TRACE_OBJECT = eINSTANCE.getTRCTraceObject();

		/**
		 * The meta object literal for the '<em><b>Invocations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_TRACE_OBJECT__INVOCATIONS = eINSTANCE.getTRCTraceObject_Invocations();

		/**
		 * The meta object literal for the '<em><b>Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_TRACE_OBJECT__THREAD = eINSTANCE.getTRCTraceObject_Thread();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl <em>TRC Full Heap Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullHeapObject()
		 * @generated
		 */
		EClass TRC_FULL_HEAP_OBJECT = eINSTANCE.getTRCFullHeapObject();

		/**
		 * The meta object literal for the '<em><b>Heap Dump First Seen</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN = eINSTANCE.getTRCFullHeapObject_HeapDumpFirstSeen();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl <em>TRC Object Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectReference()
		 * @generated
		 */
		EClass TRC_OBJECT_REFERENCE = eINSTANCE.getTRCObjectReference();

		/**
		 * The meta object literal for the '<em><b>Heap Dump</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_REFERENCE__HEAP_DUMP = eINSTANCE.getTRCObjectReference_HeapDump();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_REFERENCE__OWNER = eINSTANCE.getTRCObjectReference_Owner();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_REFERENCE__TARGET = eINSTANCE.getTRCObjectReference_Target();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl <em>TRC Heap Dump</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapDump()
		 * @generated
		 */
		EClass TRC_HEAP_DUMP = eINSTANCE.getTRCHeapDump();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_DUMP__ID = eINSTANCE.getTRCHeapDump_Id();

		/**
		 * The meta object literal for the '<em><b>Entry Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_DUMP__ENTRY_TIME = eINSTANCE.getTRCHeapDump_EntryTime();

		/**
		 * The meta object literal for the '<em><b>Exit Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_DUMP__EXIT_TIME = eINSTANCE.getTRCHeapDump_ExitTime();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_DUMP__NAME = eINSTANCE.getTRCHeapDump_Name();

		/**
		 * The meta object literal for the '<em><b>References</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_DUMP__REFERENCES = eINSTANCE.getTRCHeapDump_References();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_DUMP__PROCESS = eINSTANCE.getTRCHeapDump_Process();

		/**
		 * The meta object literal for the '<em><b>Gc Roots</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_DUMP__GC_ROOTS = eINSTANCE.getTRCHeapDump_GcRoots();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl <em>TRC Aggregated Method Invocation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCAggregatedMethodInvocation()
		 * @generated
		 */
		EClass TRC_AGGREGATED_METHOD_INVOCATION = eINSTANCE.getTRCAggregatedMethodInvocation();

		/**
		 * The meta object literal for the '<em><b>Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__COUNT = eINSTANCE.getTRCAggregatedMethodInvocation_Count();

		/**
		 * The meta object literal for the '<em><b>Base Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME = eINSTANCE.getTRCAggregatedMethodInvocation_BaseTime();

		/**
		 * The meta object literal for the '<em><b>Cumulative Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME = eINSTANCE.getTRCAggregatedMethodInvocation_CumulativeTime();

		/**
		 * The meta object literal for the '<em><b>Min Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME = eINSTANCE.getTRCAggregatedMethodInvocation_MinTime();

		/**
		 * The meta object literal for the '<em><b>Max Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME = eINSTANCE.getTRCAggregatedMethodInvocation_MaxTime();

		/**
		 * The meta object literal for the '<em><b>Caller Line No</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO = eINSTANCE.getTRCAggregatedMethodInvocation_CallerLineNo();

		/**
		 * The meta object literal for the '<em><b>Total Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME = eINSTANCE.getTRCAggregatedMethodInvocation_TotalCpuTime();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl <em>TRC Full Method Invocation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCFullMethodInvocation()
		 * @generated
		 */
		EClass TRC_FULL_METHOD_INVOCATION = eINSTANCE.getTRCFullMethodInvocation();

		/**
		 * The meta object literal for the '<em><b>Stack Depth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__STACK_DEPTH = eINSTANCE.getTRCFullMethodInvocation_StackDepth();

		/**
		 * The meta object literal for the '<em><b>Entry Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__ENTRY_TIME = eINSTANCE.getTRCFullMethodInvocation_EntryTime();

		/**
		 * The meta object literal for the '<em><b>Exit Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__EXIT_TIME = eINSTANCE.getTRCFullMethodInvocation_ExitTime();

		/**
		 * The meta object literal for the '<em><b>Ticket</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__TICKET = eINSTANCE.getTRCFullMethodInvocation_Ticket();

		/**
		 * The meta object literal for the '<em><b>Overhead</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__OVERHEAD = eINSTANCE.getTRCFullMethodInvocation_Overhead();

		/**
		 * The meta object literal for the '<em><b>Caller Line No</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO = eINSTANCE.getTRCFullMethodInvocation_CallerLineNo();

		/**
		 * The meta object literal for the '<em><b>Cpu Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_FULL_METHOD_INVOCATION__CPU_TIME = eINSTANCE.getTRCFullMethodInvocation_CpuTime();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl <em>TRC Heap Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCHeapRoot()
		 * @generated
		 */
		EClass TRC_HEAP_ROOT = eINSTANCE.getTRCHeapRoot();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_ROOT__TYPE = eINSTANCE.getTRCHeapRoot_Type();

		/**
		 * The meta object literal for the '<em><b>Frame</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_HEAP_ROOT__FRAME = eINSTANCE.getTRCHeapRoot_Frame();

		/**
		 * The meta object literal for the '<em><b>Heap Dump</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_ROOT__HEAP_DUMP = eINSTANCE.getTRCHeapRoot_HeapDump();

		/**
		 * The meta object literal for the '<em><b>Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_ROOT__THREAD = eINSTANCE.getTRCHeapRoot_Thread();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_HEAP_ROOT__OBJECT = eINSTANCE.getTRCHeapRoot_Object();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl <em>TRC Array Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCArrayClass()
		 * @generated
		 */
		EClass TRC_ARRAY_CLASS = eINSTANCE.getTRCArrayClass();

		/**
		 * The meta object literal for the '<em><b>Array Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_ARRAY_CLASS__ARRAY_TYPE = eINSTANCE.getTRCArrayClass_ArrayType();

		/**
		 * The meta object literal for the '<em><b>Element Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_ARRAY_CLASS__ELEMENT_TYPE = eINSTANCE.getTRCArrayClass_ElementType();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl <em>TRC Aggregated Object Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCAggregatedObjectReference()
		 * @generated
		 */
		EClass TRC_AGGREGATED_OBJECT_REFERENCE = eINSTANCE.getTRCAggregatedObjectReference();

		/**
		 * The meta object literal for the '<em><b>Owner Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE = eINSTANCE.getTRCAggregatedObjectReference_OwnerSize();

		/**
		 * The meta object literal for the '<em><b>Target Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE = eINSTANCE.getTRCAggregatedObjectReference_TargetSize();

		/**
		 * The meta object literal for the '<em><b>Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_AGGREGATED_OBJECT_REFERENCE__COUNT = eINSTANCE.getTRCAggregatedObjectReference_Count();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadEventImpl <em>TRC Thread Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadEvent()
		 * @generated
		 */
		EClass TRC_THREAD_EVENT = eINSTANCE.getTRCThreadEvent();

		/**
		 * The meta object literal for the '<em><b>Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD_EVENT__TIME = eINSTANCE.getTRCThreadEvent_Time();

		/**
		 * The meta object literal for the '<em><b>Thread</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_EVENT__THREAD = eINSTANCE.getTRCThreadEvent_Thread();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_EVENT__ANNOTATIONS = eINSTANCE.getTRCThreadEvent_Annotations();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl <em>TRC Thread Sleeping Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadSleepingEvent()
		 * @generated
		 */
		EClass TRC_THREAD_SLEEPING_EVENT = eINSTANCE.getTRCThreadSleepingEvent();

		/**
		 * The meta object literal for the '<em><b>Sleeping Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD_SLEEPING_EVENT__SLEEPING_TIME = eINSTANCE.getTRCThreadSleepingEvent_SleepingTime();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl <em>TRC Thread Waiting For Object Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForObjectEvent()
		 * @generated
		 */
		EClass TRC_THREAD_WAITING_FOR_OBJECT_EVENT = eINSTANCE.getTRCThreadWaitingForObjectEvent();

		/**
		 * The meta object literal for the '<em><b>Timeout</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT = eINSTANCE.getTRCThreadWaitingForObjectEvent_Timeout();

		/**
		 * The meta object literal for the '<em><b>Object Waiting For</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR = eINSTANCE.getTRCThreadWaitingForObjectEvent_ObjectWaitingFor();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl <em>TRC Thread Waiting For Lock Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForLockEvent()
		 * @generated
		 */
		EClass TRC_THREAD_WAITING_FOR_LOCK_EVENT = eINSTANCE.getTRCThreadWaitingForLockEvent();

		/**
		 * The meta object literal for the '<em><b>Locked Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT = eINSTANCE.getTRCThreadWaitingForLockEvent_LockedObject();

		/**
		 * The meta object literal for the '<em><b>Locking Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD = eINSTANCE.getTRCThreadWaitingForLockEvent_LockingThread();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadRunningEventImpl <em>TRC Thread Running Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadRunningEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadRunningEvent()
		 * @generated
		 */
		EClass TRC_THREAD_RUNNING_EVENT = eINSTANCE.getTRCThreadRunningEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadEventImpl <em>TRC Thread Dead Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadEvent()
		 * @generated
		 */
		EClass TRC_THREAD_DEAD_EVENT = eINSTANCE.getTRCThreadDeadEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl <em>TRC Method With LL Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodWithLLData()
		 * @generated
		 */
		EClass TRC_METHOD_WITH_LL_DATA = eINSTANCE.getTRCMethodWithLLData();

		/**
		 * The meta object literal for the '<em><b>LL Data</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_METHOD_WITH_LL_DATA__LL_DATA = eINSTANCE.getTRCMethodWithLLData_LLData();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCLLDataImpl <em>TRCLL Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCLLDataImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLLData()
		 * @generated
		 */
		EClass TRCLL_DATA = eINSTANCE.getTRCLLData();

		/**
		 * The meta object literal for the '<em><b>Summary Units</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCLL_DATA__SUMMARY_UNITS = eINSTANCE.getTRCLLData_SummaryUnits();

		/**
		 * The meta object literal for the '<em><b>Summary Nonzero</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCLL_DATA__SUMMARY_NONZERO = eINSTANCE.getTRCLLData_SummaryNonzero();

		/**
		 * The meta object literal for the '<em><b>Type Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCLL_DATA__TYPE_ID = eINSTANCE.getTRCLLData_TypeId();

		/**
		 * The meta object literal for the '<em><b>Headings</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCLL_DATA__HEADINGS = eINSTANCE.getTRCLLData_Headings();

		/**
		 * The meta object literal for the '<em><b>Method</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRCLL_DATA__METHOD = eINSTANCE.getTRCLLData_Method();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCSourceInfoWithLLDataImpl <em>TRC Source Info With LL Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCSourceInfoWithLLDataImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSourceInfoWithLLData()
		 * @generated
		 */
		EClass TRC_SOURCE_INFO_WITH_LL_DATA = eINSTANCE.getTRCSourceInfoWithLLData();

		/**
		 * The meta object literal for the '<em><b>LL Datas</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_SOURCE_INFO_WITH_LL_DATA__LL_DATAS = eINSTANCE.getTRCSourceInfoWithLLData_LLDatas();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl <em>TRC Line Coverage Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLineCoverageData()
		 * @generated
		 */
		EClass TRC_LINE_COVERAGE_DATA = eINSTANCE.getTRCLineCoverageData();

		/**
		 * The meta object literal for the '<em><b>Line Table</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LINE_COVERAGE_DATA__LINE_TABLE = eINSTANCE.getTRCLineCoverageData_LineTable();

		/**
		 * The meta object literal for the '<em><b>Hit Table</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LINE_COVERAGE_DATA__HIT_TABLE = eINSTANCE.getTRCLineCoverageData_HitTable();

		/**
		 * The meta object literal for the '<em><b>Count Table</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LINE_COVERAGE_DATA__COUNT_TABLE = eINSTANCE.getTRCLineCoverageData_CountTable();

		/**
		 * The meta object literal for the '<em><b>Source Info</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_LINE_COVERAGE_DATA__SOURCE_INFO = eINSTANCE.getTRCLineCoverageData_SourceInfo();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl <em>TRC Object Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValue()
		 * @generated
		 */
		EClass TRC_OBJECT_VALUE = eINSTANCE.getTRCObjectValue();

		/**
		 * The meta object literal for the '<em><b>String Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT_VALUE__STRING_VALUE = eINSTANCE.getTRCObjectValue_StringValue();

		/**
		 * The meta object literal for the '<em><b>TRC Input Output Entry</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY = eINSTANCE.getTRCObjectValue_TRCInputOutputEntry();

		/**
		 * The meta object literal for the '<em><b>Container</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_VALUE__CONTAINER = eINSTANCE.getTRCObjectValue_Container();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputEntryImpl <em>TRC Input Output Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCInputOutputEntryImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCInputOutputEntry()
		 * @generated
		 */
		EClass TRC_INPUT_OUTPUT_ENTRY = eINSTANCE.getTRCInputOutputEntry();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_ENTRY__VALUE = eINSTANCE.getTRCInputOutputEntry_Value();

		/**
		 * The meta object literal for the '<em><b>Container</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_ENTRY__CONTAINER = eINSTANCE.getTRCInputOutputEntry_Container();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_ENTRY__KEY = eINSTANCE.getTRCInputOutputEntry_Key();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl <em>TRC Input Output Container</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCInputOutputContainer()
		 * @generated
		 */
		EClass TRC_INPUT_OUTPUT_CONTAINER = eINSTANCE.getTRCInputOutputContainer();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_CONTAINER__PROCESS = eINSTANCE.getTRCInputOutputContainer_Process();

		/**
		 * The meta object literal for the '<em><b>Entries</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_CONTAINER__ENTRIES = eINSTANCE.getTRCInputOutputContainer_Entries();

		/**
		 * The meta object literal for the '<em><b>Input Output Values</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES = eINSTANCE.getTRCInputOutputContainer_InputOutputValues();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl <em>TRC Caller Callee Invocation Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCCallerCalleeInvocationInfo()
		 * @generated
		 */
		EClass TRC_CALLER_CALLEE_INVOCATION_INFO = eINSTANCE.getTRCCallerCalleeInvocationInfo();

		/**
		 * The meta object literal for the '<em><b>Call Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME = eINSTANCE.getTRCCallerCalleeInvocationInfo_CallTime();

		/**
		 * The meta object literal for the '<em><b>Return Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME = eINSTANCE.getTRCCallerCalleeInvocationInfo_ReturnTime();

		/**
		 * The meta object literal for the '<em><b>Call Overhead</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD = eINSTANCE.getTRCCallerCalleeInvocationInfo_CallOverhead();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl <em>TRC Typed Object Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCTypedObjectValue()
		 * @generated
		 */
		EClass TRC_TYPED_OBJECT_VALUE = eINSTANCE.getTRCTypedObjectValue();

		/**
		 * The meta object literal for the '<em><b>Value Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_TYPED_OBJECT_VALUE__VALUE_KIND = eINSTANCE.getTRCTypedObjectValue_ValueKind();

		/**
		 * The meta object literal for the '<em><b>Position Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_TYPED_OBJECT_VALUE__POSITION_KIND = eINSTANCE.getTRCTypedObjectValue_PositionKind();

		/**
		 * The meta object literal for the '<em><b>Position</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_TYPED_OBJECT_VALUE__POSITION = eINSTANCE.getTRCTypedObjectValue_Position();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_TYPED_OBJECT_VALUE__OBJECT = eINSTANCE.getTRCTypedObjectValue_Object();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCMthdLckAccEntryImpl <em>TRC Mthd Lck Acc Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCMthdLckAccEntryImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMthdLckAccEntry()
		 * @generated
		 */
		EClass TRC_MTHD_LCK_ACC_ENTRY = eINSTANCE.getTRCMthdLckAccEntry();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_MTHD_LCK_ACC_ENTRY__PROCESS = eINSTANCE.getTRCMthdLckAccEntry_Process();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_MTHD_LCK_ACC_ENTRY__VALUE = eINSTANCE.getTRCMthdLckAccEntry_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_MTHD_LCK_ACC_ENTRY__KEY = eINSTANCE.getTRCMthdLckAccEntry_Key();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl <em>TRC Lock Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLockAccess()
		 * @generated
		 */
		EClass TRC_LOCK_ACCESS = eINSTANCE.getTRCLockAccess();

		/**
		 * The meta object literal for the '<em><b>Require Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LOCK_ACCESS__REQUIRE_TIME = eINSTANCE.getTRCLockAccess_RequireTime();

		/**
		 * The meta object literal for the '<em><b>Request Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LOCK_ACCESS__REQUEST_TIME = eINSTANCE.getTRCLockAccess_RequestTime();

		/**
		 * The meta object literal for the '<em><b>Release Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LOCK_ACCESS__RELEASE_TIME = eINSTANCE.getTRCLockAccess_ReleaseTime();

		/**
		 * The meta object literal for the '<em><b>At Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LOCK_ACCESS__AT_LINE = eINSTANCE.getTRCLockAccess_AtLine();

		/**
		 * The meta object literal for the '<em><b>On Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_LOCK_ACCESS__ON_OBJECT = eINSTANCE.getTRCLockAccess_OnObject();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl <em>TRC Line Performance Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLinePerformanceData()
		 * @generated
		 */
		EClass TRC_LINE_PERFORMANCE_DATA = eINSTANCE.getTRCLinePerformanceData();

		/**
		 * The meta object literal for the '<em><b>Accumulated Time Table</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE = eINSTANCE.getTRCLinePerformanceData_AccumulatedTimeTable();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSitesEntryImpl <em>TRC Object Allocation Sites Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSitesEntryImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationSitesEntry()
		 * @generated
		 */
		EClass TRC_OBJECT_ALLOCATION_SITES_ENTRY = eINSTANCE.getTRCObjectAllocationSitesEntry();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE = eINSTANCE.getTRCObjectAllocationSitesEntry_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_SITES_ENTRY__KEY = eINSTANCE.getTRCObjectAllocationSitesEntry_Key();

		/**
		 * The meta object literal for the '<em><b>Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_SITES_ENTRY__PROCESS = eINSTANCE.getTRCObjectAllocationSitesEntry_Process();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl <em>TRC Object Allocation Site</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationSite()
		 * @generated
		 */
		EClass TRC_OBJECT_ALLOCATION_SITE = eINSTANCE.getTRCObjectAllocationSite();

		/**
		 * The meta object literal for the '<em><b>At Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT_ALLOCATION_SITE__AT_LINE = eINSTANCE.getTRCObjectAllocationSite_AtLine();

		/**
		 * The meta object literal for the '<em><b>TRC Object Allocation Sites Entry</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY = eINSTANCE.getTRCObjectAllocationSite_TRCObjectAllocationSitesEntry();

		/**
		 * The meta object literal for the '<em><b>Allocated Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT = eINSTANCE.getTRCObjectAllocationSite_AllocatedObject();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadLockEventImpl <em>TRC Thread Dead Lock Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadLockEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadLockEvent()
		 * @generated
		 */
		EClass TRC_THREAD_DEAD_LOCK_EVENT = eINSTANCE.getTRCThreadDeadLockEvent();

		/**
		 * The meta object literal for the '<em><b>Next Dead Lock Event</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_DEAD_LOCK_EVENT__NEXT_DEAD_LOCK_EVENT = eINSTANCE.getTRCThreadDeadLockEvent_NextDeadLockEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCLanguageElementImpl <em>TRC Language Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCLanguageElementImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCLanguageElement()
		 * @generated
		 */
		EClass TRC_LANGUAGE_ELEMENT = eINSTANCE.getTRCLanguageElement();

		/**
		 * The meta object literal for the '<em><b>Source Info</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_LANGUAGE_ELEMENT__SOURCE_INFO = eINSTANCE.getTRCLanguageElement_SourceInfo();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_LANGUAGE_ELEMENT__ANNOTATIONS = eINSTANCE.getTRCLanguageElement_Annotations();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl <em>TRCGC Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCGCEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCGCEvent()
		 * @generated
		 */
		EClass TRCGC_EVENT = eINSTANCE.getTRCGCEvent();

		/**
		 * The meta object literal for the '<em><b>Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCGC_EVENT__TIME = eINSTANCE.getTRCGCEvent_Time();

		/**
		 * The meta object literal for the '<em><b>Total Object Space</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCGC_EVENT__TOTAL_OBJECT_SPACE = eINSTANCE.getTRCGCEvent_TotalObjectSpace();

		/**
		 * The meta object literal for the '<em><b>Used Object Space</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCGC_EVENT__USED_OBJECT_SPACE = eINSTANCE.getTRCGCEvent_UsedObjectSpace();

		/**
		 * The meta object literal for the '<em><b>Used Objects</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCGC_EVENT__USED_OBJECTS = eINSTANCE.getTRCGCEvent_UsedObjects();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRCGC_EVENT__TYPE = eINSTANCE.getTRCGCEvent_Type();

		/**
		 * The meta object literal for the '<em><b>Owner Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRCGC_EVENT__OWNER_THREAD = eINSTANCE.getTRCGCEvent_OwnerThread();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl <em>TRC Object Allocation Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectAllocationAnnotation()
		 * @generated
		 */
		EClass TRC_OBJECT_ALLOCATION_ANNOTATION = eINSTANCE.getTRCObjectAllocationAnnotation();

		/**
		 * The meta object literal for the '<em><b>Methods</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS = eINSTANCE.getTRCObjectAllocationAnnotation_Methods();

		/**
		 * The meta object literal for the '<em><b>Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES = eINSTANCE.getTRCObjectAllocationAnnotation_Classes();

		/**
		 * The meta object literal for the '<em><b>Line Numbers</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS = eINSTANCE.getTRCObjectAllocationAnnotation_LineNumbers();

		/**
		 * The meta object literal for the '<em><b>Create Times</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES = eINSTANCE.getTRCObjectAllocationAnnotation_CreateTimes();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitTimeoutExceedEventImpl <em>TRC Thread Wait Timeout Exceed Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitTimeoutExceedEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitTimeoutExceedEvent()
		 * @generated
		 */
		EClass TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT = eINSTANCE.getTRCThreadWaitTimeoutExceedEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForJoinEventImpl <em>TRC Thread Waiting For Join Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForJoinEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadWaitingForJoinEvent()
		 * @generated
		 */
		EClass TRC_THREAD_WAITING_FOR_JOIN_EVENT = eINSTANCE.getTRCThreadWaitingForJoinEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl <em>TRC Thread Exec Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadExecEvent()
		 * @generated
		 */
		EClass TRC_THREAD_EXEC_EVENT = eINSTANCE.getTRCThreadExecEvent();

		/**
		 * The meta object literal for the '<em><b>Running Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS = eINSTANCE.getTRCThreadExecEvent_RunningEvents();

		/**
		 * The meta object literal for the '<em><b>In Critical Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH = eINSTANCE.getTRCThreadExecEvent_InCriticalPath();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadNotifyAllEventImpl <em>TRC Thread Notify All Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadNotifyAllEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadNotifyAllEvent()
		 * @generated
		 */
		EClass TRC_THREAD_NOTIFY_ALL_EVENT = eINSTANCE.getTRCThreadNotifyAllEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadNotifyEventImpl <em>TRC Thread Notify Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadNotifyEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadNotifyEvent()
		 * @generated
		 */
		EClass TRC_THREAD_NOTIFY_EVENT = eINSTANCE.getTRCThreadNotifyEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadDeadAndNotifyJoinedEventImpl <em>TRC Thread Dead And Notify Joined Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadDeadAndNotifyJoinedEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadDeadAndNotifyJoinedEvent()
		 * @generated
		 */
		EClass TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT = eINSTANCE.getTRCThreadDeadAndNotifyJoinedEvent();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl <em>TRC Thread Start Thread Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadStartThreadEvent()
		 * @generated
		 */
		EClass TRC_THREAD_START_THREAD_EVENT = eINSTANCE.getTRCThreadStartThreadEvent();

		/**
		 * The meta object literal for the '<em><b>Started Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD = eINSTANCE.getTRCThreadStartThreadEvent_StartedThread();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl <em>TRC Thread Interrupt Thread Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadInterruptThreadEvent()
		 * @generated
		 */
		EClass TRC_THREAD_INTERRUPT_THREAD_EVENT = eINSTANCE.getTRCThreadInterruptThreadEvent();

		/**
		 * The meta object literal for the '<em><b>Interrupted Thread</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD = eINSTANCE.getTRCThreadInterruptThreadEvent_InterruptedThread();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl <em>TRC Thread Handoff Lock Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCThreadHandoffLockEvent()
		 * @generated
		 */
		EClass TRC_THREAD_HANDOFF_LOCK_EVENT = eINSTANCE.getTRCThreadHandoffLockEvent();

		/**
		 * The meta object literal for the '<em><b>Locked Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT = eINSTANCE.getTRCThreadHandoffLockEvent_LockedObject();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCPrimitiveType <em>TRC Primitive Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCPrimitiveType
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCPrimitiveType()
		 * @generated
		 */
		EEnum TRC_PRIMITIVE_TYPE = eINSTANCE.getTRCPrimitiveType();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCSignatureNotation <em>TRC Signature Notation</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCSignatureNotation
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCSignatureNotation()
		 * @generated
		 */
		EEnum TRC_SIGNATURE_NOTATION = eINSTANCE.getTRCSignatureNotation();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCMethodProperties <em>TRC Method Properties</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCMethodProperties
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCMethodProperties()
		 * @generated
		 */
		EEnum TRC_METHOD_PROPERTIES = eINSTANCE.getTRCMethodProperties();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCGCRootType <em>TRCGC Root Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCGCRootType
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCGCRootType()
		 * @generated
		 */
		EEnum TRCGC_ROOT_TYPE = eINSTANCE.getTRCGCRootType();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCObjectValueKind <em>TRC Object Value Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCObjectValueKind
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValueKind()
		 * @generated
		 */
		EEnum TRC_OBJECT_VALUE_KIND = eINSTANCE.getTRCObjectValueKind();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.trace.TRCObjectValuePosition <em>TRC Object Value Position</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.TRCObjectValuePosition
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getTRCObjectValuePosition()
		 * @generated
		 */
		EEnum TRC_OBJECT_VALUE_POSITION = eINSTANCE.getTRCObjectValuePosition();

		/**
		 * The meta object literal for the '<em>EObject ID</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEObjectID()
		 * @generated
		 */
		EDataType EOBJECT_ID = eINSTANCE.getEObjectID();

		/**
		 * The meta object literal for the '<em>EMethod ID</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEMethodID()
		 * @generated
		 */
		EDataType EMETHOD_ID = eINSTANCE.getEMethodID();

		/**
		 * The meta object literal for the '<em>EClass ID</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getEClassID()
		 * @generated
		 */
		EDataType ECLASS_ID = eINSTANCE.getEClassID();

		/**
		 * The meta object literal for the '<em>LL Unit Data</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.trace.util.LLUnitData
		 * @see org.eclipse.hyades.models.trace.impl.TracePackageImpl#getLLUnitData()
		 * @generated
		 */
		EDataType LL_UNIT_DATA = eINSTANCE.getLLUnitData();

	}

} //TracePackage
