/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCCollectionBoundaryImpl.java,v 1.11 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Collection Boundary</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastInvocation <em>Last Invocation</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastClass <em>Last Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastThread <em>Last Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastObject <em>Last Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastPackage <em>Last Package</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastMethod <em>Last Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getHeapDump <em>Heap Dump</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCCollectionBoundaryImpl extends AbstractTRCCollectionBoundaryImpl implements TRCCollectionBoundary {
	/**
	 * The cached value of the '{@link #getLastInvocation() <em>Last Invocation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastInvocation()
	 * @generated
	 * @ordered
	 */
	protected TRCMethodInvocation lastInvocation;

	/**
	 * The cached value of the '{@link #getLastClass() <em>Last Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastClass()
	 * @generated
	 * @ordered
	 */
	protected TRCClass lastClass;

	/**
	 * The cached value of the '{@link #getLastThread() <em>Last Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread lastThread;

	/**
	 * The cached value of the '{@link #getLastObject() <em>Last Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject lastObject;

	/**
	 * The cached value of the '{@link #getLastPackage() <em>Last Package</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastPackage()
	 * @generated
	 * @ordered
	 */
	protected TRCPackage lastPackage;

	/**
	 * The cached value of the '{@link #getLastMethod() <em>Last Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastMethod()
	 * @generated
	 * @ordered
	 */
	protected TRCMethod lastMethod;

	/**
	 * The cached value of the '{@link #getHeapDump() <em>Heap Dump</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDump()
	 * @generated
	 * @ordered
	 */
	protected TRCHeapDump heapDump;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCCollectionBoundaryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_COLLECTION_BOUNDARY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation getLastInvocation() {
		if (lastInvocation != null && lastInvocation.eIsProxy()) {
			InternalEObject oldLastInvocation = (InternalEObject)lastInvocation;
			lastInvocation = (TRCMethodInvocation)eResolveProxy(oldLastInvocation);
			if (lastInvocation != oldLastInvocation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION, oldLastInvocation, lastInvocation));
			}
		}
		return lastInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation basicGetLastInvocation() {
		return lastInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastInvocation(TRCMethodInvocation newLastInvocation) {
		TRCMethodInvocation oldLastInvocation = lastInvocation;
		lastInvocation = newLastInvocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION, oldLastInvocation, lastInvocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID() != TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS) return null;
		return (TRCProcess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getLastClass() {
		if (lastClass != null && lastClass.eIsProxy()) {
			InternalEObject oldLastClass = (InternalEObject)lastClass;
			lastClass = (TRCClass)eResolveProxy(oldLastClass);
			if (lastClass != oldLastClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS, oldLastClass, lastClass));
			}
		}
		return lastClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetLastClass() {
		return lastClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastClass(TRCClass newLastClass) {
		TRCClass oldLastClass = lastClass;
		lastClass = newLastClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS, oldLastClass, lastClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getLastThread() {
		if (lastThread != null && lastThread.eIsProxy()) {
			InternalEObject oldLastThread = (InternalEObject)lastThread;
			lastThread = (TRCThread)eResolveProxy(oldLastThread);
			if (lastThread != oldLastThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD, oldLastThread, lastThread));
			}
		}
		return lastThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetLastThread() {
		return lastThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastThread(TRCThread newLastThread) {
		TRCThread oldLastThread = lastThread;
		lastThread = newLastThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD, oldLastThread, lastThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getLastObject() {
		if (lastObject != null && lastObject.eIsProxy()) {
			InternalEObject oldLastObject = (InternalEObject)lastObject;
			lastObject = (TRCObject)eResolveProxy(oldLastObject);
			if (lastObject != oldLastObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT, oldLastObject, lastObject));
			}
		}
		return lastObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetLastObject() {
		return lastObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastObject(TRCObject newLastObject) {
		TRCObject oldLastObject = lastObject;
		lastObject = newLastObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT, oldLastObject, lastObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage getLastPackage() {
		if (lastPackage != null && lastPackage.eIsProxy()) {
			InternalEObject oldLastPackage = (InternalEObject)lastPackage;
			lastPackage = (TRCPackage)eResolveProxy(oldLastPackage);
			if (lastPackage != oldLastPackage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE, oldLastPackage, lastPackage));
			}
		}
		return lastPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage basicGetLastPackage() {
		return lastPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastPackage(TRCPackage newLastPackage) {
		TRCPackage oldLastPackage = lastPackage;
		lastPackage = newLastPackage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE, oldLastPackage, lastPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod getLastMethod() {
		if (lastMethod != null && lastMethod.eIsProxy()) {
			InternalEObject oldLastMethod = (InternalEObject)lastMethod;
			lastMethod = (TRCMethod)eResolveProxy(oldLastMethod);
			if (lastMethod != oldLastMethod) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD, oldLastMethod, lastMethod));
			}
		}
		return lastMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod basicGetLastMethod() {
		return lastMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastMethod(TRCMethod newLastMethod) {
		TRCMethod oldLastMethod = lastMethod;
		lastMethod = newLastMethod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD, oldLastMethod, lastMethod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump getHeapDump() {
		if (heapDump != null && heapDump.eIsProxy()) {
			InternalEObject oldHeapDump = (InternalEObject)heapDump;
			heapDump = (TRCHeapDump)eResolveProxy(oldHeapDump);
			if (heapDump != oldHeapDump) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP, oldHeapDump, heapDump));
			}
		}
		return heapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump basicGetHeapDump() {
		return heapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeapDump(TRCHeapDump newHeapDump) {
		TRCHeapDump oldHeapDump = heapDump;
		heapDump = newHeapDump;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP, oldHeapDump, heapDump));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return basicSetProcess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TRCProcess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				if (resolve) return getLastInvocation();
				return basicGetLastInvocation();
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return getProcess();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				if (resolve) return getLastClass();
				return basicGetLastClass();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				if (resolve) return getLastThread();
				return basicGetLastThread();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				if (resolve) return getLastObject();
				return basicGetLastObject();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				if (resolve) return getLastPackage();
				return basicGetLastPackage();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				if (resolve) return getLastMethod();
				return basicGetLastMethod();
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				if (resolve) return getHeapDump();
				return basicGetHeapDump();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				setLastInvocation((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				setLastClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				setLastThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				setLastObject((TRCObject)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				setLastPackage((TRCPackage)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				setLastMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				setHeapDump((TRCHeapDump)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				setLastInvocation((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				setLastClass((TRCClass)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				setLastThread((TRCThread)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				setLastObject((TRCObject)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				setLastPackage((TRCPackage)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				setLastMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				setHeapDump((TRCHeapDump)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				return lastInvocation != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				return lastClass != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				return lastThread != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				return lastObject != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				return lastPackage != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				return lastMethod != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				return heapDump != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCCollectionBoundaryImpl
