/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCGCEventImpl.java,v 1.3 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRCGC Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getTime <em>Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getTotalObjectSpace <em>Total Object Space</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getUsedObjectSpace <em>Used Object Space</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getUsedObjects <em>Used Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCGCEventImpl#getOwnerThread <em>Owner Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCGCEventImpl extends EObjectImpl implements TRCGCEvent {
	/**
	 * The default value of the '{@link #getTime() <em>Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTime() <em>Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTime()
	 * @generated
	 * @ordered
	 */
	protected double time = TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalObjectSpace() <em>Total Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalObjectSpace()
	 * @generated
	 * @ordered
	 */
	protected static final long TOTAL_OBJECT_SPACE_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTotalObjectSpace() <em>Total Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalObjectSpace()
	 * @generated
	 * @ordered
	 */
	protected long totalObjectSpace = TOTAL_OBJECT_SPACE_EDEFAULT;

	/**
	 * The default value of the '{@link #getUsedObjectSpace() <em>Used Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsedObjectSpace()
	 * @generated
	 * @ordered
	 */
	protected static final long USED_OBJECT_SPACE_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getUsedObjectSpace() <em>Used Object Space</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsedObjectSpace()
	 * @generated
	 * @ordered
	 */
	protected long usedObjectSpace = USED_OBJECT_SPACE_EDEFAULT;

	/**
	 * The default value of the '{@link #getUsedObjects() <em>Used Objects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsedObjects()
	 * @generated
	 * @ordered
	 */
	protected static final long USED_OBJECTS_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getUsedObjects() <em>Used Objects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsedObjects()
	 * @generated
	 * @ordered
	 */
	protected long usedObjects = USED_OBJECTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOwnerThread() <em>Owner Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread ownerThread;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCGCEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRCGC_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTime() {
		return time;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTime(double newTime) {
		double oldTime = time;
		time = newTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__TIME, oldTime, time));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTotalObjectSpace() {
		return totalObjectSpace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalObjectSpace(long newTotalObjectSpace) {
		long oldTotalObjectSpace = totalObjectSpace;
		totalObjectSpace = newTotalObjectSpace;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__TOTAL_OBJECT_SPACE, oldTotalObjectSpace, totalObjectSpace));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getUsedObjectSpace() {
		return usedObjectSpace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUsedObjectSpace(long newUsedObjectSpace) {
		long oldUsedObjectSpace = usedObjectSpace;
		usedObjectSpace = newUsedObjectSpace;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__USED_OBJECT_SPACE, oldUsedObjectSpace, usedObjectSpace));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getUsedObjects() {
		return usedObjects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUsedObjects(long newUsedObjects) {
		long oldUsedObjects = usedObjects;
		usedObjects = newUsedObjects;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__USED_OBJECTS, oldUsedObjects, usedObjects));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getOwnerThread() {
		if (ownerThread != null && ownerThread.eIsProxy()) {
			InternalEObject oldOwnerThread = (InternalEObject)ownerThread;
			ownerThread = (TRCThread)eResolveProxy(oldOwnerThread);
			if (ownerThread != oldOwnerThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRCGC_EVENT__OWNER_THREAD, oldOwnerThread, ownerThread));
			}
		}
		return ownerThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetOwnerThread() {
		return ownerThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerThread(TRCThread newOwnerThread) {
		TRCThread oldOwnerThread = ownerThread;
		ownerThread = newOwnerThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRCGC_EVENT__OWNER_THREAD, oldOwnerThread, ownerThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRCGC_EVENT__TIME:
				return getTime();
			case TracePackage.TRCGC_EVENT__TOTAL_OBJECT_SPACE:
				return getTotalObjectSpace();
			case TracePackage.TRCGC_EVENT__USED_OBJECT_SPACE:
				return getUsedObjectSpace();
			case TracePackage.TRCGC_EVENT__USED_OBJECTS:
				return getUsedObjects();
			case TracePackage.TRCGC_EVENT__TYPE:
				return getType();
			case TracePackage.TRCGC_EVENT__OWNER_THREAD:
				if (resolve) return getOwnerThread();
				return basicGetOwnerThread();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRCGC_EVENT__TIME:
				setTime((Double)newValue);
				return;
			case TracePackage.TRCGC_EVENT__TOTAL_OBJECT_SPACE:
				setTotalObjectSpace((Long)newValue);
				return;
			case TracePackage.TRCGC_EVENT__USED_OBJECT_SPACE:
				setUsedObjectSpace((Long)newValue);
				return;
			case TracePackage.TRCGC_EVENT__USED_OBJECTS:
				setUsedObjects((Long)newValue);
				return;
			case TracePackage.TRCGC_EVENT__TYPE:
				setType((String)newValue);
				return;
			case TracePackage.TRCGC_EVENT__OWNER_THREAD:
				setOwnerThread((TRCThread)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRCGC_EVENT__TIME:
				setTime(TIME_EDEFAULT);
				return;
			case TracePackage.TRCGC_EVENT__TOTAL_OBJECT_SPACE:
				setTotalObjectSpace(TOTAL_OBJECT_SPACE_EDEFAULT);
				return;
			case TracePackage.TRCGC_EVENT__USED_OBJECT_SPACE:
				setUsedObjectSpace(USED_OBJECT_SPACE_EDEFAULT);
				return;
			case TracePackage.TRCGC_EVENT__USED_OBJECTS:
				setUsedObjects(USED_OBJECTS_EDEFAULT);
				return;
			case TracePackage.TRCGC_EVENT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case TracePackage.TRCGC_EVENT__OWNER_THREAD:
				setOwnerThread((TRCThread)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRCGC_EVENT__TIME:
				return time != TIME_EDEFAULT;
			case TracePackage.TRCGC_EVENT__TOTAL_OBJECT_SPACE:
				return totalObjectSpace != TOTAL_OBJECT_SPACE_EDEFAULT;
			case TracePackage.TRCGC_EVENT__USED_OBJECT_SPACE:
				return usedObjectSpace != USED_OBJECT_SPACE_EDEFAULT;
			case TracePackage.TRCGC_EVENT__USED_OBJECTS:
				return usedObjects != USED_OBJECTS_EDEFAULT;
			case TracePackage.TRCGC_EVENT__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case TracePackage.TRCGC_EVENT__OWNER_THREAD:
				return ownerThread != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (time: ");
		result.append(time);
		result.append(", totalObjectSpace: ");
		result.append(totalObjectSpace);
		result.append(", usedObjectSpace: ");
		result.append(usedObjectSpace);
		result.append(", usedObjects: ");
		result.append(usedObjects);
		result.append(", type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

} //TRCGCEventImpl