/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCHeapObjectImpl.java,v 1.9 2010/12/07 21:07:54 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Heap Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl#getRefOwner <em>Ref Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl#getRefTarget <em>Ref Target</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCHeapObjectImpl extends TRCObjectImpl implements TRCHeapObject {
	/**
	 * The cached value of the '{@link #getRefOwner() <em>Ref Owner</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefOwner()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCObjectReference> refOwner;

	/**
	 * The cached value of the '{@link #getRefTarget() <em>Ref Target</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefTarget()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCObjectReference> refTarget;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCHeapObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_HEAP_OBJECT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCObjectReference> getRefOwner() {
		if (refOwner == null) {
			refOwner = new EObjectWithInverseEList<TRCObjectReference>(TRCObjectReference.class, this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TracePackage.TRC_OBJECT_REFERENCE__OWNER);
		}
		return refOwner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCObjectReference> getRefTarget() {
		if (refTarget == null) {
			refTarget = new EObjectWithInverseEList<TRCObjectReference>(TRCObjectReference.class, this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TracePackage.TRC_OBJECT_REFERENCE__TARGET);
		}
		return refTarget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRefOwner()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRefTarget()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return ((InternalEList<?>)getRefOwner()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return ((InternalEList<?>)getRefTarget()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return getRefOwner();
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return getRefTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				getRefOwner().addAll((Collection<? extends TRCObjectReference>)newValue);
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				getRefTarget().addAll((Collection<? extends TRCObjectReference>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return refOwner != null && !refOwner.isEmpty();
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return refTarget != null && !refTarget.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TRCHeapObjectImpl
