/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCInputOutputContainerImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Input Output Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl#getEntries <em>Entries</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCInputOutputContainerImpl#getInputOutputValues <em>Input Output Values</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCInputOutputContainerImpl extends EObjectImpl implements TRCInputOutputContainer {
	/**
	 * The cached value of the '{@link #getProcess() <em>Process</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcess()
	 * @generated
	 * @ordered
	 */
	protected TRCProcess process;

	/**
	 * The cached value of the '{@link #getEntries() <em>Entries</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntries()
	 * @generated
	 * @ordered
	 */
	protected EMap<TRCMethodInvocation, EList<TRCObjectValue>> entries;

	/**
	 * The cached value of the '{@link #getInputOutputValues() <em>Input Output Values</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputOutputValues()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCObjectValue> inputOutputValues;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCInputOutputContainerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_INPUT_OUTPUT_CONTAINER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (process != null && process.eIsProxy()) {
			InternalEObject oldProcess = (InternalEObject)process;
			process = (TRCProcess)eResolveProxy(oldProcess);
			if (process != oldProcess) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, oldProcess, process));
			}
		}
		return process;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess basicGetProcess() {
		return process;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		TRCProcess oldProcess = process;
		process = newProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, oldProcess, newProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != process) {
			NotificationChain msgs = null;
			if (process != null)
				msgs = ((InternalEObject)process).eInverseRemove(this, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, TRCProcess.class, msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EMap<TRCMethodInvocation, EList<TRCObjectValue>> getEntries() {
		if (entries == null) {
			entries = new EcoreEMap<TRCMethodInvocation,EList<TRCObjectValue>>(TracePackage.Literals.TRC_INPUT_OUTPUT_ENTRY, TRCInputOutputEntryImpl.class, this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES);
		}
		return entries;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 * @deprecated The TRCObjectValue is contained by TRCInputOutputEntry
	 */
	public EList getInputOutputValues() {
		if (inputOutputValues == null) {
			inputOutputValues = new EObjectWithInverseEList(TRCObjectValue.class, this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TracePackage.TRC_OBJECT_VALUE__CONTAINER);
		}
		if(this.eResource()!=null)
		{
			// if this list is accessed set modified to true so it would ask to be be saved (this list is transient)
			this.eResource().setModified(true);
		}
		return inputOutputValues;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				if (process != null)
					msgs = ((InternalEObject)process).eInverseRemove(this, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, TRCProcess.class, msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getEntries()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInputOutputValues()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				return basicSetProcess(null, msgs);
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				return ((InternalEList<?>)getEntries()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				return ((InternalEList<?>)getInputOutputValues()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				if (resolve) return getProcess();
				return basicGetProcess();
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				if (coreType) return getEntries();
				else return getEntries().map();
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				return getInputOutputValues();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				((EStructuralFeature.Setting)getEntries()).set(newValue);
				return;
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				getInputOutputValues().clear();
				getInputOutputValues().addAll((Collection<? extends TRCObjectValue>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				getEntries().clear();
				return;
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				getInputOutputValues().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS:
				return process != null;
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__ENTRIES:
				return entries != null && !entries.isEmpty();
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES:
				return inputOutputValues != null && !inputOutputValues.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TRCInputOutputContainerImpl
