/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCLockAccessImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Lock Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl#getRequireTime <em>Require Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl#getRequestTime <em>Request Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl#getReleaseTime <em>Release Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl#getAtLine <em>At Line</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLockAccessImpl#getOnObject <em>On Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCLockAccessImpl extends EObjectImpl implements TRCLockAccess {
	/**
	 * The default value of the '{@link #getRequireTime() <em>Require Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequireTime()
	 * @generated
	 * @ordered
	 */
	protected static final double REQUIRE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getRequireTime() <em>Require Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequireTime()
	 * @generated
	 * @ordered
	 */
	protected double requireTime = REQUIRE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getRequestTime() <em>Request Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequestTime()
	 * @generated
	 * @ordered
	 */
	protected static final double REQUEST_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getRequestTime() <em>Request Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequestTime()
	 * @generated
	 * @ordered
	 */
	protected double requestTime = REQUEST_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReleaseTime() <em>Release Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReleaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double RELEASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getReleaseTime() <em>Release Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReleaseTime()
	 * @generated
	 * @ordered
	 */
	protected double releaseTime = RELEASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected static final int AT_LINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected int atLine = AT_LINE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOnObject() <em>On Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject onObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCLockAccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_LOCK_ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getRequireTime() {
		return requireTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRequireTime(double newRequireTime) {
		double oldRequireTime = requireTime;
		requireTime = newRequireTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LOCK_ACCESS__REQUIRE_TIME, oldRequireTime, requireTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getRequestTime() {
		return requestTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRequestTime(double newRequestTime) {
		double oldRequestTime = requestTime;
		requestTime = newRequestTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LOCK_ACCESS__REQUEST_TIME, oldRequestTime, requestTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getReleaseTime() {
		return releaseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReleaseTime(double newReleaseTime) {
		double oldReleaseTime = releaseTime;
		releaseTime = newReleaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LOCK_ACCESS__RELEASE_TIME, oldReleaseTime, releaseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAtLine() {
		return atLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAtLine(int newAtLine) {
		int oldAtLine = atLine;
		atLine = newAtLine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LOCK_ACCESS__AT_LINE, oldAtLine, atLine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getOnObject() {
		if (onObject != null && onObject.eIsProxy()) {
			InternalEObject oldOnObject = (InternalEObject)onObject;
			onObject = (TRCObject)eResolveProxy(oldOnObject);
			if (onObject != oldOnObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_LOCK_ACCESS__ON_OBJECT, oldOnObject, onObject));
			}
		}
		return onObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetOnObject() {
		return onObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOnObject(TRCObject newOnObject) {
		TRCObject oldOnObject = onObject;
		onObject = newOnObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LOCK_ACCESS__ON_OBJECT, oldOnObject, onObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_LOCK_ACCESS__REQUIRE_TIME:
				return getRequireTime();
			case TracePackage.TRC_LOCK_ACCESS__REQUEST_TIME:
				return getRequestTime();
			case TracePackage.TRC_LOCK_ACCESS__RELEASE_TIME:
				return getReleaseTime();
			case TracePackage.TRC_LOCK_ACCESS__AT_LINE:
				return getAtLine();
			case TracePackage.TRC_LOCK_ACCESS__ON_OBJECT:
				if (resolve) return getOnObject();
				return basicGetOnObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_LOCK_ACCESS__REQUIRE_TIME:
				setRequireTime((Double)newValue);
				return;
			case TracePackage.TRC_LOCK_ACCESS__REQUEST_TIME:
				setRequestTime((Double)newValue);
				return;
			case TracePackage.TRC_LOCK_ACCESS__RELEASE_TIME:
				setReleaseTime((Double)newValue);
				return;
			case TracePackage.TRC_LOCK_ACCESS__AT_LINE:
				setAtLine((Integer)newValue);
				return;
			case TracePackage.TRC_LOCK_ACCESS__ON_OBJECT:
				setOnObject((TRCObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LOCK_ACCESS__REQUIRE_TIME:
				setRequireTime(REQUIRE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_LOCK_ACCESS__REQUEST_TIME:
				setRequestTime(REQUEST_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_LOCK_ACCESS__RELEASE_TIME:
				setReleaseTime(RELEASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_LOCK_ACCESS__AT_LINE:
				setAtLine(AT_LINE_EDEFAULT);
				return;
			case TracePackage.TRC_LOCK_ACCESS__ON_OBJECT:
				setOnObject((TRCObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LOCK_ACCESS__REQUIRE_TIME:
				return requireTime != REQUIRE_TIME_EDEFAULT;
			case TracePackage.TRC_LOCK_ACCESS__REQUEST_TIME:
				return requestTime != REQUEST_TIME_EDEFAULT;
			case TracePackage.TRC_LOCK_ACCESS__RELEASE_TIME:
				return releaseTime != RELEASE_TIME_EDEFAULT;
			case TracePackage.TRC_LOCK_ACCESS__AT_LINE:
				return atLine != AT_LINE_EDEFAULT;
			case TracePackage.TRC_LOCK_ACCESS__ON_OBJECT:
				return onObject != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (requireTime: ");
		result.append(requireTime);
		result.append(", requestTime: ");
		result.append(requestTime);
		result.append(", releaseTime: ");
		result.append(releaseTime);
		result.append(", atLine: ");
		result.append(atLine);
		result.append(')');
		return result.toString();
	}

} //TRCLockAccessImpl
