/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCMethodInvocationImpl.java,v 1.12 2010/12/07 21:07:54 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getMethod <em>Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getInvokedBy <em>Invoked By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getInvokes <em>Invokes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getThread <em>Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodInvocationImpl#getOwningObject <em>Owning Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCMethodInvocationImpl extends EObjectImpl implements TRCMethodInvocation {
	/**
	 * The cached value of the '{@link #getMethod() <em>Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethod()
	 * @generated
	 * @ordered
	 */
	protected TRCMethod method;

	/**
	 * The cached value of the '{@link #getInvokedBy() <em>Invoked By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvokedBy()
	 * @generated
	 * @ordered
	 */
	protected TRCMethodInvocation invokedBy;

	/**
	 * The cached value of the '{@link #getInvokes() <em>Invokes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvokes()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCMethodInvocation> invokes;

	/**
	 * The cached value of the '{@link #getThread() <em>Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread thread;

	/**
	 * The cached value of the '{@link #getOwningObject() <em>Owning Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwningObject()
	 * @generated
	 * @ordered
	 */
	protected TRCTraceObject owningObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_METHOD_INVOCATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject getOwningObject() {
		if (owningObject != null && owningObject.eIsProxy()) {
			InternalEObject oldOwningObject = (InternalEObject)owningObject;
			owningObject = (TRCTraceObject)eResolveProxy(oldOwningObject);
			if (owningObject != oldOwningObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT, oldOwningObject, owningObject));
			}
		}
		return owningObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject basicGetOwningObject() {
		return owningObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwningObject(TRCTraceObject newOwningObject) {
		TRCTraceObject oldOwningObject = owningObject;
		owningObject = newOwningObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT, oldOwningObject, owningObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				if (method != null)
					msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
				return basicSetMethod((TRCMethod)otherEnd, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				if (invokedBy != null)
					msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
				return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInvokes()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				return basicSetMethod(null, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				return basicSetInvokedBy(null, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return ((InternalEList<?>)getInvokes()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return basicSetProcess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				return getMethod();
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return getInvokes();
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return getProcess();
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection<? extends TRCMethodInvocation>)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_METHOD_INVOCATION__METHOD:
				return method != null;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_METHOD_INVOCATION__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_METHOD_INVOCATION__THREAD:
				return thread != null;
			case TracePackage.TRC_METHOD_INVOCATION__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_METHOD_INVOCATION__OWNING_OBJECT:
				return owningObject != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod getMethod() {
		return method;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMethod(TRCMethod newMethod, NotificationChain msgs) {
		TRCMethod oldMethod = method;
		method = newMethod;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__METHOD, oldMethod, newMethod);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMethod(TRCMethod newMethod) {
		if (newMethod != method) {
			NotificationChain msgs = null;
			if (method != null)
				msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
			if (newMethod != null)
				msgs = ((InternalEObject)newMethod).eInverseAdd(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
			msgs = basicSetMethod(newMethod, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__METHOD, newMethod, newMethod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation getInvokedBy() {
		if (invokedBy != null && invokedBy.eIsProxy()) {
			InternalEObject oldInvokedBy = (InternalEObject)invokedBy;
			invokedBy = (TRCMethodInvocation)eResolveProxy(oldInvokedBy);
			if (invokedBy != oldInvokedBy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, oldInvokedBy, invokedBy));
			}
		}
		return invokedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation basicGetInvokedBy() {
		return invokedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvokedBy(TRCMethodInvocation newInvokedBy, NotificationChain msgs) {
		TRCMethodInvocation oldInvokedBy = invokedBy;
		invokedBy = newInvokedBy;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, oldInvokedBy, newInvokedBy);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvokedBy(TRCMethodInvocation newInvokedBy) {
		if (newInvokedBy != invokedBy) {
			NotificationChain msgs = null;
			if (invokedBy != null)
				msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
			if (newInvokedBy != null)
				msgs = ((InternalEObject)newInvokedBy).eInverseAdd(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
			msgs = basicSetInvokedBy(newInvokedBy, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY, newInvokedBy, newInvokedBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCMethodInvocation> getInvokes() {
		if (invokes == null) {
			invokes = new EObjectWithInverseResolvingEList<TRCMethodInvocation>(TRCMethodInvocation.class, this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TracePackage.TRC_METHOD_INVOCATION__INVOKED_BY);
		}
		return invokes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getThread() {
		if (thread != null && thread.eIsProxy()) {
			InternalEObject oldThread = (InternalEObject)thread;
			thread = (TRCThread)eResolveProxy(oldThread);
			if (thread != oldThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD_INVOCATION__THREAD, oldThread, thread));
			}
		}
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetThread() {
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setThread(TRCThread newThread) {
		TRCThread oldThread = thread;
		thread = newThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__THREAD, oldThread, thread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID() != TracePackage.TRC_METHOD_INVOCATION__PROCESS) return null;
		return (TRCProcess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_METHOD_INVOCATION__PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_METHOD_INVOCATION__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_INVOCATION__PROCESS, newProcess, newProcess));
	}

} //TRCMethodInvocationImpl
