/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectAllocationSiteImpl.java,v 1.11 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Allocation Site</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getAtLine <em>At Line</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getTRCObjectAllocationSitesEntry <em>TRC Object Allocation Sites Entry</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getAllocatedObject <em>Allocated Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectAllocationSiteImpl extends EObjectImpl implements TRCObjectAllocationSite {
	/**
	 * The default value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected static final int AT_LINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected int atLine = AT_LINE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAllocatedObject() <em>Allocated Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllocatedObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject allocatedObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectAllocationSiteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_OBJECT_ALLOCATION_SITE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAtLine() {
		return atLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAtLine(int newAtLine) {
		int oldAtLine = atLine;
		atLine = newAtLine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE, oldAtLine, atLine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> getTRCObjectAllocationSitesEntry() {
		if (eContainerFeatureID() != TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY) return null;
		return (Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>>)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTRCObjectAllocationSitesEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> newTRCObjectAllocationSitesEntry, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTRCObjectAllocationSitesEntry, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTRCObjectAllocationSitesEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> newTRCObjectAllocationSitesEntry) {
		if (newTRCObjectAllocationSitesEntry != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY && newTRCObjectAllocationSitesEntry != null)) {
			if (EcoreUtil.isAncestor(this, (EObject)newTRCObjectAllocationSitesEntry))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTRCObjectAllocationSitesEntry != null)
				msgs = ((InternalEObject)newTRCObjectAllocationSitesEntry).eInverseAdd(this, TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE, Map.Entry.class, msgs);
			msgs = basicSetTRCObjectAllocationSitesEntry(newTRCObjectAllocationSitesEntry, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, newTRCObjectAllocationSitesEntry, newTRCObjectAllocationSitesEntry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getAllocatedObject() {
		if (allocatedObject != null && allocatedObject.eIsProxy()) {
			InternalEObject oldAllocatedObject = (InternalEObject)allocatedObject;
			allocatedObject = (TRCObject)eResolveProxy(oldAllocatedObject);
			if (allocatedObject != oldAllocatedObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT, oldAllocatedObject, allocatedObject));
			}
		}
		return allocatedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetAllocatedObject() {
		return allocatedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAllocatedObject(TRCObject newAllocatedObject) {
		TRCObject oldAllocatedObject = allocatedObject;
		allocatedObject = newAllocatedObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT, oldAllocatedObject, allocatedObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTRCObjectAllocationSitesEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>>)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return basicSetTRCObjectAllocationSitesEntry(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE, Map.Entry.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				return getAtLine();
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return getTRCObjectAllocationSitesEntry();
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				if (resolve) return getAllocatedObject();
				return basicGetAllocatedObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				setAtLine((Integer)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				setTRCObjectAllocationSitesEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>>)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				setAllocatedObject((TRCObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				setAtLine(AT_LINE_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				setTRCObjectAllocationSitesEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>>)null);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				setAllocatedObject((TRCObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				return atLine != AT_LINE_EDEFAULT;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return getTRCObjectAllocationSitesEntry() != null;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				return allocatedObject != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (atLine: ");
		result.append(atLine);
		result.append(')');
		return result.toString();
	}

} //TRCObjectAllocationSiteImpl
