/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectImpl.java,v 1.13 2010/12/08 18:45:46 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl#getSize <em>Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl#getIsA <em>Is A</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectImpl#getCumulativeSize <em>Cumulative Size</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectImpl extends EObjectImpl implements TRCObject {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final long ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected long id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final int SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected int size = SIZE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getIsA() <em>Is A</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsA()
	 * @generated
	 * @ordered
	 */
	protected TRCClass isA;

	/**
	 * The default value of the '{@link #getCumulativeSize() <em>Cumulative Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeSize()
	 * @generated
	 * @ordered
	 */
	protected static final int CUMULATIVE_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCumulativeSize() <em>Cumulative Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeSize()
	 * @generated
	 * @ordered
	 */
	protected int cumulativeSize = CUMULATIVE_SIZE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_OBJECT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(long newId) {
		long oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(int newSize) {
		int oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getIsA() {
		return isA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIsA(TRCClass newIsA, NotificationChain msgs) {
		TRCClass oldIsA = isA;
		isA = newIsA;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__IS_A, oldIsA, newIsA);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsA(TRCClass newIsA) {
		if (newIsA != isA) {
			NotificationChain msgs = null;
			if (isA != null)
				msgs = ((InternalEObject)isA).eInverseRemove(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
			if (newIsA != null)
				msgs = ((InternalEObject)newIsA).eInverseAdd(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
			msgs = basicSetIsA(newIsA, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__IS_A, newIsA, newIsA));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID() != TracePackage.TRC_OBJECT__PROCESS) return null;
		return (TRCProcess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_OBJECT__PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_OBJECT__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__OBJECTS, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCumulativeSize() {
		return cumulativeSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeSize(int newCumulativeSize) {
		int oldCumulativeSize = cumulativeSize;
		cumulativeSize = newCumulativeSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT__CUMULATIVE_SIZE, oldCumulativeSize, cumulativeSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__IS_A:
				if (isA != null)
					msgs = ((InternalEObject)isA).eInverseRemove(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
				return basicSetIsA((TRCClass)otherEnd, msgs);
			case TracePackage.TRC_OBJECT__PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__IS_A:
				return basicSetIsA(null, msgs);
			case TracePackage.TRC_OBJECT__PROCESS:
				return basicSetProcess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_OBJECT__PROCESS:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_PROCESS__OBJECTS, TRCProcess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__ID:
				return getId();
			case TracePackage.TRC_OBJECT__SIZE:
				return getSize();
			case TracePackage.TRC_OBJECT__IS_A:
				return getIsA();
			case TracePackage.TRC_OBJECT__PROCESS:
				return getProcess();
			case TracePackage.TRC_OBJECT__CUMULATIVE_SIZE:
				return getCumulativeSize();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__ID:
				setId((Long)newValue);
				return;
			case TracePackage.TRC_OBJECT__SIZE:
				setSize((Integer)newValue);
				return;
			case TracePackage.TRC_OBJECT__IS_A:
				setIsA((TRCClass)newValue);
				return;
			case TracePackage.TRC_OBJECT__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_OBJECT__CUMULATIVE_SIZE:
				setCumulativeSize((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT__IS_A:
				setIsA((TRCClass)null);
				return;
			case TracePackage.TRC_OBJECT__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_OBJECT__CUMULATIVE_SIZE:
				setCumulativeSize(CUMULATIVE_SIZE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_OBJECT__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_OBJECT__IS_A:
				return isA != null;
			case TracePackage.TRC_OBJECT__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_OBJECT__CUMULATIVE_SIZE:
				return cumulativeSize != CUMULATIVE_SIZE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", size: ");
		result.append(size);
		result.append(", cumulativeSize: ");
		result.append(cumulativeSize);
		result.append(')');
		return result.toString();
	}

} //TRCObjectImpl
