/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectReferenceImpl.java,v 1.12 2010/12/07 21:07:54 jcayne Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl#getHeapDump <em>Heap Dump</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl#getOwner <em>Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectReferenceImpl#getTarget <em>Target</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectReferenceImpl extends EObjectImpl implements TRCObjectReference {
	/**
	 * The cached value of the '{@link #getOwner() <em>Owner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwner()
	 * @generated
	 * @ordered
	 */
	protected TRCHeapObject owner;

	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected TRCHeapObject target;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_OBJECT_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump getHeapDump() {
		if (eContainerFeatureID() != TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP) return null;
		return (TRCHeapDump)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHeapDump(TRCHeapDump newHeapDump, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newHeapDump, TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeapDump(TRCHeapDump newHeapDump) {
		if (newHeapDump != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP && newHeapDump != null)) {
			if (EcoreUtil.isAncestor(this, newHeapDump))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newHeapDump != null)
				msgs = ((InternalEObject)newHeapDump).eInverseAdd(this, TracePackage.TRC_HEAP_DUMP__REFERENCES, TRCHeapDump.class, msgs);
			msgs = basicSetHeapDump(newHeapDump, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP, newHeapDump, newHeapDump));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapObject getOwner() {
		return owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwner(TRCHeapObject newOwner, NotificationChain msgs) {
		TRCHeapObject oldOwner = owner;
		owner = newOwner;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_REFERENCE__OWNER, oldOwner, newOwner);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwner(TRCHeapObject newOwner) {
		if (newOwner != owner) {
			NotificationChain msgs = null;
			if (owner != null)
				msgs = ((InternalEObject)owner).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TRCHeapObject.class, msgs);
			if (newOwner != null)
				msgs = ((InternalEObject)newOwner).eInverseAdd(this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TRCHeapObject.class, msgs);
			msgs = basicSetOwner(newOwner, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_REFERENCE__OWNER, newOwner, newOwner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapObject getTarget() {
		return target;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTarget(TRCHeapObject newTarget, NotificationChain msgs) {
		TRCHeapObject oldTarget = target;
		target = newTarget;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_REFERENCE__TARGET, oldTarget, newTarget);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTarget(TRCHeapObject newTarget) {
		if (newTarget != target) {
			NotificationChain msgs = null;
			if (target != null)
				msgs = ((InternalEObject)target).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TRCHeapObject.class, msgs);
			if (newTarget != null)
				msgs = ((InternalEObject)newTarget).eInverseAdd(this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TRCHeapObject.class, msgs);
			msgs = basicSetTarget(newTarget, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_REFERENCE__TARGET, newTarget, newTarget));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetHeapDump((TRCHeapDump)otherEnd, msgs);
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				if (owner != null)
					msgs = ((InternalEObject)owner).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TRCHeapObject.class, msgs);
				return basicSetOwner((TRCHeapObject)otherEnd, msgs);
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				if (target != null)
					msgs = ((InternalEObject)target).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TRCHeapObject.class, msgs);
				return basicSetTarget((TRCHeapObject)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				return basicSetHeapDump(null, msgs);
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				return basicSetOwner(null, msgs);
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				return basicSetTarget(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_HEAP_DUMP__REFERENCES, TRCHeapDump.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				return getHeapDump();
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				return getOwner();
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				return getTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				setHeapDump((TRCHeapDump)newValue);
				return;
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				setOwner((TRCHeapObject)newValue);
				return;
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				setTarget((TRCHeapObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				setHeapDump((TRCHeapDump)null);
				return;
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				setOwner((TRCHeapObject)null);
				return;
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				setTarget((TRCHeapObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP:
				return getHeapDump() != null;
			case TracePackage.TRC_OBJECT_REFERENCE__OWNER:
				return owner != null;
			case TracePackage.TRC_OBJECT_REFERENCE__TARGET:
				return target != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCObjectReferenceImpl
