/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCProcessImpl.java,v 1.10 2009/05/05 15:46:17 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCProcessImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getPid <em>Pid</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getLastEventTime <em>Last Event Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInitFinishedTime <em>Init Finished Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getReferencePointerSize <em>Reference Pointer Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCpuSampleResolution <em>Cpu Sample Resolution</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getThreadStates <em>Thread States</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getPrecision <em>Precision</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getLanguages <em>Languages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getThreads <em>Threads</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getPackages <em>Packages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getClassClass <em>Class Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectionBoundaryPoints <em>Collection Boundary Points</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getClassLoaders <em>Class Loaders</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getSourceInfos <em>Source Infos</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getObjects <em>Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getHeapDumps <em>Heap Dumps</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInputOutputContainer <em>Input Output Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getMethodLockAccessEntries <em>Method Lock Access Entries</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getAllocationSitesEntries <em>Allocation Sites Entries</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getGcEvents <em>Gc Events</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCProcessImpl extends AbstractTRCProcessImpl implements TRCProcess {
	private TRCProcessSnapshot _currentSnapshot;
	private TRCProcessSnapshot _previousSnapshot;
	/**
	 *
	 */
	public int computeDelta(IDelta delta) {
		TRCProcessSnapshot delta1 = (TRCProcessSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			delta1.baseTime = 0;
			delta1.calls = 0;
			delta1.collectedInstances = 0;
			delta1.collectedSize = 0;
			delta1.cumulativeTime = 0;
			delta1.inheritedBaseTime = 0;
			delta1.inheritedCalls = 0;
			delta1.inheritedCumulativeTime = 0;
			delta1.totalInstances = 0;
			delta1.totalSize = 0;
	
			return -1;
		}
	
		delta1.baseTime = _currentSnapshot.baseTime - _previousSnapshot.baseTime;
		delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
		delta1.collectedInstances =
			_currentSnapshot.collectedInstances
				- _previousSnapshot.collectedInstances;
		delta1.collectedSize =
			_currentSnapshot.collectedSize - _previousSnapshot.collectedSize;
		delta1.cumulativeTime =
			_currentSnapshot.cumulativeTime - _previousSnapshot.cumulativeTime;
		delta1.inheritedBaseTime =
			_currentSnapshot.inheritedBaseTime
				- _previousSnapshot.inheritedBaseTime;
		delta1.inheritedCalls =
			_currentSnapshot.inheritedCalls - _previousSnapshot.inheritedCalls;
		delta1.inheritedCumulativeTime =
			_currentSnapshot.inheritedCumulativeTime
				- _previousSnapshot.inheritedCumulativeTime;
		delta1.totalInstances =
			_currentSnapshot.totalInstances - _previousSnapshot.totalInstances;
		delta1.totalSize =
			_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
		return 1;
	}
	public int computeDelta(IDelta delta, int featureID) {
		TRCProcessSnapshot delta1 = (TRCProcessSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			switch (featureID) {
				case TracePackage.TRC_PROCESS__BASE_TIME :
					delta1.baseTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__CUMULATIVE_TIME :
					delta1.cumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__CALLS :
					delta1.calls = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_CALLS :
					delta1.inheritedCalls = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME :
					delta1.inheritedBaseTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME :
					delta1.inheritedCumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__TOTAL_SIZE :
					delta1.totalSize = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__TOTAL_INSTANCES :
					delta1.totalInstances = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__COLLECTED_SIZE :
					delta1.collectedSize = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES :
					delta1.collectedInstances = 0;
	
					break;
			}
	
			return -1;
		}
	
		switch (featureID) {
			case TracePackage.TRC_PROCESS__BASE_TIME :
				delta1.baseTime =
					_currentSnapshot.baseTime - _previousSnapshot.baseTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME :
				delta1.cumulativeTime =
					_currentSnapshot.cumulativeTime
						- _previousSnapshot.cumulativeTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__CALLS :
				delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_CALLS :
				delta1.inheritedCalls =
					_currentSnapshot.inheritedCalls
						- _previousSnapshot.inheritedCalls;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME :
				delta1.inheritedBaseTime =
					_currentSnapshot.inheritedBaseTime
						- _previousSnapshot.inheritedBaseTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME :
				delta1.inheritedCumulativeTime =
					_currentSnapshot.inheritedCumulativeTime
						- _previousSnapshot.inheritedCumulativeTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__TOTAL_SIZE :
				delta1.totalSize =
					_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
				break;
	
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES :
				delta1.totalInstances =
					_currentSnapshot.totalInstances
						- _previousSnapshot.totalInstances;
	
				break;
	
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE :
				delta1.collectedSize =
					_currentSnapshot.collectedSize
						- _previousSnapshot.collectedSize;
	
				break;
	
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES :
				delta1.collectedInstances =
					_currentSnapshot.collectedInstances
						- _previousSnapshot.collectedInstances;
	
				break;
		}
	
		return 1;
	}
	/**
	 *
	 */
	public void removeSnapshot() {
		_currentSnapshot = null;
		_previousSnapshot = null;
	}
	/**
	 *
	 */
	public ISnapshot retrieveSnapshot() {
		if(_currentSnapshot==null)
		{
			takeSnapshot();
		}
		return _currentSnapshot;
	}
	/**
	 *
	 */
	public void takeSnapshot() {
		TRCProcessSnapshot temp = _previousSnapshot;
	
		_previousSnapshot = _currentSnapshot;
		_currentSnapshot = temp;
	
		if (_currentSnapshot == null) {
			_currentSnapshot = new TRCProcessSnapshot();
		}
	
		_currentSnapshot.baseTime = baseTime;
		_currentSnapshot.calls = calls;
		_currentSnapshot.collectedInstances = collectedInstances;
		_currentSnapshot.collectedSize = collectedSize;
		_currentSnapshot.cumulativeTime = cumulativeTime;
		_currentSnapshot.inheritedBaseTime = inheritedBaseTime;
		_currentSnapshot.inheritedCalls = inheritedCalls;
		_currentSnapshot.inheritedCumulativeTime = inheritedCumulativeTime;
		_currentSnapshot.totalInstances = totalInstances;
		_currentSnapshot.totalSize = totalSize;
		_currentSnapshot.totalCpuTime = totalCpuTime;
	}
	/**
	 * @author slavescu
	 */
	public static class TRCProcessSnapshot implements IDelta,ISnapshot {
		protected double baseTime = BASE_TIME_EDEFAULT;
		protected int calls = CALLS_EDEFAULT;
		protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;
		protected int collectedSize = COLLECTED_SIZE_EDEFAULT;
		protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;
		protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;
		protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;
		protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;
		protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;
		protected int totalSize = TOTAL_SIZE_EDEFAULT;
		protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;
	
	
		public Object get(int featureID) {
			switch (featureID) {
				case TracePackage.TRC_PROCESS__BASE_TIME:
					return new Double(getBaseTime());
				case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
					return new Double(getCumulativeTime());
				case TracePackage.TRC_PROCESS__CALLS:
					return new Integer(getCalls());
				case TracePackage.TRC_PROCESS__INHERITED_CALLS:
					return new Integer(getInheritedCalls());
				case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
					return new Double(getInheritedBaseTime());
				case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
					return new Double(getInheritedCumulativeTime());
				case TracePackage.TRC_PROCESS__TOTAL_SIZE:
					return new Integer(getTotalSize());
				case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
					return new Integer(getTotalInstances());
				case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
					return new Integer(getCollectedSize());
				case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
					return new Integer(getCollectedInstances());
				case TracePackage.TRC_PROCESS__TOTAL_CPU_TIME:
					return new Double(getTotalCpuTime());
			}
			return null;
		}
	
		public double getBaseTime() {
			return baseTime;
		}
	
		public int getCalls() {
			return calls;
		}
	
		public int getCollectedInstances() {
			return collectedInstances;
		}
	
		public int getCollectedSize() {
			return collectedSize;
		}
	
		public double getCumulativeTime() {
			return cumulativeTime;
		}
	
		public double getInheritedBaseTime() {
			return inheritedBaseTime;
		}
	
		public int getInheritedCalls() {
			return inheritedCalls;
		}
	
		public int getTotalInstances() {
			return totalInstances;
		}
	
		public int getTotalSize() {
			return totalSize;
		}
	
		public double getInheritedCumulativeTime() {
			return inheritedCumulativeTime;
		}
	
		/**
		 * @return Returns the totalCpuTime.
		 */
		public double getTotalCpuTime() {
			return totalCpuTime;
		}
		/**
		 * @param totalCpuTime The totalCpuTime to set.
		 */
		public void setTotalCpuTime(double totalCpuTime) {
			this.totalCpuTime = totalCpuTime;
		}
	}
	/**
	 * The default value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected static final int PID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected int pid = PID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastEventTime() <em>Last Event Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastEventTime()
	 * @generated
	 * @ordered
	 */
	protected static final double LAST_EVENT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLastEventTime() <em>Last Event Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastEventTime()
	 * @generated
	 * @ordered
	 */
	protected double lastEventTime = LAST_EVENT_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInitFinishedTime() <em>Init Finished Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitFinishedTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INIT_FINISHED_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInitFinishedTime() <em>Init Finished Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitFinishedTime()
	 * @generated
	 * @ordered
	 */
	protected double initFinishedTime = INIT_FINISHED_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected int calls = CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int INHERITED_CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected int totalSize = TOTAL_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected int collectedSize = COLLECTED_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getReferencePointerSize() <em>Reference Pointer Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferencePointerSize()
	 * @generated
	 * @ordered
	 */
	protected static final short REFERENCE_POINTER_SIZE_EDEFAULT = 4;

	/**
	 * The cached value of the '{@link #getReferencePointerSize() <em>Reference Pointer Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferencePointerSize()
	 * @generated
	 * @ordered
	 */
	protected short referencePointerSize = REFERENCE_POINTER_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCpuSampleResolution() <em>Cpu Sample Resolution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuSampleResolution()
	 * @generated
	 * @ordered
	 */
	protected static final double CPU_SAMPLE_RESOLUTION_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCpuSampleResolution() <em>Cpu Sample Resolution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuSampleResolution()
	 * @generated
	 * @ordered
	 */
	protected double cpuSampleResolution = CPU_SAMPLE_RESOLUTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getThreadStates() <em>Thread States</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadStates()
	 * @generated
	 * @ordered
	 */
	protected EList<String> threadStates;

	/**
	 * The default value of the '{@link #getPrecision() <em>Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrecision()
	 * @generated
	 * @ordered
	 */
	protected static final long PRECISION_EDEFAULT = 1L;

	/**
	 * The cached value of the '{@link #getPrecision() <em>Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrecision()
	 * @generated
	 * @ordered
	 */
	protected long precision = PRECISION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getLanguages() <em>Languages</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguages()
	 * @generated
	 * @ordered
	 */
	protected EList<String> languages;

	/**
	 * The cached value of the '{@link #getThreads() <em>Threads</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreads()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCThread> threads;

	/**
	 * The cached value of the '{@link #getPackages() <em>Packages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackages()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCPackage> packages;

	/**
	 * The cached value of the '{@link #getClassClass() <em>Class Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassClass()
	 * @generated
	 * @ordered
	 */
	protected TRCClass classClass;

	/**
	 * The cached value of the '{@link #getCollectionBoundaryPoints() <em>Collection Boundary Points</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionBoundaryPoints()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCCollectionBoundary> collectionBoundaryPoints;

	/**
	 * The cached value of the '{@link #getClassLoaders() <em>Class Loaders</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassLoaders()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCClassLoader> classLoaders;

	/**
	 * The cached value of the '{@link #getSourceInfos() <em>Source Infos</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfos()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCSourceInfo> sourceInfos;

	/**
	 * The cached value of the '{@link #getObjects() <em>Objects</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObjects()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCObject> objects;

	/**
	 * The cached value of the '{@link #getHeapDumps() <em>Heap Dumps</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDumps()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCHeapDump> heapDumps;

	/**
	 * The cached value of the '{@link #getInvocations() <em>Invocations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCMethodInvocation> invocations;

	/**
	 * The cached value of the '{@link #getInputOutputContainer() <em>Input Output Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputOutputContainer()
	 * @generated
	 * @ordered
	 */
	protected TRCInputOutputContainer inputOutputContainer;

	/**
	 * The cached value of the '{@link #getMethodLockAccessEntries() <em>Method Lock Access Entries</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethodLockAccessEntries()
	 * @generated
	 * @ordered
	 */
	protected EMap<TRCMethodInvocation, EList<TRCLockAccess>> methodLockAccessEntries;

	/**
	 * The cached value of the '{@link #getAllocationSitesEntries() <em>Allocation Sites Entries</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllocationSitesEntries()
	 * @generated
	 * @ordered
	 */
	protected EMap<TRCMethodInvocation, EList<TRCObjectAllocationSite>> allocationSitesEntries;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCAnnotation> annotations;

	/**
	 * The cached value of the '{@link #getGcEvents() <em>Gc Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGcEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCGCEvent> gcEvents;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_PROCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPid() {
		return pid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPid(int newPid) {
		int oldPid = pid;
		pid = newPid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__PID, oldPid, pid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime() {
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime) {
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLastEventTime() {
		return lastEventTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastEventTime(double newLastEventTime) {
		double oldLastEventTime = lastEventTime;
		lastEventTime = newLastEventTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__LAST_EVENT_TIME, oldLastEventTime, lastEventTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInitFinishedTime() {
		return initFinishedTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitFinishedTime(double newInitFinishedTime) {
		double oldInitFinishedTime = initFinishedTime;
		initFinishedTime = newInitFinishedTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INIT_FINISHED_TIME, oldInitFinishedTime, initFinishedTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCalls() {
		return calls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalls(int newCalls) {
		int oldCalls = calls;
		calls = newCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CALLS, oldCalls, calls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInheritedCalls() {
		return inheritedCalls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCalls(int newInheritedCalls) {
		int oldInheritedCalls = inheritedCalls;
		inheritedCalls = newInheritedCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_CALLS, oldInheritedCalls, inheritedCalls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedBaseTime() {
		return inheritedBaseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedBaseTime(double newInheritedBaseTime) {
		double oldInheritedBaseTime = inheritedBaseTime;
		inheritedBaseTime = newInheritedBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_BASE_TIME, oldInheritedBaseTime, inheritedBaseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedCumulativeTime() {
		return inheritedCumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCumulativeTime(double newInheritedCumulativeTime) {
		double oldInheritedCumulativeTime = inheritedCumulativeTime;
		inheritedCumulativeTime = newInheritedCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME, oldInheritedCumulativeTime, inheritedCumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalSize() {
		return totalSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalSize(int newTotalSize) {
		int oldTotalSize = totalSize;
		totalSize = newTotalSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__TOTAL_SIZE, oldTotalSize, totalSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalInstances() {
		return totalInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalInstances(int newTotalInstances) {
		int oldTotalInstances = totalInstances;
		totalInstances = newTotalInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__TOTAL_INSTANCES, oldTotalInstances, totalInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedSize() {
		return collectedSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedSize(int newCollectedSize) {
		int oldCollectedSize = collectedSize;
		collectedSize = newCollectedSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__COLLECTED_SIZE, oldCollectedSize, collectedSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedInstances() {
		return collectedInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedInstances(int newCollectedInstances) {
		int oldCollectedInstances = collectedInstances;
		collectedInstances = newCollectedInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__COLLECTED_INSTANCES, oldCollectedInstances, collectedInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getReferencePointerSize() {
		return referencePointerSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferencePointerSize(short newReferencePointerSize) {
		short oldReferencePointerSize = referencePointerSize;
		referencePointerSize = newReferencePointerSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE, oldReferencePointerSize, referencePointerSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getThreadStates() {
		if (threadStates == null) {
			threadStates = new EDataTypeUniqueEList<String>(String.class, this, TracePackage.TRC_PROCESS__THREAD_STATES);
		}
		return threadStates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getPrecision() {
		return precision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrecision(long newPrecision) {
		long oldPrecision = precision;
		precision = newPrecision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__PRECISION, oldPrecision, precision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getLanguages() {
		if (languages == null) {
			languages = new EDataTypeUniqueEList<String>(String.class, this, TracePackage.TRC_PROCESS__LANGUAGES);
		}
		return languages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalCpuTime() {
		return totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalCpuTime(double newTotalCpuTime) {
		double oldTotalCpuTime = totalCpuTime;
		totalCpuTime = newTotalCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__TOTAL_CPU_TIME, oldTotalCpuTime, totalCpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCpuSampleResolution() {
		return cpuSampleResolution;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCpuSampleResolution(double newCpuSampleResolution) {
		double oldCpuSampleResolution = cpuSampleResolution;
		cpuSampleResolution = newCpuSampleResolution;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CPU_SAMPLE_RESOLUTION, oldCpuSampleResolution, cpuSampleResolution));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCThread> getThreads() {
		if (threads == null) {
			threads = new EObjectContainmentWithInverseEList<TRCThread>(TRCThread.class, this, TracePackage.TRC_PROCESS__THREADS, TracePackage.TRC_THREAD__PROCESS);
		}
		return threads;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCPackage> getPackages() {
		if (packages == null) {
			packages = new EObjectContainmentWithInverseEList<TRCPackage>(TRCPackage.class, this, TracePackage.TRC_PROCESS__PACKAGES, TracePackage.TRC_PACKAGE__PROCESS);
		}
		return packages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getClassClass() {
		if (classClass != null && classClass.eIsProxy()) {
			InternalEObject oldClassClass = (InternalEObject)classClass;
			classClass = (TRCClass)eResolveProxy(oldClassClass);
			if (classClass != oldClassClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_PROCESS__CLASS_CLASS, oldClassClass, classClass));
			}
		}
		return classClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetClassClass() {
		return classClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassClass(TRCClass newClassClass) {
		TRCClass oldClassClass = classClass;
		classClass = newClassClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CLASS_CLASS, oldClassClass, classClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCCollectionBoundary> getCollectionBoundaryPoints() {
		if (collectionBoundaryPoints == null) {
			collectionBoundaryPoints = new EObjectContainmentWithInverseEList<TRCCollectionBoundary>(TRCCollectionBoundary.class, this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS);
		}
		return collectionBoundaryPoints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCClassLoader> getClassLoaders() {
		if (classLoaders == null) {
			classLoaders = new EObjectContainmentWithInverseEList<TRCClassLoader>(TRCClassLoader.class, this, TracePackage.TRC_PROCESS__CLASS_LOADERS, TracePackage.TRC_CLASS_LOADER__PROCESS);
		}
		return classLoaders;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCSourceInfo> getSourceInfos() {
		if (sourceInfos == null) {
			sourceInfos = new EObjectContainmentEList<TRCSourceInfo>(TRCSourceInfo.class, this, TracePackage.TRC_PROCESS__SOURCE_INFOS);
		}
		return sourceInfos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCObject> getObjects() {
		if (objects == null) {
			objects = new EObjectContainmentWithInverseEList<TRCObject>(TRCObject.class, this, TracePackage.TRC_PROCESS__OBJECTS, TracePackage.TRC_OBJECT__PROCESS);
		}
		return objects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCHeapDump> getHeapDumps() {
		if (heapDumps == null) {
			heapDumps = new EObjectContainmentWithInverseEList<TRCHeapDump>(TRCHeapDump.class, this, TracePackage.TRC_PROCESS__HEAP_DUMPS, TracePackage.TRC_HEAP_DUMP__PROCESS);
		}
		return heapDumps;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCMethodInvocation> getInvocations() {
		if (invocations == null) {
			invocations = new EObjectContainmentWithInverseEList<TRCMethodInvocation>(TRCMethodInvocation.class, this, TracePackage.TRC_PROCESS__INVOCATIONS, TracePackage.TRC_METHOD_INVOCATION__PROCESS);
		}
		return invocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer getInputOutputContainer() {
		if (inputOutputContainer != null && inputOutputContainer.eIsProxy()) {
			InternalEObject oldInputOutputContainer = (InternalEObject)inputOutputContainer;
			inputOutputContainer = (TRCInputOutputContainer)eResolveProxy(oldInputOutputContainer);
			if (inputOutputContainer != oldInputOutputContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, oldInputOutputContainer, inputOutputContainer));
			}
		}
		return inputOutputContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer basicGetInputOutputContainer() {
		return inputOutputContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInputOutputContainer(TRCInputOutputContainer newInputOutputContainer, NotificationChain msgs) {
		TRCInputOutputContainer oldInputOutputContainer = inputOutputContainer;
		inputOutputContainer = newInputOutputContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, oldInputOutputContainer, newInputOutputContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInputOutputContainer(TRCInputOutputContainer newInputOutputContainer) {
		if (newInputOutputContainer != inputOutputContainer) {
			NotificationChain msgs = null;
			if (inputOutputContainer != null)
				msgs = ((InternalEObject)inputOutputContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
			if (newInputOutputContainer != null)
				msgs = ((InternalEObject)newInputOutputContainer).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
			msgs = basicSetInputOutputContainer(newInputOutputContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, newInputOutputContainer, newInputOutputContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EMap<TRCMethodInvocation, EList<TRCLockAccess>> getMethodLockAccessEntries() {
		if (methodLockAccessEntries == null) {
			methodLockAccessEntries = new EcoreEMap<TRCMethodInvocation,EList<TRCLockAccess>>(TracePackage.Literals.TRC_MTHD_LCK_ACC_ENTRY, TRCMthdLckAccEntryImpl.class, this, TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES);
		}
		return methodLockAccessEntries;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EMap<TRCMethodInvocation, EList<TRCObjectAllocationSite>> getAllocationSitesEntries() {
		if (allocationSitesEntries == null) {
			allocationSitesEntries = new EcoreEMap<TRCMethodInvocation,EList<TRCObjectAllocationSite>>(TracePackage.Literals.TRC_OBJECT_ALLOCATION_SITES_ENTRY, TRCObjectAllocationSitesEntryImpl.class, this, TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES);
		}
		return allocationSitesEntries;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<TRCAnnotation>(TRCAnnotation.class, this, TracePackage.TRC_PROCESS__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCGCEvent> getGcEvents() {
		if (gcEvents == null) {
			gcEvents = new EObjectContainmentEList<TRCGCEvent>(TRCGCEvent.class, this, TracePackage.TRC_PROCESS__GC_EVENTS);
		}
		return gcEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__THREADS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getThreads()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__PACKAGES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getPackages()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getCollectionBoundaryPoints()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getClassLoaders()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__OBJECTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getObjects()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getHeapDumps()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInvocations()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				if (inputOutputContainer != null)
					msgs = ((InternalEObject)inputOutputContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
				return basicSetInputOutputContainer((TRCInputOutputContainer)otherEnd, msgs);
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getMethodLockAccessEntries()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getAllocationSitesEntries()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__THREADS:
				return ((InternalEList<?>)getThreads()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__PACKAGES:
				return ((InternalEList<?>)getPackages()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return ((InternalEList<?>)getCollectionBoundaryPoints()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return ((InternalEList<?>)getClassLoaders()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				return ((InternalEList<?>)getSourceInfos()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__OBJECTS:
				return ((InternalEList<?>)getObjects()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return ((InternalEList<?>)getHeapDumps()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return ((InternalEList<?>)getInvocations()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				return basicSetInputOutputContainer(null, msgs);
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				return ((InternalEList<?>)getMethodLockAccessEntries()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				return ((InternalEList<?>)getAllocationSitesEntries()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_PROCESS__GC_EVENTS:
				return ((InternalEList<?>)getGcEvents()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__PID:
				return getPid();
			case TracePackage.TRC_PROCESS__NAME:
				return getName();
			case TracePackage.TRC_PROCESS__ID:
				return getId();
			case TracePackage.TRC_PROCESS__START_TIME:
				return getStartTime();
			case TracePackage.TRC_PROCESS__STOP_TIME:
				return getStopTime();
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				return getLastEventTime();
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				return getInitFinishedTime();
			case TracePackage.TRC_PROCESS__BASE_TIME:
				return getBaseTime();
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				return getCumulativeTime();
			case TracePackage.TRC_PROCESS__CALLS:
				return getCalls();
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				return getInheritedCalls();
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				return getInheritedBaseTime();
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				return getInheritedCumulativeTime();
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				return getTotalSize();
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				return getTotalInstances();
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				return getCollectedSize();
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				return getCollectedInstances();
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				return getReferencePointerSize();
			case TracePackage.TRC_PROCESS__TOTAL_CPU_TIME:
				return getTotalCpuTime();
			case TracePackage.TRC_PROCESS__CPU_SAMPLE_RESOLUTION:
				return getCpuSampleResolution();
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				return getThreadStates();
			case TracePackage.TRC_PROCESS__PRECISION:
				return getPrecision();
			case TracePackage.TRC_PROCESS__LANGUAGES:
				return getLanguages();
			case TracePackage.TRC_PROCESS__THREADS:
				return getThreads();
			case TracePackage.TRC_PROCESS__PACKAGES:
				return getPackages();
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				if (resolve) return getClassClass();
				return basicGetClassClass();
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return getCollectionBoundaryPoints();
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return getClassLoaders();
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				return getSourceInfos();
			case TracePackage.TRC_PROCESS__OBJECTS:
				return getObjects();
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return getHeapDumps();
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return getInvocations();
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				if (resolve) return getInputOutputContainer();
				return basicGetInputOutputContainer();
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				if (coreType) return getMethodLockAccessEntries();
				else return getMethodLockAccessEntries().map();
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				if (coreType) return getAllocationSitesEntries();
				else return getAllocationSitesEntries().map();
			case TracePackage.TRC_PROCESS__ANNOTATIONS:
				return getAnnotations();
			case TracePackage.TRC_PROCESS__GC_EVENTS:
				return getGcEvents();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__PID:
				setPid((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_PROCESS__ID:
				setId((String)newValue);
				return;
			case TracePackage.TRC_PROCESS__START_TIME:
				setStartTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				setStopTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				setLastEventTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				setInitFinishedTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				setBaseTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				setCumulativeTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__CALLS:
				setCalls((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				setInheritedCalls((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				setInheritedBaseTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				setTotalSize((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				setTotalInstances((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				setCollectedSize((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				setCollectedInstances((Integer)newValue);
				return;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				setReferencePointerSize((Short)newValue);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_CPU_TIME:
				setTotalCpuTime((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__CPU_SAMPLE_RESOLUTION:
				setCpuSampleResolution((Double)newValue);
				return;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				getThreadStates().clear();
				getThreadStates().addAll((Collection<? extends String>)newValue);
				return;
			case TracePackage.TRC_PROCESS__PRECISION:
				setPrecision((Long)newValue);
				return;
			case TracePackage.TRC_PROCESS__LANGUAGES:
				getLanguages().clear();
				getLanguages().addAll((Collection<? extends String>)newValue);
				return;
			case TracePackage.TRC_PROCESS__THREADS:
				getThreads().clear();
				getThreads().addAll((Collection<? extends TRCThread>)newValue);
				return;
			case TracePackage.TRC_PROCESS__PACKAGES:
				getPackages().clear();
				getPackages().addAll((Collection<? extends TRCPackage>)newValue);
				return;
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				setClassClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				getCollectionBoundaryPoints().clear();
				getCollectionBoundaryPoints().addAll((Collection<? extends TRCCollectionBoundary>)newValue);
				return;
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				getClassLoaders().clear();
				getClassLoaders().addAll((Collection<? extends TRCClassLoader>)newValue);
				return;
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				getSourceInfos().clear();
				getSourceInfos().addAll((Collection<? extends TRCSourceInfo>)newValue);
				return;
			case TracePackage.TRC_PROCESS__OBJECTS:
				getObjects().clear();
				getObjects().addAll((Collection<? extends TRCObject>)newValue);
				return;
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				getHeapDumps().clear();
				getHeapDumps().addAll((Collection<? extends TRCHeapDump>)newValue);
				return;
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection<? extends TRCMethodInvocation>)newValue);
				return;
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				setInputOutputContainer((TRCInputOutputContainer)newValue);
				return;
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				((EStructuralFeature.Setting)getMethodLockAccessEntries()).set(newValue);
				return;
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				((EStructuralFeature.Setting)getAllocationSitesEntries()).set(newValue);
				return;
			case TracePackage.TRC_PROCESS__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends TRCAnnotation>)newValue);
				return;
			case TracePackage.TRC_PROCESS__GC_EVENTS:
				getGcEvents().clear();
				getGcEvents().addAll((Collection<? extends TRCGCEvent>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__PID:
				setPid(PID_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				setLastEventTime(LAST_EVENT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				setInitFinishedTime(INIT_FINISHED_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				setInheritedCalls(INHERITED_CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				setInheritedBaseTime(INHERITED_BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(INHERITED_CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				setTotalSize(TOTAL_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				setTotalInstances(TOTAL_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				setCollectedSize(COLLECTED_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				setCollectedInstances(COLLECTED_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				setReferencePointerSize(REFERENCE_POINTER_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__CPU_SAMPLE_RESOLUTION:
				setCpuSampleResolution(CPU_SAMPLE_RESOLUTION_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				getThreadStates().clear();
				return;
			case TracePackage.TRC_PROCESS__PRECISION:
				setPrecision(PRECISION_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__LANGUAGES:
				getLanguages().clear();
				return;
			case TracePackage.TRC_PROCESS__THREADS:
				getThreads().clear();
				return;
			case TracePackage.TRC_PROCESS__PACKAGES:
				getPackages().clear();
				return;
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				setClassClass((TRCClass)null);
				return;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				getCollectionBoundaryPoints().clear();
				return;
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				getClassLoaders().clear();
				return;
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				getSourceInfos().clear();
				return;
			case TracePackage.TRC_PROCESS__OBJECTS:
				getObjects().clear();
				return;
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				getHeapDumps().clear();
				return;
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				getInvocations().clear();
				return;
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				setInputOutputContainer((TRCInputOutputContainer)null);
				return;
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				getMethodLockAccessEntries().clear();
				return;
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				getAllocationSitesEntries().clear();
				return;
			case TracePackage.TRC_PROCESS__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case TracePackage.TRC_PROCESS__GC_EVENTS:
				getGcEvents().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_PROCESS__PID:
				return pid != PID_EDEFAULT;
			case TracePackage.TRC_PROCESS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_PROCESS__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case TracePackage.TRC_PROCESS__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				return lastEventTime != LAST_EVENT_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				return initFinishedTime != INIT_FINISHED_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				return inheritedCalls != INHERITED_CALLS_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				return inheritedBaseTime != INHERITED_BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				return inheritedCumulativeTime != INHERITED_CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				return totalSize != TOTAL_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				return totalInstances != TOTAL_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				return collectedSize != COLLECTED_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				return collectedInstances != COLLECTED_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				return referencePointerSize != REFERENCE_POINTER_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__CPU_SAMPLE_RESOLUTION:
				return cpuSampleResolution != CPU_SAMPLE_RESOLUTION_EDEFAULT;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				return threadStates != null && !threadStates.isEmpty();
			case TracePackage.TRC_PROCESS__PRECISION:
				return precision != PRECISION_EDEFAULT;
			case TracePackage.TRC_PROCESS__LANGUAGES:
				return languages != null && !languages.isEmpty();
			case TracePackage.TRC_PROCESS__THREADS:
				return threads != null && !threads.isEmpty();
			case TracePackage.TRC_PROCESS__PACKAGES:
				return packages != null && !packages.isEmpty();
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				return classClass != null;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return collectionBoundaryPoints != null && !collectionBoundaryPoints.isEmpty();
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return classLoaders != null && !classLoaders.isEmpty();
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				return sourceInfos != null && !sourceInfos.isEmpty();
			case TracePackage.TRC_PROCESS__OBJECTS:
				return objects != null && !objects.isEmpty();
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return heapDumps != null && !heapDumps.isEmpty();
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				return inputOutputContainer != null;
			case TracePackage.TRC_PROCESS__METHOD_LOCK_ACCESS_ENTRIES:
				return methodLockAccessEntries != null && !methodLockAccessEntries.isEmpty();
			case TracePackage.TRC_PROCESS__ALLOCATION_SITES_ENTRIES:
				return allocationSitesEntries != null && !allocationSitesEntries.isEmpty();
			case TracePackage.TRC_PROCESS__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case TracePackage.TRC_PROCESS__GC_EVENTS:
				return gcEvents != null && !gcEvents.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (pid: ");
		result.append(pid);
		result.append(", name: ");
		result.append(name);
		result.append(", id: ");
		result.append(id);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(", lastEventTime: ");
		result.append(lastEventTime);
		result.append(", initFinishedTime: ");
		result.append(initFinishedTime);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", calls: ");
		result.append(calls);
		result.append(", inheritedCalls: ");
		result.append(inheritedCalls);
		result.append(", inheritedBaseTime: ");
		result.append(inheritedBaseTime);
		result.append(", inheritedCumulativeTime: ");
		result.append(inheritedCumulativeTime);
		result.append(", totalSize: ");
		result.append(totalSize);
		result.append(", totalInstances: ");
		result.append(totalInstances);
		result.append(", collectedSize: ");
		result.append(collectedSize);
		result.append(", collectedInstances: ");
		result.append(collectedInstances);
		result.append(", referencePointerSize: ");
		result.append(referencePointerSize);
		result.append(", totalCpuTime: ");
		result.append(totalCpuTime);
		result.append(", cpuSampleResolution: ");
		result.append(cpuSampleResolution);
		result.append(", threadStates: ");
		result.append(threadStates);
		result.append(", precision: ");
		result.append(precision);
		result.append(", languages: ");
		result.append(languages);
		result.append(')');
		return result.toString();
	}

} //TRCProcessImpl
