/**********************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel - Initial API and implementation
 *
 * $Id: TRCThreadExecEventImpl.java,v 1.4 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Exec Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl#getRunningEvents <em>Running Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl#isInCriticalPath <em>In Critical Path</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadExecEventImpl extends TRCThreadEventImpl implements TRCThreadExecEvent {
	/**
	 * The cached value of the '{@link #getRunningEvents() <em>Running Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunningEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCThreadRunningEvent> runningEvents;

	/**
	 * The default value of the '{@link #isInCriticalPath() <em>In Critical Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInCriticalPath()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IN_CRITICAL_PATH_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInCriticalPath() <em>In Critical Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInCriticalPath()
	 * @generated
	 * @ordered
	 */
	protected boolean inCriticalPath = IN_CRITICAL_PATH_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadExecEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_EXEC_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCThreadRunningEvent> getRunningEvents() {
		if (runningEvents == null) {
			runningEvents = new EObjectContainmentEList<TRCThreadRunningEvent>(TRCThreadRunningEvent.class, this, TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS);
		}
		return runningEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInCriticalPath() {
		return inCriticalPath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInCriticalPath(boolean newInCriticalPath) {
		boolean oldInCriticalPath = inCriticalPath;
		inCriticalPath = newInCriticalPath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH, oldInCriticalPath, inCriticalPath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS:
				return ((InternalEList<?>)getRunningEvents()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS:
				return getRunningEvents();
			case TracePackage.TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH:
				return isInCriticalPath();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS:
				getRunningEvents().clear();
				getRunningEvents().addAll((Collection<? extends TRCThreadRunningEvent>)newValue);
				return;
			case TracePackage.TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH:
				setInCriticalPath((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS:
				getRunningEvents().clear();
				return;
			case TracePackage.TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH:
				setInCriticalPath(IN_CRITICAL_PATH_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_EXEC_EVENT__RUNNING_EVENTS:
				return runningEvents != null && !runningEvents.isEmpty();
			case TracePackage.TRC_THREAD_EXEC_EVENT__IN_CRITICAL_PATH:
				return inCriticalPath != IN_CRITICAL_PATH_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (inCriticalPath: ");
		result.append(inCriticalPath);
		result.append(')');
		return result.toString();
	}

} //TRCThreadExecEventImpl