/**********************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel - Initial API and implementation
 *
 * $Id: TRCThreadInterruptThreadEventImpl.java,v 1.3 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Interrupt Thread Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl#getInterruptedThread <em>Interrupted Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadInterruptThreadEventImpl extends TRCThreadExecEventImpl implements TRCThreadInterruptThreadEvent {
	/**
	 * The cached value of the '{@link #getInterruptedThread() <em>Interrupted Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterruptedThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread interruptedThread;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadInterruptThreadEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_INTERRUPT_THREAD_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getInterruptedThread() {
		if (interruptedThread != null && interruptedThread.eIsProxy()) {
			InternalEObject oldInterruptedThread = (InternalEObject)interruptedThread;
			interruptedThread = (TRCThread)eResolveProxy(oldInterruptedThread);
			if (interruptedThread != oldInterruptedThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD, oldInterruptedThread, interruptedThread));
			}
		}
		return interruptedThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetInterruptedThread() {
		return interruptedThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterruptedThread(TRCThread newInterruptedThread) {
		TRCThread oldInterruptedThread = interruptedThread;
		interruptedThread = newInterruptedThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD, oldInterruptedThread, interruptedThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD:
				if (resolve) return getInterruptedThread();
				return basicGetInterruptedThread();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD:
				setInterruptedThread((TRCThread)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD:
				setInterruptedThread((TRCThread)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT__INTERRUPTED_THREAD:
				return interruptedThread != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCThreadInterruptThreadEventImpl