/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TraceFactoryImpl.java,v 1.14 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCObjectValueKind;
import org.eclipse.hyades.models.trace.TRCObjectValuePosition;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TraceFactoryImpl extends EFactoryImpl implements TraceFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TraceFactory init() {
		try {
			TraceFactory theTraceFactory = (TraceFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/hyades/models/trace.xmi"); 
			if (theTraceFactory != null) {
				return theTraceFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new TraceFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TracePackage.TRCGC_EVENT: return createTRCGCEvent();
			case TracePackage.TRC_OBJECT: return createTRCObject();
			case TracePackage.TRC_CLASS: return createTRCClass();
			case TracePackage.TRC_METHOD_INVOCATION: return createTRCMethodInvocation();
			case TracePackage.TRC_PROCESS: return createTRCProcess();
			case TracePackage.TRC_THREAD: return createTRCThread();
			case TracePackage.TRC_METHOD: return createTRCMethod();
			case TracePackage.TRC_PACKAGE: return createTRCPackage();
			case TracePackage.TRC_COLLECTION_BOUNDARY: return createTRCCollectionBoundary();
			case TracePackage.TRC_CLASS_LOADER: return createTRCClassLoader();
			case TracePackage.TRC_SOURCE_INFO: return createTRCSourceInfo();
			case TracePackage.TRC_HEAP_OBJECT: return createTRCHeapObject();
			case TracePackage.TRC_FULL_TRACE_OBJECT: return createTRCFullTraceObject();
			case TracePackage.TRC_TRACE_OBJECT: return createTRCTraceObject();
			case TracePackage.TRC_FULL_HEAP_OBJECT: return createTRCFullHeapObject();
			case TracePackage.TRC_OBJECT_REFERENCE: return createTRCObjectReference();
			case TracePackage.TRC_HEAP_DUMP: return createTRCHeapDump();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION: return createTRCAggregatedMethodInvocation();
			case TracePackage.TRC_FULL_METHOD_INVOCATION: return createTRCFullMethodInvocation();
			case TracePackage.TRC_HEAP_ROOT: return createTRCHeapRoot();
			case TracePackage.TRC_ARRAY_CLASS: return createTRCArrayClass();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE: return createTRCAggregatedObjectReference();
			case TracePackage.TRC_THREAD_EVENT: return createTRCThreadEvent();
			case TracePackage.TRC_THREAD_SLEEPING_EVENT: return createTRCThreadSleepingEvent();
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT: return createTRCThreadWaitingForObjectEvent();
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT: return createTRCThreadWaitingForLockEvent();
			case TracePackage.TRC_THREAD_RUNNING_EVENT: return createTRCThreadRunningEvent();
			case TracePackage.TRC_THREAD_DEAD_EVENT: return createTRCThreadDeadEvent();
			case TracePackage.TRC_METHOD_WITH_LL_DATA: return createTRCMethodWithLLData();
			case TracePackage.TRC_SOURCE_INFO_WITH_LL_DATA: return createTRCSourceInfoWithLLData();
			case TracePackage.TRC_LINE_COVERAGE_DATA: return createTRCLineCoverageData();
			case TracePackage.TRC_OBJECT_VALUE: return createTRCObjectValue();
			case TracePackage.TRC_INPUT_OUTPUT_ENTRY: return (EObject)createTRCInputOutputEntry();
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER: return createTRCInputOutputContainer();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO: return createTRCCallerCalleeInvocationInfo();
			case TracePackage.TRC_TYPED_OBJECT_VALUE: return createTRCTypedObjectValue();
			case TracePackage.TRC_MTHD_LCK_ACC_ENTRY: return (EObject)createTRCMthdLckAccEntry();
			case TracePackage.TRC_LOCK_ACCESS: return createTRCLockAccess();
			case TracePackage.TRC_LINE_PERFORMANCE_DATA: return createTRCLinePerformanceData();
			case TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY: return (EObject)createTRCObjectAllocationSitesEntry();
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE: return createTRCObjectAllocationSite();
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT: return createTRCThreadDeadLockEvent();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION: return createTRCObjectAllocationAnnotation();
			case TracePackage.TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT: return createTRCThreadWaitTimeoutExceedEvent();
			case TracePackage.TRC_THREAD_WAITING_FOR_JOIN_EVENT: return createTRCThreadWaitingForJoinEvent();
			case TracePackage.TRC_THREAD_EXEC_EVENT: return createTRCThreadExecEvent();
			case TracePackage.TRC_THREAD_NOTIFY_ALL_EVENT: return createTRCThreadNotifyAllEvent();
			case TracePackage.TRC_THREAD_NOTIFY_EVENT: return createTRCThreadNotifyEvent();
			case TracePackage.TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT: return createTRCThreadDeadAndNotifyJoinedEvent();
			case TracePackage.TRC_THREAD_START_THREAD_EVENT: return createTRCThreadStartThreadEvent();
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT: return createTRCThreadInterruptThreadEvent();
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT: return createTRCThreadHandoffLockEvent();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case TracePackage.TRC_PRIMITIVE_TYPE:
				return createTRCPrimitiveTypeFromString(eDataType, initialValue);
			case TracePackage.TRC_SIGNATURE_NOTATION:
				return createTRCSignatureNotationFromString(eDataType, initialValue);
			case TracePackage.TRC_METHOD_PROPERTIES:
				return createTRCMethodPropertiesFromString(eDataType, initialValue);
			case TracePackage.TRCGC_ROOT_TYPE:
				return createTRCGCRootTypeFromString(eDataType, initialValue);
			case TracePackage.TRC_OBJECT_VALUE_KIND:
				return createTRCObjectValueKindFromString(eDataType, initialValue);
			case TracePackage.TRC_OBJECT_VALUE_POSITION:
				return createTRCObjectValuePositionFromString(eDataType, initialValue);
			case TracePackage.EOBJECT_ID:
				return createEObjectIDFromString(eDataType, initialValue);
			case TracePackage.EMETHOD_ID:
				return createEMethodIDFromString(eDataType, initialValue);
			case TracePackage.ECLASS_ID:
				return createEClassIDFromString(eDataType, initialValue);
			case TracePackage.LL_UNIT_DATA:
				return createLLUnitDataFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case TracePackage.TRC_PRIMITIVE_TYPE:
				return convertTRCPrimitiveTypeToString(eDataType, instanceValue);
			case TracePackage.TRC_SIGNATURE_NOTATION:
				return convertTRCSignatureNotationToString(eDataType, instanceValue);
			case TracePackage.TRC_METHOD_PROPERTIES:
				return convertTRCMethodPropertiesToString(eDataType, instanceValue);
			case TracePackage.TRCGC_ROOT_TYPE:
				return convertTRCGCRootTypeToString(eDataType, instanceValue);
			case TracePackage.TRC_OBJECT_VALUE_KIND:
				return convertTRCObjectValueKindToString(eDataType, instanceValue);
			case TracePackage.TRC_OBJECT_VALUE_POSITION:
				return convertTRCObjectValuePositionToString(eDataType, instanceValue);
			case TracePackage.EOBJECT_ID:
				return convertEObjectIDToString(eDataType, instanceValue);
			case TracePackage.EMETHOD_ID:
				return convertEMethodIDToString(eDataType, instanceValue);
			case TracePackage.ECLASS_ID:
				return convertEClassIDToString(eDataType, instanceValue);
			case TracePackage.LL_UNIT_DATA:
				return convertLLUnitDataToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject createTRCObject() {
		TRCObjectImpl trcObject = new TRCObjectImpl();
		return trcObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass createTRCClass() {
		TRCClassImpl trcClass = new TRCClassImpl();
		return trcClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation createTRCMethodInvocation() {
		TRCMethodInvocationImpl trcMethodInvocation = new TRCMethodInvocationImpl();
		return trcMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess createTRCProcess() {
		TRCProcessImpl trcProcess = new TRCProcessImpl();
		return trcProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread createTRCThread() {
		TRCThreadImpl trcThread = new TRCThreadImpl();
		return trcThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod createTRCMethod() {
		TRCMethodImpl trcMethod = new TRCMethodImpl();
		return trcMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage createTRCPackage() {
		TRCPackageImpl trcPackage = new TRCPackageImpl();
		return trcPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCollectionBoundary createTRCCollectionBoundary() {
		TRCCollectionBoundaryImpl trcCollectionBoundary = new TRCCollectionBoundaryImpl();
		return trcCollectionBoundary;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClassLoader createTRCClassLoader() {
		TRCClassLoaderImpl trcClassLoader = new TRCClassLoaderImpl();
		return trcClassLoader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo createTRCSourceInfo() {
		TRCSourceInfoImpl trcSourceInfo = new TRCSourceInfoImpl();
		return trcSourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapObject createTRCHeapObject() {
		TRCHeapObjectImpl trcHeapObject = new TRCHeapObjectImpl();
		return trcHeapObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullTraceObject createTRCFullTraceObject() {
		TRCFullTraceObjectImpl trcFullTraceObject = new TRCFullTraceObjectImpl();
		return trcFullTraceObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject createTRCTraceObject() {
		TRCTraceObjectImpl trcTraceObject = new TRCTraceObjectImpl();
		return trcTraceObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullHeapObject createTRCFullHeapObject() {
		TRCFullHeapObjectImpl trcFullHeapObject = new TRCFullHeapObjectImpl();
		return trcFullHeapObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectReference createTRCObjectReference() {
		TRCObjectReferenceImpl trcObjectReference = new TRCObjectReferenceImpl();
		return trcObjectReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump createTRCHeapDump() {
		TRCHeapDumpImpl trcHeapDump = new TRCHeapDumpImpl();
		return trcHeapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAggregatedMethodInvocation createTRCAggregatedMethodInvocation() {
		TRCAggregatedMethodInvocationImpl trcAggregatedMethodInvocation = new TRCAggregatedMethodInvocationImpl();
		return trcAggregatedMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullMethodInvocation createTRCFullMethodInvocation() {
		TRCFullMethodInvocationImpl trcFullMethodInvocation = new TRCFullMethodInvocationImpl();
		return trcFullMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapRoot createTRCHeapRoot() {
		TRCHeapRootImpl trcHeapRoot = new TRCHeapRootImpl();
		return trcHeapRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCArrayClass createTRCArrayClass() {
		TRCArrayClassImpl trcArrayClass = new TRCArrayClassImpl();
		return trcArrayClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAggregatedObjectReference createTRCAggregatedObjectReference() {
		TRCAggregatedObjectReferenceImpl trcAggregatedObjectReference = new TRCAggregatedObjectReferenceImpl();
		return trcAggregatedObjectReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadEvent createTRCThreadEvent() {
		TRCThreadEventImpl trcThreadEvent = new TRCThreadEventImpl();
		return trcThreadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadSleepingEvent createTRCThreadSleepingEvent() {
		TRCThreadSleepingEventImpl trcThreadSleepingEvent = new TRCThreadSleepingEventImpl();
		return trcThreadSleepingEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitingForObjectEvent createTRCThreadWaitingForObjectEvent() {
		TRCThreadWaitingForObjectEventImpl trcThreadWaitingForObjectEvent = new TRCThreadWaitingForObjectEventImpl();
		return trcThreadWaitingForObjectEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitingForLockEvent createTRCThreadWaitingForLockEvent() {
		TRCThreadWaitingForLockEventImpl trcThreadWaitingForLockEvent = new TRCThreadWaitingForLockEventImpl();
		return trcThreadWaitingForLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadRunningEvent createTRCThreadRunningEvent() {
		TRCThreadRunningEventImpl trcThreadRunningEvent = new TRCThreadRunningEventImpl();
		return trcThreadRunningEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadEvent createTRCThreadDeadEvent() {
		TRCThreadDeadEventImpl trcThreadDeadEvent = new TRCThreadDeadEventImpl();
		return trcThreadDeadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodWithLLData createTRCMethodWithLLData() {
		TRCMethodWithLLDataImpl trcMethodWithLLData = new TRCMethodWithLLDataImpl();
		return trcMethodWithLLData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData createTRCSourceInfoWithLLData() {
		TRCSourceInfoWithLLDataImpl trcSourceInfoWithLLData = new TRCSourceInfoWithLLDataImpl();
		return trcSourceInfoWithLLData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCLineCoverageData createTRCLineCoverageData() {
		TRCLineCoverageDataImpl trcLineCoverageData = new TRCLineCoverageDataImpl();
		return trcLineCoverageData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValue createTRCObjectValue() {
		TRCObjectValueImpl trcObjectValue = new TRCObjectValueImpl();
		return trcObjectValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> createTRCInputOutputEntry() {
		TRCInputOutputEntryImpl trcInputOutputEntry = new TRCInputOutputEntryImpl();
		return trcInputOutputEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer createTRCInputOutputContainer() {
		TRCInputOutputContainerImpl trcInputOutputContainer = new TRCInputOutputContainerImpl();
		return trcInputOutputContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCallerCalleeInvocationInfo createTRCCallerCalleeInvocationInfo() {
		TRCCallerCalleeInvocationInfoImpl trcCallerCalleeInvocationInfo = new TRCCallerCalleeInvocationInfoImpl();
		return trcCallerCalleeInvocationInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTypedObjectValue createTRCTypedObjectValue() {
		TRCTypedObjectValueImpl trcTypedObjectValue = new TRCTypedObjectValueImpl();
		return trcTypedObjectValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry<TRCMethodInvocation, EList<TRCLockAccess>> createTRCMthdLckAccEntry() {
		TRCMthdLckAccEntryImpl trcMthdLckAccEntry = new TRCMthdLckAccEntryImpl();
		return trcMthdLckAccEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCLockAccess createTRCLockAccess() {
		TRCLockAccessImpl trcLockAccess = new TRCLockAccessImpl();
		return trcLockAccess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCLinePerformanceData createTRCLinePerformanceData() {
		TRCLinePerformanceDataImpl trcLinePerformanceData = new TRCLinePerformanceDataImpl();
		return trcLinePerformanceData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> createTRCObjectAllocationSitesEntry() {
		TRCObjectAllocationSitesEntryImpl trcObjectAllocationSitesEntry = new TRCObjectAllocationSitesEntryImpl();
		return trcObjectAllocationSitesEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectAllocationSite createTRCObjectAllocationSite() {
		TRCObjectAllocationSiteImpl trcObjectAllocationSite = new TRCObjectAllocationSiteImpl();
		return trcObjectAllocationSite;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadLockEvent createTRCThreadDeadLockEvent() {
		TRCThreadDeadLockEventImpl trcThreadDeadLockEvent = new TRCThreadDeadLockEventImpl();
		return trcThreadDeadLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCGCEvent createTRCGCEvent() {
		TRCGCEventImpl trcgcEvent = new TRCGCEventImpl();
		return trcgcEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectAllocationAnnotation createTRCObjectAllocationAnnotation() {
		TRCObjectAllocationAnnotationImpl trcObjectAllocationAnnotation = new TRCObjectAllocationAnnotationImpl();
		return trcObjectAllocationAnnotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitTimeoutExceedEvent createTRCThreadWaitTimeoutExceedEvent() {
		TRCThreadWaitTimeoutExceedEventImpl trcThreadWaitTimeoutExceedEvent = new TRCThreadWaitTimeoutExceedEventImpl();
		return trcThreadWaitTimeoutExceedEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitingForJoinEvent createTRCThreadWaitingForJoinEvent() {
		TRCThreadWaitingForJoinEventImpl trcThreadWaitingForJoinEvent = new TRCThreadWaitingForJoinEventImpl();
		return trcThreadWaitingForJoinEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadExecEvent createTRCThreadExecEvent() {
		TRCThreadExecEventImpl trcThreadExecEvent = new TRCThreadExecEventImpl();
		return trcThreadExecEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadNotifyAllEvent createTRCThreadNotifyAllEvent() {
		TRCThreadNotifyAllEventImpl trcThreadNotifyAllEvent = new TRCThreadNotifyAllEventImpl();
		return trcThreadNotifyAllEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadNotifyEvent createTRCThreadNotifyEvent() {
		TRCThreadNotifyEventImpl trcThreadNotifyEvent = new TRCThreadNotifyEventImpl();
		return trcThreadNotifyEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadAndNotifyJoinedEvent createTRCThreadDeadAndNotifyJoinedEvent() {
		TRCThreadDeadAndNotifyJoinedEventImpl trcThreadDeadAndNotifyJoinedEvent = new TRCThreadDeadAndNotifyJoinedEventImpl();
		return trcThreadDeadAndNotifyJoinedEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadStartThreadEvent createTRCThreadStartThreadEvent() {
		TRCThreadStartThreadEventImpl trcThreadStartThreadEvent = new TRCThreadStartThreadEventImpl();
		return trcThreadStartThreadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadInterruptThreadEvent createTRCThreadInterruptThreadEvent() {
		TRCThreadInterruptThreadEventImpl trcThreadInterruptThreadEvent = new TRCThreadInterruptThreadEventImpl();
		return trcThreadInterruptThreadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadHandoffLockEvent createTRCThreadHandoffLockEvent() {
		TRCThreadHandoffLockEventImpl trcThreadHandoffLockEvent = new TRCThreadHandoffLockEventImpl();
		return trcThreadHandoffLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPrimitiveType createTRCPrimitiveTypeFromString(EDataType eDataType, String initialValue) {
		TRCPrimitiveType result = TRCPrimitiveType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCPrimitiveTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSignatureNotation createTRCSignatureNotationFromString(EDataType eDataType, String initialValue) {
		TRCSignatureNotation result = TRCSignatureNotation.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCSignatureNotationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodProperties createTRCMethodPropertiesFromString(EDataType eDataType, String initialValue) {
		TRCMethodProperties result = TRCMethodProperties.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCMethodPropertiesToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCGCRootType createTRCGCRootTypeFromString(EDataType eDataType, String initialValue) {
		TRCGCRootType result = TRCGCRootType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCGCRootTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValueKind createTRCObjectValueKindFromString(EDataType eDataType, String initialValue) {
		TRCObjectValueKind result = TRCObjectValueKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCObjectValueKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValuePosition createTRCObjectValuePositionFromString(EDataType eDataType, String initialValue) {
		TRCObjectValuePosition result = TRCObjectValuePosition.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTRCObjectValuePositionToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Long createEObjectIDFromString(EDataType eDataType, String initialValue) {
		return (Long)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEObjectIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer createEMethodIDFromString(EDataType eDataType, String initialValue) {
		return (Integer)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEMethodIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Long createEClassIDFromString(EDataType eDataType, String initialValue) {
		return (Long)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEClassIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LLUnitData createLLUnitDataFromString(EDataType eDataType, String initialValue) {
		return (LLUnitData)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLLUnitDataToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TracePackage getTracePackage() {
		return (TracePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static TracePackage getPackage() {
		return TracePackage.eINSTANCE;
	}

} //TraceFactoryImpl
