/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LLUnitData.java,v 1.3 2006/02/08 20:00:09 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.trace.util;

import org.eclipse.hyades.models.trace.TRCSourceInfo;

/**
 * @author slavescu
 * @since 3.0
 */
public class LLUnitData {
	protected TRCSourceInfo sourceInfo;
	protected int startLine;
	protected int startColumn;
	protected int endLine;
	protected int endColumn;
	protected int data1;
	protected int data2;
	protected boolean hit;
	protected int count;
	protected double accumulatedTime;
	protected Object annotation;
	/**
	 * @return Returns the annotation.
	 */
	public Object getAnnotation() {
		return annotation;
	}
	/**
	 * @param annotation The annotation to set.
	 */
	public void setAnnotation(Object annotation) {
		this.annotation = annotation;
	}
	/**
	 * @return Returns the data1.
	 */
	public int getData1() {
		return data1;
	}
	/**
	 * @param data1 The data1 to set.
	 */
	public void setData1(int data1) {
		this.data1 = data1;
	}
	/**
	 * @return Returns the data2.
	 */
	public int getData2() {
		return data2;
	}
	/**
	 * @param data2 The data2 to set.
	 */
	public void setData2(int data2) {
		this.data2 = data2;
	}
	/**
	 * @return Returns the endColumn.
	 */
	public int getEndColumn() {
		return endColumn;
	}
	/**
	 * @param endColumn The endColumn to set.
	 */
	public void setEndColumn(int endColumn) {
		this.endColumn = endColumn;
	}
	/**
	 * @return Returns the endLine.
	 */
	public int getEndLine() {
		return endLine;
	}
	/**
	 * @param endLine The endLine to set.
	 */
	public void setEndLine(int endLine) {
		this.endLine = endLine;
	}
	/**
	 * @return Returns the sourceInfo.
	 */
	public TRCSourceInfo getSourceInfo() {
		return sourceInfo;
	}
	/**
	 * @param sourceInfo The sourceInfo to set.
	 */
	public void setSourceInfo(TRCSourceInfo sourceInfo) {
		this.sourceInfo = sourceInfo;
	}
	/**
	 * @return Returns the startColumn.
	 */
	public int getStartColumn() {
		return startColumn;
	}
	/**
	 * @param startColumn The startColumn to set.
	 */
	public void setStartColumn(int startColumn) {
		this.startColumn = startColumn;
	}
	/**
	 * @return Returns the startLine.
	 */
	public int getStartLine() {
		return startLine;
	}
	/**
	 * @param startLine The startLine to set.
	 */
	public void setStartLine(int startLine) {
		this.startLine = startLine;
	}
	/**
	 * @return Returns the hit status.
	 */
	public boolean isHit() {
		return hit;
	}
	/**
	 * @param hit The hit status to set.
	 */
	public void setHit(boolean hit) {
		this.hit = hit;
	}
	/**
	 * @return Returns the count.
	 */
	public int getCount() {
		return count;
	}
	/**
	 * @param count The count to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}
	/**
	 * @return Returns the accumulated time.
	 */
	public double getAccumulatedTime() {
		return accumulatedTime;
	}
	/**
	 * @param startLine The startLine to set.
	 */
	public void setAccumulatedTime(double accumulatedTime) {
		this.accumulatedTime = accumulatedTime;
	}
}
