/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TraceAdapterFactory.java,v 1.15 2009/05/05 15:51:13 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.util;

import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLLData;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage
 * @generated
 */
public class TraceAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TracePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TracePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TraceSwitch<Adapter> modelSwitch =
		new TraceSwitch<Adapter>() {
			@Override
			public Adapter caseTRCGCEvent(TRCGCEvent object) {
				return createTRCGCEventAdapter();
			}
			@Override
			public Adapter caseTRCObject(TRCObject object) {
				return createTRCObjectAdapter();
			}
			@Override
			public Adapter caseTRCClass(TRCClass object) {
				return createTRCClassAdapter();
			}
			@Override
			public Adapter caseTRCMethodInvocation(TRCMethodInvocation object) {
				return createTRCMethodInvocationAdapter();
			}
			@Override
			public Adapter caseTRCProcess(TRCProcess object) {
				return createTRCProcessAdapter();
			}
			@Override
			public Adapter caseTRCThread(TRCThread object) {
				return createTRCThreadAdapter();
			}
			@Override
			public Adapter caseTRCMethod(TRCMethod object) {
				return createTRCMethodAdapter();
			}
			@Override
			public Adapter caseTRCPackage(TRCPackage object) {
				return createTRCPackageAdapter();
			}
			@Override
			public Adapter caseTRCCollectionBoundary(TRCCollectionBoundary object) {
				return createTRCCollectionBoundaryAdapter();
			}
			@Override
			public Adapter caseTRCClassLoader(TRCClassLoader object) {
				return createTRCClassLoaderAdapter();
			}
			@Override
			public Adapter caseTRCSourceInfo(TRCSourceInfo object) {
				return createTRCSourceInfoAdapter();
			}
			@Override
			public Adapter caseTRCHeapObject(TRCHeapObject object) {
				return createTRCHeapObjectAdapter();
			}
			@Override
			public Adapter caseTRCFullTraceObject(TRCFullTraceObject object) {
				return createTRCFullTraceObjectAdapter();
			}
			@Override
			public Adapter caseTRCTraceObject(TRCTraceObject object) {
				return createTRCTraceObjectAdapter();
			}
			@Override
			public Adapter caseTRCFullHeapObject(TRCFullHeapObject object) {
				return createTRCFullHeapObjectAdapter();
			}
			@Override
			public Adapter caseTRCObjectReference(TRCObjectReference object) {
				return createTRCObjectReferenceAdapter();
			}
			@Override
			public Adapter caseTRCHeapDump(TRCHeapDump object) {
				return createTRCHeapDumpAdapter();
			}
			@Override
			public Adapter caseTRCAggregatedMethodInvocation(TRCAggregatedMethodInvocation object) {
				return createTRCAggregatedMethodInvocationAdapter();
			}
			@Override
			public Adapter caseTRCFullMethodInvocation(TRCFullMethodInvocation object) {
				return createTRCFullMethodInvocationAdapter();
			}
			@Override
			public Adapter caseTRCHeapRoot(TRCHeapRoot object) {
				return createTRCHeapRootAdapter();
			}
			@Override
			public Adapter caseTRCArrayClass(TRCArrayClass object) {
				return createTRCArrayClassAdapter();
			}
			@Override
			public Adapter caseTRCAggregatedObjectReference(TRCAggregatedObjectReference object) {
				return createTRCAggregatedObjectReferenceAdapter();
			}
			@Override
			public Adapter caseTRCThreadEvent(TRCThreadEvent object) {
				return createTRCThreadEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadSleepingEvent(TRCThreadSleepingEvent object) {
				return createTRCThreadSleepingEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadWaitingForObjectEvent(TRCThreadWaitingForObjectEvent object) {
				return createTRCThreadWaitingForObjectEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadWaitingForLockEvent(TRCThreadWaitingForLockEvent object) {
				return createTRCThreadWaitingForLockEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadRunningEvent(TRCThreadRunningEvent object) {
				return createTRCThreadRunningEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadDeadEvent(TRCThreadDeadEvent object) {
				return createTRCThreadDeadEventAdapter();
			}
			@Override
			public Adapter caseTRCMethodWithLLData(TRCMethodWithLLData object) {
				return createTRCMethodWithLLDataAdapter();
			}
			@Override
			public Adapter caseTRCLLData(TRCLLData object) {
				return createTRCLLDataAdapter();
			}
			@Override
			public Adapter caseTRCSourceInfoWithLLData(TRCSourceInfoWithLLData object) {
				return createTRCSourceInfoWithLLDataAdapter();
			}
			@Override
			public Adapter caseTRCLineCoverageData(TRCLineCoverageData object) {
				return createTRCLineCoverageDataAdapter();
			}
			@Override
			public Adapter caseTRCObjectValue(TRCObjectValue object) {
				return createTRCObjectValueAdapter();
			}
			@Override
			public Adapter caseTRCInputOutputEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> object) {
				return createTRCInputOutputEntryAdapter();
			}
			@Override
			public Adapter caseTRCInputOutputContainer(TRCInputOutputContainer object) {
				return createTRCInputOutputContainerAdapter();
			}
			@Override
			public Adapter caseTRCCallerCalleeInvocationInfo(TRCCallerCalleeInvocationInfo object) {
				return createTRCCallerCalleeInvocationInfoAdapter();
			}
			@Override
			public Adapter caseTRCTypedObjectValue(TRCTypedObjectValue object) {
				return createTRCTypedObjectValueAdapter();
			}
			@Override
			public Adapter caseTRCMthdLckAccEntry(Map.Entry<TRCMethodInvocation, EList<TRCLockAccess>> object) {
				return createTRCMthdLckAccEntryAdapter();
			}
			@Override
			public Adapter caseTRCLockAccess(TRCLockAccess object) {
				return createTRCLockAccessAdapter();
			}
			@Override
			public Adapter caseTRCLinePerformanceData(TRCLinePerformanceData object) {
				return createTRCLinePerformanceDataAdapter();
			}
			@Override
			public Adapter caseTRCObjectAllocationSitesEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> object) {
				return createTRCObjectAllocationSitesEntryAdapter();
			}
			@Override
			public Adapter caseTRCObjectAllocationSite(TRCObjectAllocationSite object) {
				return createTRCObjectAllocationSiteAdapter();
			}
			@Override
			public Adapter caseTRCThreadDeadLockEvent(TRCThreadDeadLockEvent object) {
				return createTRCThreadDeadLockEventAdapter();
			}
			@Override
			public Adapter caseTRCLanguageElement(TRCLanguageElement object) {
				return createTRCLanguageElementAdapter();
			}
			@Override
			public Adapter caseTRCObjectAllocationAnnotation(TRCObjectAllocationAnnotation object) {
				return createTRCObjectAllocationAnnotationAdapter();
			}
			@Override
			public Adapter caseTRCThreadWaitTimeoutExceedEvent(TRCThreadWaitTimeoutExceedEvent object) {
				return createTRCThreadWaitTimeoutExceedEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadWaitingForJoinEvent(TRCThreadWaitingForJoinEvent object) {
				return createTRCThreadWaitingForJoinEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadExecEvent(TRCThreadExecEvent object) {
				return createTRCThreadExecEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadNotifyAllEvent(TRCThreadNotifyAllEvent object) {
				return createTRCThreadNotifyAllEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadNotifyEvent(TRCThreadNotifyEvent object) {
				return createTRCThreadNotifyEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadDeadAndNotifyJoinedEvent(TRCThreadDeadAndNotifyJoinedEvent object) {
				return createTRCThreadDeadAndNotifyJoinedEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadStartThreadEvent(TRCThreadStartThreadEvent object) {
				return createTRCThreadStartThreadEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadInterruptThreadEvent(TRCThreadInterruptThreadEvent object) {
				return createTRCThreadInterruptThreadEventAdapter();
			}
			@Override
			public Adapter caseTRCThreadHandoffLockEvent(TRCThreadHandoffLockEvent object) {
				return createTRCThreadHandoffLockEventAdapter();
			}
			@Override
			public Adapter caseAbstractTRCProcess(AbstractTRCProcess object) {
				return createAbstractTRCProcessAdapter();
			}
			@Override
			public Adapter caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
				return createAbstractTRCCollectionBoundaryAdapter();
			}
			@Override
			public Adapter caseTRCAnnotation(TRCAnnotation object) {
				return createTRCAnnotationAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObject <em>TRC Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObject
	 * @generated
	 */
	public Adapter createTRCObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCClass <em>TRC Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCClass
	 * @generated
	 */
	public Adapter createTRCClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation <em>TRC Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation
	 * @generated
	 */
	public Adapter createTRCMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCProcess <em>TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCProcess
	 * @generated
	 */
	public Adapter createTRCProcessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThread <em>TRC Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThread
	 * @generated
	 */
	public Adapter createTRCThreadAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethod <em>TRC Method</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethod
	 * @generated
	 */
	public Adapter createTRCMethodAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCPackage <em>TRC Package</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCPackage
	 * @generated
	 */
	public Adapter createTRCPackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary <em>TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary
	 * @generated
	 */
	public Adapter createTRCCollectionBoundaryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCClassLoader <em>TRC Class Loader</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader
	 * @generated
	 */
	public Adapter createTRCClassLoaderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCSourceInfo <em>TRC Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfo
	 * @generated
	 */
	public Adapter createTRCSourceInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapObject <em>TRC Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapObject
	 * @generated
	 */
	public Adapter createTRCHeapObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject <em>TRC Full Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject
	 * @generated
	 */
	public Adapter createTRCFullTraceObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCTraceObject <em>TRC Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCTraceObject
	 * @generated
	 */
	public Adapter createTRCTraceObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullHeapObject <em>TRC Full Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullHeapObject
	 * @generated
	 */
	public Adapter createTRCFullHeapObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectReference <em>TRC Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference
	 * @generated
	 */
	public Adapter createTRCObjectReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapDump <em>TRC Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump
	 * @generated
	 */
	public Adapter createTRCHeapDumpAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation <em>TRC Aggregated Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation
	 * @generated
	 */
	public Adapter createTRCAggregatedMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation <em>TRC Full Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation
	 * @generated
	 */
	public Adapter createTRCFullMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapRoot <em>TRC Heap Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot
	 * @generated
	 */
	public Adapter createTRCHeapRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCArrayClass <em>TRC Array Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCArrayClass
	 * @generated
	 */
	public Adapter createTRCArrayClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference <em>TRC Aggregated Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference
	 * @generated
	 */
	public Adapter createTRCAggregatedObjectReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadEvent <em>TRC Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent
	 * @generated
	 */
	public Adapter createTRCThreadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadSleepingEvent <em>TRC Thread Sleeping Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadSleepingEvent
	 * @generated
	 */
	public Adapter createTRCThreadSleepingEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent <em>TRC Thread Waiting For Object Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitingForObjectEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent <em>TRC Thread Waiting For Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitingForLockEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadRunningEvent <em>TRC Thread Running Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadRunningEvent
	 * @generated
	 */
	public Adapter createTRCThreadRunningEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadEvent <em>TRC Thread Dead Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadEvent
	 * @generated
	 */
	public Adapter createTRCThreadDeadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethodWithLLData <em>TRC Method With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethodWithLLData
	 * @generated
	 */
	public Adapter createTRCMethodWithLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLLData <em>TRCLL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLLData
	 * @generated
	 */
	public Adapter createTRCLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData <em>TRC Source Info With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData
	 * @generated
	 */
	public Adapter createTRCSourceInfoWithLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData <em>TRC Line Coverage Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData
	 * @generated
	 */
	public Adapter createTRCLineCoverageDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectValue <em>TRC Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue
	 * @generated
	 */
	public Adapter createTRCObjectValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Input Output Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCInputOutputEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer <em>TRC Input Output Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer
	 * @generated
	 */
	public Adapter createTRCInputOutputContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo <em>TRC Caller Callee Invocation Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo
	 * @generated
	 */
	public Adapter createTRCCallerCalleeInvocationInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue <em>TRC Typed Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue
	 * @generated
	 */
	public Adapter createTRCTypedObjectValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Mthd Lck Acc Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCMthdLckAccEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLockAccess <em>TRC Lock Access</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess
	 * @generated
	 */
	public Adapter createTRCLockAccessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLinePerformanceData <em>TRC Line Performance Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLinePerformanceData
	 * @generated
	 */
	public Adapter createTRCLinePerformanceDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Object Allocation Sites Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCObjectAllocationSitesEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite <em>TRC Object Allocation Site</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite
	 * @generated
	 */
	public Adapter createTRCObjectAllocationSiteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent <em>TRC Thread Dead Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent
	 * @generated
	 */
	public Adapter createTRCThreadDeadLockEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLanguageElement <em>TRC Language Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLanguageElement
	 * @generated
	 */
	public Adapter createTRCLanguageElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCGCEvent <em>TRCGC Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCGCEvent
	 * @generated
	 */
	public Adapter createTRCGCEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation <em>TRC Object Allocation Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation
	 * @generated
	 */
	public Adapter createTRCObjectAllocationAnnotationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent <em>TRC Thread Wait Timeout Exceed Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitTimeoutExceedEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent <em>TRC Thread Waiting For Join Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitingForJoinEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadExecEvent <em>TRC Thread Exec Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadExecEvent
	 * @generated
	 */
	public Adapter createTRCThreadExecEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent <em>TRC Thread Notify All Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent
	 * @generated
	 */
	public Adapter createTRCThreadNotifyAllEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadNotifyEvent <em>TRC Thread Notify Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadNotifyEvent
	 * @generated
	 */
	public Adapter createTRCThreadNotifyEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent <em>TRC Thread Dead And Notify Joined Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent
	 * @generated
	 */
	public Adapter createTRCThreadDeadAndNotifyJoinedEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent <em>TRC Thread Start Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent
	 * @generated
	 */
	public Adapter createTRCThreadStartThreadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent <em>TRC Thread Interrupt Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent
	 * @generated
	 */
	public Adapter createTRCThreadInterruptThreadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent <em>TRC Thread Handoff Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent
	 * @generated
	 */
	public Adapter createTRCThreadHandoffLockEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess <em>Abstract TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess
	 * @generated
	 */
	public Adapter createAbstractTRCProcessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary <em>Abstract TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary
	 * @generated
	 */
	public Adapter createAbstractTRCCollectionBoundaryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCAnnotation <em>TRC Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAnnotation
	 * @generated
	 */
	public Adapter createTRCAnnotationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //TraceAdapterFactory
