/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLCounterDescriptorLoader.java,v 1.5 2010/01/29 17:16:17 jptoomey Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLCounterDescriptorLoader extends XMLDescriptorLoader {

	protected static final String GaugeRepresentation = "GaugeRepresentation";
	protected static final String RangeRepresentation = "RangeRepresentation";
	protected static final String TextRepresentation = "TextRepresentation";
	protected static final String DiscreteRepresentation = "DiscreteRepresentation";
	protected static final String ContiguousRepresentation = "ContiguousRepresentation";
	protected static final String min = "min";
	protected static final String max = "max";
	protected static final String minThreshold = "minThreshold";
	protected static final String maxThreshold = "maxThreshold";

	protected SDRepresentation representation;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		SDCounterDescriptor descriptor = (SDCounterDescriptor) LookupServiceExtensions.getInstance().locate(context, SDDescriptor.class, fId);
		if (descriptor == null) {
			descriptor = StatisticalFactory.eINSTANCE.createSDCounterDescriptor();
			descriptor.setId(fId);
			// Set the name before adding to the model so listeners can react 
			// without needing to wait for a name change
			if (fName != null)
				descriptor.setName(fName);
			LoadersUtils.getOrCreateAgent(context).getDescriptor().add(descriptor);
		}
		updateAttributes((SDMemberDescriptor) descriptor);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#startChild(java.lang.String)
	 */
	public void startChild(String name) {
		if (localDepth == 0) {
			switch (LoadersUtils.getHashCode(name)) {
				case StatisticalConstants.GaugeRepresentation_int :
					representation = StatisticalFactory.eINSTANCE.createSDGaugeRepresentation();
					localDepth++;
					break;
				case StatisticalConstants.RangeRepresentation_int :
					representation = StatisticalFactory.eINSTANCE.createSDRangeRepresentation();
					localDepth++;
					break;
				case StatisticalConstants.TextRepresentation_int :
					representation = StatisticalFactory.eINSTANCE.createSDTextRepresentation();
					localDepth++;
					break;
				case StatisticalConstants.DiscreteRepresentation_int :
					representation = StatisticalFactory.eINSTANCE.createSDDiscreteRepresentation();
					localDepth++;
					break;
				case StatisticalConstants.ContiguousObservation_int :
					representation = StatisticalFactory.eINSTANCE.createSDContiguousRepresentation();
					localDepth++;
					break;
				default :
					super.startChild(name);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#endChild(java.lang.String)
	 */
	public void endChild(String name) {
		super.endChild(name);
		if (localDepth == 1)
			localDepth--;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#updateAttributes(org.eclipse.hyades.model.statistical.SDDescriptor)
	 */
	protected void updateAttributes(SDMemberDescriptor descriptor) {
		super.updateAttributes(descriptor);
		if (representation != null)
			descriptor.setRepresentation(representation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (localDepth == 1) {
			if (representation != null) {
				switch (LoadersUtils.getHashCode(name)) {
					case StatisticalConstants.min_int :
						 ((SDRangeRepresentation) representation).setMin(Integer.parseInt(value));
						break;
					case StatisticalConstants.max_int :
						 ((SDRangeRepresentation) representation).setMax(Integer.parseInt(value));
						break;
					case StatisticalConstants.minThreshold_int :
						 ((SDGaugeRepresentation) representation).setMinThreshold(Integer.parseInt(value));
						break;
					case StatisticalConstants.maxThreshold_int :
						 ((SDGaugeRepresentation) representation).setMaxThreshold(Integer.parseInt(value));
						break;
					default :
						super.addAttribute(name, value);
						break;
				}
				return;
			}
		}
		super.addAttribute(name, value);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		representation = null;
	}

}
