/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLDiscreteObservationLoader.java,v 1.4 2008/01/24 02:52:30 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import java.util.Iterator;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLDiscreteObservationLoader extends SnapshotObservationBase {
	protected Integer fValue;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fValue = null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (name.equals("value")) {
			fValue = Integer.valueOf(value);
		} else
			super.addAttribute(name, value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#updateAttributes(org.eclipse.hyades.model.statistical.SDSnapshotObservation)
	 */
	protected void updateAttributes(SDDiscreteObservation observation) {
		super.updateAttributes(observation);
		observation.getValue().add(fValue);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		super.addYourselfInContext();
		if(mMemberDescriptor==null)
			return;
		SDDiscreteObservation discreteObservation = findDiscreteObservation(mMemberDescriptor);
		if(discreteObservation==null)
		{
			discreteObservation = StatisticalFactory.eINSTANCE.createSDDiscreteObservation();
			mMemberDescriptor.getSnapshotObservation().add(discreteObservation);
		}
		updateAttributes(discreteObservation);
	}

	/**
	 * @param memberDescriptor
	 * @return
	 */
	protected SDDiscreteObservation findDiscreteObservation(SDMemberDescriptor descriptor) {
		for (Iterator iter = descriptor.getSnapshotObservation().iterator(); iter.hasNext();) {
			SDSnapshotObservation element = (SDSnapshotObservation) iter.next();
			
			//TODO: MS add support for multiple windows/views
			if(element instanceof SDDiscreteObservation)
				return (SDDiscreteObservation)element;
		}
		return null;
	}
}
