/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDSampleWindowImpl.java,v 1.5 2009/05/05 15:49:20 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Sample Window</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSampleWindowImpl#getView <em>View</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSampleWindowImpl#getObservations <em>Observations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SDSampleWindowImpl extends EObjectImpl implements SDSampleWindow {
	/**
	 * The cached value of the '{@link #getObservations() <em>Observations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObservations()
	 * @generated
	 * @ordered
	 */
	protected EList<SDSnapshotObservation> observations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDSampleWindowImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StatisticalPackage.Literals.SD_SAMPLE_WINDOW;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDView getView() {
		if (eContainerFeatureID() != StatisticalPackage.SD_SAMPLE_WINDOW__VIEW) return null;
		return (SDView)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetView(SDView newView, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newView, StatisticalPackage.SD_SAMPLE_WINDOW__VIEW, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setView(SDView newView) {
		if (newView != eInternalContainer() || (eContainerFeatureID() != StatisticalPackage.SD_SAMPLE_WINDOW__VIEW && newView != null)) {
			if (EcoreUtil.isAncestor(this, newView))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newView != null)
				msgs = ((InternalEObject)newView).eInverseAdd(this, StatisticalPackage.SD_VIEW__WINDOW, SDView.class, msgs);
			msgs = basicSetView(newView, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_SAMPLE_WINDOW__VIEW, newView, newView));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SDSnapshotObservation> getObservations() {
		if (observations == null) {
			observations = new EObjectContainmentWithInverseEList<SDSnapshotObservation>(SDSnapshotObservation.class, this, StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW);
		}
		return observations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetView((SDView)otherEnd, msgs);
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getObservations()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				return basicSetView(null, msgs);
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				return ((InternalEList<?>)getObservations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				return eInternalContainer().eInverseRemove(this, StatisticalPackage.SD_VIEW__WINDOW, SDView.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				return getView();
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				return getObservations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				setView((SDView)newValue);
				return;
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				getObservations().clear();
				getObservations().addAll((Collection<? extends SDSnapshotObservation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				setView((SDView)null);
				return;
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				getObservations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StatisticalPackage.SD_SAMPLE_WINDOW__VIEW:
				return getView() != null;
			case StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS:
				return observations != null && !observations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //SDSampleWindowImpl
