/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticalAdapterFactory.java,v 1.4 2009/05/05 15:49:20 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDContiguousRepresentation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteRepresentation;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDTextRepresentation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalPackage;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.model.statistical.StatisticalPackage
 * @generated
 */
public class StatisticalAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static StatisticalPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatisticalAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = StatisticalPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StatisticalSwitch<Adapter> modelSwitch =
		new StatisticalSwitch<Adapter>() {
			@Override
			public Adapter caseSDDescriptor(SDDescriptor object) {
				return createSDDescriptorAdapter();
			}
			@Override
			public Adapter caseSDMemberDescriptor(SDMemberDescriptor object) {
				return createSDMemberDescriptorAdapter();
			}
			@Override
			public Adapter caseSDGaugeRepresentation(SDGaugeRepresentation object) {
				return createSDGaugeRepresentationAdapter();
			}
			@Override
			public Adapter caseSDSampleDescriptor(SDSampleDescriptor object) {
				return createSDSampleDescriptorAdapter();
			}
			@Override
			public Adapter caseSDView(SDView object) {
				return createSDViewAdapter();
			}
			@Override
			public Adapter caseSDSampleWindow(SDSampleWindow object) {
				return createSDSampleWindowAdapter();
			}
			@Override
			public Adapter caseSDSnapshotObservation(SDSnapshotObservation object) {
				return createSDSnapshotObservationAdapter();
			}
			@Override
			public Adapter caseSDDiscreteObservation(SDDiscreteObservation object) {
				return createSDDiscreteObservationAdapter();
			}
			@Override
			public Adapter caseSDContiguousObservation(SDContiguousObservation object) {
				return createSDContiguousObservationAdapter();
			}
			@Override
			public Adapter caseSDTextObservation(SDTextObservation object) {
				return createSDTextObservationAdapter();
			}
			@Override
			public Adapter caseSDRangeRepresentation(SDRangeRepresentation object) {
				return createSDRangeRepresentationAdapter();
			}
			@Override
			public Adapter caseSDCounterDescriptor(SDCounterDescriptor object) {
				return createSDCounterDescriptorAdapter();
			}
			@Override
			public Adapter caseSDRepresentation(SDRepresentation object) {
				return createSDRepresentationAdapter();
			}
			@Override
			public Adapter caseSDTextRepresentation(SDTextRepresentation object) {
				return createSDTextRepresentationAdapter();
			}
			@Override
			public Adapter caseSDDiscreteRepresentation(SDDiscreteRepresentation object) {
				return createSDDiscreteRepresentationAdapter();
			}
			@Override
			public Adapter caseSDContiguousRepresentation(SDContiguousRepresentation object) {
				return createSDContiguousRepresentationAdapter();
			}
			@Override
			public Adapter caseAbstractTRCDescription(AbstractTRCDescription object) {
				return createAbstractTRCDescriptionAdapter();
			}
			@Override
			public Adapter caseAbstractTRCView(AbstractTRCView object) {
				return createAbstractTRCViewAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDDescriptor <em>SD Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor
	 * @generated
	 */
	public Adapter createSDDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDMemberDescriptor <em>SD Member Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDMemberDescriptor
	 * @generated
	 */
	public Adapter createSDMemberDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDGaugeRepresentation <em>SD Gauge Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDGaugeRepresentation
	 * @generated
	 */
	public Adapter createSDGaugeRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDSampleDescriptor <em>SD Sample Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDSampleDescriptor
	 * @generated
	 */
	public Adapter createSDSampleDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDView <em>SD View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDView
	 * @generated
	 */
	public Adapter createSDViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDSampleWindow <em>SD Sample Window</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDSampleWindow
	 * @generated
	 */
	public Adapter createSDSampleWindowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation <em>SD Snapshot Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation
	 * @generated
	 */
	public Adapter createSDSnapshotObservationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDDiscreteObservation <em>SD Discrete Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDDiscreteObservation
	 * @generated
	 */
	public Adapter createSDDiscreteObservationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDContiguousObservation <em>SD Contiguous Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDContiguousObservation
	 * @generated
	 */
	public Adapter createSDContiguousObservationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDTextObservation <em>SD Text Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDTextObservation
	 * @generated
	 */
	public Adapter createSDTextObservationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDRangeRepresentation <em>SD Range Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDRangeRepresentation
	 * @generated
	 */
	public Adapter createSDRangeRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDCounterDescriptor <em>SD Counter Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDCounterDescriptor
	 * @generated
	 */
	public Adapter createSDCounterDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDRepresentation <em>SD Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDRepresentation
	 * @generated
	 */
	public Adapter createSDRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDTextRepresentation <em>SD Text Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDTextRepresentation
	 * @generated
	 */
	public Adapter createSDTextRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDDiscreteRepresentation <em>SD Discrete Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDDiscreteRepresentation
	 * @generated
	 */
	public Adapter createSDDiscreteRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.model.statistical.SDContiguousRepresentation <em>SD Contiguous Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.model.statistical.SDContiguousRepresentation
	 * @generated
	 */
	public Adapter createSDContiguousRepresentationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription <em>Abstract TRC Description</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCDescription
	 * @generated
	 */
	public Adapter createAbstractTRCDescriptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCView <em>Abstract TRC View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCView
	 * @generated
	 */
	public Adapter createAbstractTRCViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //StatisticalAdapterFactory
